/*
 * Decompiled with CFR 0.152.
 */
package com.iizigo.server.config;

import com.iizigo.prop.IPropDesigner;
import com.iizigo.prop.tooltip.ITooltipPropList;
import com.iizigo.prop.tooltip.TooltipItem;
import com.iizigo.server.config.EditorServerSettings;
import com.iizigo.server.config.ServerConfigDesignerProp;
import com.iizigo.server.launch.DevelServerLaunchConfigurationTab;
import com.iizix.ILog;
import com.iizix.prop.Atom;
import com.iizix.prop.GProp;
import com.iizix.prop.MailProps;
import com.iizix.prop.PropCnr;
import com.iizix.prop.PropVerification;
import com.iizix.prop.PropVerificationError;
import com.iizix.prop.StringProp;
import java.io.File;
import java.io.IOException;
import java.nio.file.InvalidPathException;
import java.util.List;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class EditorMailProps
extends MailProps
implements IPropDesigner,
ITooltipPropList {
    private ServerConfigDesignerProp a = new ServerConfigDesignerProp((PropCnr)this);
    private static final List<TooltipItem> a;

    static {
        a = List.of(TooltipItem.HEADER_IMAGE_DESCR_TYPE_NAME, TooltipItem.SEPARATOR, TooltipItem.newNormal("Default", Atom.DEFAULT), TooltipItem.newNormal("Description", Atom.DESCR), TooltipItem.SPACER_8PX, TooltipItem.newNormal("debug", "debug"), TooltipItem.newNormal("Directory", "directory"), TooltipItem.newNormal("Mail host", "host"), TooltipItem.newNormal("Default sender", "defaultSender"), TooltipItem.SPACER_8PX, TooltipItem.newNormal("Port", "port"), TooltipItem.newNormal("Use SMTPS protocol", "smtps"), TooltipItem.newNormal("Use STARTTLS", "STARTTLS"), TooltipItem.newNormal("Use SSL", "ssl"), TooltipItem.newNormal("Send timeout in ms", "timeout"), TooltipItem.SPACER_8PX, TooltipItem.newNormal("Server ID check", "serverIDCheck"), TooltipItem.newNormal("User name", "userName"));
    }

    public EditorMailProps() {
    }

    public EditorMailProps(Atom atom) {
        super(atom);
    }

    @Override
    public ServerConfigDesignerProp getDesigner() {
        return this.a;
    }

    public EditorMailProps clone() {
        EditorMailProps editorMailProps = (EditorMailProps)super.clone();
        editorMailProps.a = new ServerConfigDesignerProp((PropCnr)editorMailProps);
        return editorMailProps;
    }

    @Override
    public List<TooltipItem> getTooltipPropertyList() {
        return a;
    }

    public boolean verify(PropVerification propVerification) {
        EditorServerSettings editorServerSettings;
        String string;
        if (!super.verify(propVerification)) {
            return false;
        }
        StringProp stringProp = (StringProp)this.getProp("directory", StringProp.class);
        if (stringProp != null && (string = stringProp.getString()) != null && !string.isEmpty() && (editorServerSettings = (EditorServerSettings)this.getParent(EditorServerSettings.class)) != null) {
            File file;
            String string2 = null;
            try {
                file = DevelServerLaunchConfigurationTab.getDefaultServerDirectory();
            }
            catch (IOException iOException) {
                ILog.WARNING(this.getClass(), (String)("Failed getting server home directory: " + iOException.getMessage()));
                return true;
            }
            if (file != null && file.isDirectory()) {
                File file2 = new File(string);
                try {
                    file2 = file.toPath().resolve(file2.toPath()).toFile();
                    if (!file2.exists()) {
                        string2 = "does not exist";
                    } else if (!file2.isDirectory()) {
                        string2 = "is not a directory";
                    }
                }
                catch (InvalidPathException invalidPathException) {
                    string2 = invalidPathException.getMessage();
                }
                if (string2 != null) {
                    propVerification.add(new PropVerificationError("dir", PropVerificationError.Severity.WARNING, "Directory", (GProp)stringProp, "Mail directory \"" + String.valueOf(file2) + "\" " + string2, new String[0]));
                }
            }
        }
        return true;
    }
}

