/*
 * Decompiled with CFR 0.152.
 */
package com.iizigo.quickfix.fixer;

import com.iizigo.Activator;
import com.iizigo.editor.PropHelper;
import com.iizigo.prop.PropMarker;
import com.iizigo.prop.PropUndoRedoAdapter;
import com.iizigo.quickfix.IQuickFix;
import com.iizigo.quickfix.QuickFixAdapter;
import com.iizix.prop.GProp;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.resources.IMarker;

public class DeleteProperty
extends QuickFixAdapter
implements IQuickFix {
    public static final String ID = "DeleteProperty";
    private String a;
    protected GProp<?> property;

    public DeleteProperty() {
    }

    protected DeleteProperty(GProp<?> gProp) {
        this.a = gProp.getReferencePropName();
    }

    @Override
    public Map<String, Object> getAttributes() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("com.iizigo.propref", this.a);
        return hashMap;
    }

    @Override
    public void run(IMarker iMarker) {
        GProp<?> gProp = PropMarker.getProperty(iMarker);
        if (gProp == null) {
            Activator.messageBox("Property Reference", "Cannot find the Property Reference '" + this.a + "'.", 33);
            return;
        }
        IUndoContext iUndoContext = PropHelper.getUndoContext(gProp);
        if (iUndoContext == null) {
            Activator.messageBox("Property Reference", "Cannot find the Undo Context for the Property Reference '" + this.a + "'.", 33);
            return;
        }
        PropHelper.doDelete("Delete property (quick fix)", new GProp[]{gProp}, new PropUndoRedoAdapter(Activator.getSomeShell(), iUndoContext), null);
    }

    @Override
    public void setMarker(IMarker iMarker) {
        super.setMarker(iMarker);
        this.property = PropMarker.getProperty(iMarker);
    }

    @Override
    public String getID() {
        return ID;
    }

    @Override
    public String getLabel() {
        return "Delete property";
    }
}

