/*
 * Decompiled with CFR 0.152.
 */
package com.iizigo.panel.prop;

import com.iizigo.ApplicationUI;
import com.iizigo.editor.PropHelper;
import com.iizigo.editor.complex.ComplexOperation;
import com.iizigo.panel.DropInfo;
import com.iizigo.panel.prop.EBorderData;
import com.iizigo.panel.prop.EBorderLayout0;
import com.iizigo.panel.prop.IClearComponentArea;
import com.iizigo.panel.prop.IELayoutMgrDND;
import com.iizigo.panel.prop.IReplaceLayoutData;
import com.iizigo.panel.prop.UILayoutDesignerProp;
import com.iizigo.panel.wizards.AddUICompWizard;
import com.iizigo.prop.tooltip.TooltipItem;
import com.iizix.ILog;
import com.iizix.prop.Atom;
import com.iizix.prop.GProp;
import com.iizix.prop.GUnit;
import com.iizix.prop.IGProp;
import com.iizix.prop.IntProp;
import com.iizix.prop.PropCnr;
import com.iizix.prop.PropValidateException;
import com.iizix.prop.PropVerification;
import com.iizix.prop.PropVerificationError;
import com.iizix.prop.UnitProp;
import com.iizix.prop.ui.BorderData;
import com.iizix.prop.ui.BorderLayout;
import com.iizix.prop.ui.LayoutMgr;
import com.iizix.prop.ui.LayoutProp;
import com.iizix.prop.ui.UIComp;
import com.iizix.prop.ui.UIComps;
import com.iizix.prop.ui.UIContainer;
import java.util.List;
import org.eclipse.swt.graphics.Image;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class EBorderLayout
extends BorderLayout
implements IELayoutMgrDND<EBorderData>,
IReplaceLayoutData {
    private UILayoutDesignerProp a = new UILayoutDesignerProp((LayoutMgr<?>)this);
    private static final List<TooltipItem> a;

    static {
        a = List.of(TooltipItem.HEADER_IMAGE_DESCR_TYPE, TooltipItem.SEPARATOR, TooltipItem.newNormal("Gutters", "gutters"), TooltipItem.newIntIndex("Layout look", "bclook", new String[]{"headline", "sidebar"}), TooltipItem.newNormal("Live resize", "liveSize"));
    }

    public EBorderLayout() {
    }

    public EBorderLayout(Atom atom) {
        super(atom);
    }

    @Override
    public Class<EBorderData> getLayoutDataClass() {
        return EBorderData.class;
    }

    @Override
    public boolean isCNVisible() {
        return true;
    }

    @Override
    public UILayoutDesignerProp getDesigner() {
        return this.a;
    }

    @Override
    public Object[] getPropertyEditorLayoutDataSetup() {
        return EBorderData.a;
    }

    @Override
    public Image getCNImage(boolean bl) {
        return ApplicationUI.getInstance().imageUIBorderLayout;
    }

    @Override
    public String getCNDescriptionType() {
        return "Border layout";
    }

    public EBorderLayout clone() {
        EBorderLayout eBorderLayout = (EBorderLayout)super.clone();
        eBorderLayout.a = new UILayoutDesignerProp((LayoutMgr<?>)eBorderLayout);
        return eBorderLayout;
    }

    @Override
    public boolean isReplaceable() {
        return true;
    }

    @Override
    public EBorderData createDefaultLayoutProp(UIComp uIComp) {
        return new EBorderData(uIComp);
    }

    @Override
    public Object[] getTransferProps() {
        return EBorderLayout0.setup;
    }

    public boolean verify(PropVerification propVerification) {
        BorderData borderData;
        LayoutProp layoutProp;
        UIComp uIComp;
        if (!super.verify(propVerification)) {
            return false;
        }
        boolean bl = false;
        boolean bl2 = false;
        UIComp[] uICompArray = this.getUIComps();
        int n2 = uICompArray.length;
        int n3 = 0;
        while (n3 < n2) {
            uIComp = uICompArray[n3];
            layoutProp = uIComp.getLayout();
            if (layoutProp instanceof BorderData && (borderData = (BorderData)layoutProp).getRegion() == 5) {
                if (bl) {
                    bl2 = true;
                } else {
                    bl = true;
                }
            }
            ++n3;
        }
        if (bl2) {
            propVerification.add(new PropVerificationError("many.center", PropVerificationError.Severity.ERROR, "Border layout", (GProp)this.getParent(), "Multiple components in center region", new String[0]));
            uICompArray = this.getUIComps();
            n2 = uICompArray.length;
            n3 = 0;
            while (n3 < n2) {
                IntProp intProp;
                uIComp = uICompArray[n3];
                layoutProp = uIComp.getLayout();
                if (layoutProp instanceof BorderData && (intProp = (IntProp)(borderData = (BorderData)layoutProp).getProp("region", IntProp.class)) != null && intProp.getInt() == 5) {
                    propVerification.add(new PropVerificationError("many.center", PropVerificationError.Severity.WARNING, "Region", (GProp)intProp, "Only one component in center allowed", new String[0]));
                }
                ++n3;
            }
        }
        return true;
    }

    @Override
    public void checkReplaceLayoutData(ComplexOperation complexOperation, UIComp uIComp) {
        LayoutProp layoutProp = uIComp.getLayout();
        if (!(layoutProp instanceof EBorderData)) {
            GUnit gUnit = layoutProp.getLayoutWidth();
            GUnit gUnit2 = layoutProp.getLayoutHeight();
            EBorderData eBorderData = new EBorderData(Atom.LAYOUT);
            if (gUnit != null) {
                eBorderData.addProp2((IGProp)new UnitProp(Atom.get((String)"cx"), gUnit));
            }
            if (gUnit2 != null) {
                eBorderData.addProp2((IGProp)new UnitProp(Atom.get((String)"cy"), gUnit2));
            }
            int n2 = layoutProp.getInt("alignX");
            int n3 = layoutProp.getInt("alignY");
            if (n2 > 0) {
                eBorderData.setInt("alignX", n2);
            }
            if (n3 > 0) {
                eBorderData.setInt("alignY", n3);
            }
            if (complexOperation == null) {
                uIComp.removeProp2((IGProp)layoutProp);
                uIComp.addProp2((IGProp)eBorderData);
            } else {
                complexOperation.removeProp((GProp<?>)layoutProp);
                complexOperation.addProp((PropCnr)uIComp, (GProp<?>)eBorderData);
            }
        }
    }

    @Override
    public void convertLayout(ComplexOperation complexOperation, UIContainer uIContainer, LayoutMgr<?> layoutMgr) {
        UIComp[] uICompArray = uIContainer.getCompsCnr().getUIComps();
        int n2 = uICompArray.length;
        int n3 = 0;
        while (n3 < n2) {
            UIComp uIComp = uICompArray[n3];
            this.checkReplaceLayoutData(complexOperation, uIComp);
            ++n3;
        }
    }

    @Override
    public UIComp[] onDrop(DropInfo dropInfo) {
        IClearComponentArea iClearComponentArea;
        IntProp intProp;
        int n2;
        LayoutProp layoutProp;
        LayoutProp layoutProp2;
        int n3;
        String string;
        int n4 = dropInfo.trans.readByte();
        int n5 = -1;
        String string2 = dropInfo.trans.readString();
        if (!string2.isEmpty()) {
            int n6 = string2.indexOf(Atom.COMPONENTS.getAtomName());
            if (n6 < 0) {
                ILog.SEVERE(this.getClass(), (String)("Drop layout manager path '" + string2 + "' is invalid, doesn't contain " + Atom.COMPONENTS.getAtomName()));
                return null;
            }
            GProp gProp = this.getPropFromPath(string2 = string2.substring(n6));
            if (!(gProp instanceof UIComp)) {
                ILog.SEVERE(this.getClass(), (String)("Drop layout manager '" + string2 + "' is not UIComp: " + String.valueOf(gProp)));
                return null;
            }
            string = (UIComp)gProp;
            if (string.getUIParent() != this.getParent()) {
                ILog.SEVERE(this.getClass(), (String)("Drop layout manager '" + string2 + "' relative component " + String.valueOf(gProp) + " is not a direct child of container " + String.valueOf(this.getParent())));
                return null;
            }
            n5 = gProp.getPropIndex();
            if (n4 == 4 || n4 == 8) {
                ++n5;
            }
        }
        string = (n3 = ((UIComp[])(layoutProp2 = dropInfo.comps)).length) > 1 ? "components" : "component";
        ComplexOperation complexOperation = new ComplexOperation(dropInfo.isCopy ? "Copy " + string : "Move " + string, dropInfo.panelEditor, dropInfo.panelEditor);
        UIComps uIComps = this.getCompsCnr();
        if (dropInfo.isWizardEditingRequested && !AddUICompWizard.doWizardBeforeDrop(layoutProp2[0], uIComps, complexOperation)) {
            System.err.println("Drop-operation canceled by user");
            return null;
        }
        PropCnr propCnr = null;
        if (dropInfo.isCopy) {
            layoutProp2 = (UIComp[])layoutProp2.clone();
            int n7 = n3;
            while (--n7 >= 0) {
                UIComp uIComp = layoutProp2[n7];
                uIComp = layoutProp2[n7] = uIComp.clone();
                this.checkReplaceLayoutData(null, uIComp);
                if (n4 <= 0) continue;
                uIComp.getLayout().setInt("region", n4);
            }
        } else {
            layoutProp = layoutProp2;
            n2 = ((UIComp[])layoutProp).length;
            int n8 = 0;
            while (n8 < n2) {
                UIComp uIComp = layoutProp[n8];
                intProp = uIComp.getUIParent().getLayoutMgr();
                if (intProp instanceof IClearComponentArea) {
                    iClearComponentArea = (IClearComponentArea)intProp;
                    if (propCnr == null) {
                        propCnr = new PropCnr(Atom.TRANSACTION);
                        complexOperation.addProp((PropCnr)this, (GProp<?>)propCnr);
                    }
                    PropCnr propCnr2 = new PropCnr(propCnr.createUniqueAtom(""));
                    complexOperation.addProp(propCnr, (GProp<?>)propCnr2);
                    complexOperation.moveProp((GProp<?>)uIComp, propCnr2, null, -1);
                    iClearComponentArea.clearComponentArea(complexOperation, uIComp);
                }
                ++n8;
            }
        }
        Atom[] atomArray = PropHelper.getUniqueNames((PropCnr)uIComps, dropInfo.comps, dropInfo.isCopy ? " Copy" : " Moved", dropInfo.isCopy);
        int n9 = 0;
        while (n9 < n3) {
            UIComp uIComp = layoutProp2[n9];
            if (dropInfo.isCopy) {
                try {
                    uIComp = uIComp.clone();
                    uIComp.renameProp(atomArray[n9]);
                    layoutProp2[n9] = uIComp;
                }
                catch (Exception exception) {
                    ILog.SEVERE(this.getClass(), (String)"Failed clone-rename", (Object[])new Object[]{uIComp, exception});
                }
                complexOperation.insertProp((PropCnr)uIComps, (GProp<?>)uIComp, n5);
                if (n5 >= 0) {
                    ++n5;
                }
            } else {
                complexOperation.moveProp((GProp<?>)uIComp, (PropCnr)uIComps, atomArray[n9], n5);
                n5 = uIComp.getPropIndex() + 1;
                this.checkReplaceLayoutData(complexOperation, uIComp);
                if (n4 > 0) {
                    layoutProp = uIComp.getLayout();
                    intProp = (IntProp)layoutProp.getProp("region", IntProp.class);
                    if (intProp == null) {
                        try {
                            complexOperation.addProp((PropCnr)layoutProp, (GProp<?>)new IntProp(Atom.get((String)"region"), n4));
                        }
                        catch (PropValidateException propValidateException) {
                            throw new InternalError("Failed creating region IntProp", propValidateException);
                        }
                    } else {
                        complexOperation.setPropValue((GProp<?>)intProp, n4);
                    }
                }
            }
            ++n9;
        }
        if (propCnr != null) {
            intProp = propCnr.getProps();
            int n10 = ((GProp[])intProp).length;
            n2 = 0;
            while (n2 < n10) {
                GProp gProp = intProp[n2];
                iClearComponentArea = (PropCnr)gProp;
                assert (iClearComponentArea.getPropCount() == 0) : "Temp-wrap-container not empty!";
                complexOperation.removeProp(gProp);
                ++n2;
            }
            complexOperation.removeProp((GProp<?>)propCnr);
        }
        PropHelper.executeOperation(dropInfo.panelEditor.getShell(), complexOperation);
        return layoutProp2;
    }

    @Override
    public List<TooltipItem> getTooltipPropertyList() {
        return a;
    }
}

