/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.server.prop;

import com.iizix.ILog;
import com.iizix.NotFoundException;
import com.iizix.comm.IServerSettings;
import com.iizix.jetty.WSHelper;
import com.iizix.mail.MailSender;
import com.iizix.passwordpolicy.PasswordPolicy;
import com.iizix.prop.Atom;
import com.iizix.prop.BoolProp;
import com.iizix.prop.GProp;
import com.iizix.prop.IGProp;
import com.iizix.prop.IntProp;
import com.iizix.prop.MailProps;
import com.iizix.prop.PasswordProp;
import com.iizix.prop.PolicyProps;
import com.iizix.prop.PropCnr;
import com.iizix.prop.PropException;
import com.iizix.prop.PropVerification;
import com.iizix.prop.PropVerificationError;
import com.iizix.prop.StringProp;
import com.iizix.server.acme.LetsEncryptDomain;
import com.iizix.server.app.AppFactory;
import com.iizix.server.gyro.AppSessionGyro;
import com.iizix.server.prop.ServerAppConfig;
import com.iizix.server.prop.ServerApplicationSetupException;
import com.iizix.server.prop.ServerConfigEnvProps;
import com.iizix.server.prop.ServerProps;
import com.iizix.server.prop.WebServerPortConfig;
import jakarta.mail.NoSuchProviderException;
import jakarta.mail.internet.AddressException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.time.ZoneId;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Objects;
import java.util.TimeZone;
import java.util.concurrent.ExecutorService;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class ServerSettings
extends PropCnr
implements IServerSettings {
    public static final String CONFIG_FILE_EXT = ".iiziServer";
    public static final String CONFIG_FILE_DEFAULT_BASE_NAME = "config";
    public static final String CONFIG_FILE_DEFAULT_NAME = "config.iiziServer";
    public static final String DEFAULT_SERVER_CONFIG_ENV = "$defaultConfigEnv";
    public static final String IDLE_TIMEOUT = "$idleTimeout";
    public static final String DORMANT_TIMEOUT = "$dormantTimeout";
    public static final String HEARTBEAT_INTERVAL = "$heartBeatInterval";
    public static final String TRANS_CACHE_MIN = "$cache.minLength";
    public static final String TRANS_CACHE_MAX = "$cache.maxLength";
    public static final String TRANS_CACHE_COUNT = "$cache.count";
    public static final String REDIRECT_CODE_HTTP_to_HTTPS = "$redirCodeHttp";
    public static final String EXTERNAL_SERVER_URL = "$extServerURL";
    public static final String WS_LOG_DIR = "$wsLogDir";
    public static final String WS_LOG_RETAIN_DAYS = "$wsLogRetainDays";
    public static final String WS_LOG_TIME_ZONE = "$wsLogTimeZone";
    public static final String DIR_LIST = "$dirList";
    public static final String GZIP = "$gzip";
    public static final String WS_IDLE_TIMEOUT = "$wsIdle";
    public static final String WS_MAX_THREADS = "$wsMaxThreads";
    public static final String WS_MIN_THREADS = "$wsMinThreads";
    public static final String WS_RESERVED_THREADS = "$wsReservedThreads";
    public static final String REALM = "$realm";
    public static final String REALM_PROPERTIES = "$realmProperties";
    public static final String AUTH_BASIC = "$auth.basic";
    public static final String MAX_SERVER_KEY_AGE = "$maxServerKeyAge";
    public static final int DEFAULT_MAX_SERVER_KEY_AGE = 90;
    public static final String FILE_PROVIDER_ROOT = "$fileProviderRoot";
    public static final String DEFAULT_FILE_PROVIDER_ROOT = "wsfiles";
    public static final String URLBOX_IO_API_KEY = "$urlbox.io.apiKey";
    public static final String MAX_CONCURRENT_THUMBNAILS_COUNT = "$urlbox.io.maxCount";
    public static final int DEFAULT_MAX_CONCURRENT_THUMBNAILS_COUNT = 5;
    public static final String MAX_HISTORY_LOCATION = "$maxLocationHistory";
    public static final int DEFAULT_MAX_HISTORY_LOCATION = 100;
    public static final String DB_AUTO_CREATE = "$dbAutoCreate";
    public static final String DB_DIRECTORY = "$dbDirectory";
    public static final String DB_HOST = "$dbHost";
    public static final String DB_PORT = "$dbPort";
    public static final String DB_AUTO_START = "$dbAutoStart";
    public static final String DB_MAX_FILE_COUNT = "$dbMaxFiles";
    public static final int DEFAULT_DB_MAX_FILE_COUNT = 10000;
    public static final String DB_MAX_FILE_AGE = "$dbMaxFileAge";
    public static final long DEFAULT_DB_MAX_FILE_AGE = 7776000000L;
    public static final String LOGFILE_NAME = "$logFileName";
    public static final String DEFAULT_LOGFILE_NAME = "logs/server.log";
    public static final String MAX_LOGFILE_SIZE = "$maxLogFileSize";
    public static final int DEFAULT_MAX_LOGFILE_SIZE = 50;
    public static final String LOG_LEVEL = "$logLevel";
    public static final int DEFAULT_LOG_LEVEL = 3;
    public static final String LOG_TO_CONSOLE = "$logToConsole";
    public static final String LOG_HISTORY_SIZE = "$logHistorySize";
    public static final String LOG_COMPRESS = "$logCompress";
    public static final int DEFAULT_LOG_HISTORY_SIZE = 500;
    public static final String ALLOW_UPLOAD = "$upload.allow";
    public static final String MAX_UPLOAD_SIZE = "$upload.maxSize";
    public static final int DEFAULT_MAX_UPLOAD_SIZE = 50;
    public static final String UPLOAD_DIRECTORY = "$upload.dir";
    public static final String DEFAULT_UPLOAD_DIRECTORY = "uploads";
    private static final ZoneId a = ZoneId.of("GMT");
    private PasswordPolicy a;
    private PasswordPolicy b;
    private ServerConfigEnvProps[] a;
    private final HashMap<String, a> a = new HashMap();

    public ServerSettings() {
    }

    public ServerSettings(Atom atom) {
        super(atom);
    }

    protected void addPredefinedProps() throws PropException {
        super.addPredefinedProps();
        this.maybeAddProp((IGProp)this.createPolicyProps(PolicyProps.AN_ADMIN));
        this.maybeAddProp((IGProp)this.createPolicyProps(PolicyProps.AN_USER));
    }

    public ServerSettings clone() {
        try {
            ServerSettings serverSettings = (ServerSettings)super.clone();
            serverSettings.a = null;
            serverSettings.b = null;
            return serverSettings;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError("Shouldn't be", cloneNotSupportedException);
        }
    }

    public String getDescription() {
        return this.getString(Atom.DESCR, "iiziServer");
    }

    public boolean setDescription(String string) {
        return this.setString(Atom.DESCR, Objects.requireNonNull(string));
    }

    public String getLogFileName() {
        return this.getString(LOGFILE_NAME, DEFAULT_LOGFILE_NAME);
    }

    public long getMaximumLogFileSize() {
        int n = this.getInt(MAX_LOGFILE_SIZE, 50);
        return n > 0 ? n * 0x100000 : 0;
    }

    public int getLogLevel() {
        int n = this.getInt(LOG_LEVEL, 3);
        return Math.max(1, Math.min(7, n));
    }

    public boolean getLogToConsole() {
        return this.getBool(LOG_TO_CONSOLE, true);
    }

    public int getLogHistorySize() {
        int n = this.getInt(LOG_HISTORY_SIZE, 500);
        return n < 100 ? 100 : (n > 5000 ? 5000 : n);
    }

    public PasswordPolicy getAdministratorPasswordPolicy() {
        PasswordPolicy passwordPolicy = this.a;
        if (passwordPolicy == null) {
            PolicyProps policyProps = (PolicyProps)this.getProp(PolicyProps.AN_ADMIN, PolicyProps.class);
            if (policyProps == null) {
                policyProps = this.createPolicyProps(PolicyProps.AN_ADMIN);
            }
            this.a = passwordPolicy = PasswordPolicy.from((PolicyProps)policyProps);
        }
        return passwordPolicy;
    }

    public PasswordPolicy getUserPasswordPolicy() {
        PasswordPolicy passwordPolicy = this.b;
        if (passwordPolicy == null) {
            PolicyProps policyProps = (PolicyProps)this.getProp(PolicyProps.AN_USER, PolicyProps.class);
            if (policyProps == null) {
                policyProps = this.createPolicyProps(PolicyProps.AN_USER);
            }
            this.b = passwordPolicy = PasswordPolicy.from((PolicyProps)policyProps);
        }
        return passwordPolicy;
    }

    protected PolicyProps createPolicyProps(Atom atom) {
        return new PolicyProps(atom);
    }

    public int getWSRedirectCodeHTTP_to_HTTPS() {
        int n = this.getInt(REDIRECT_CODE_HTTP_to_HTTPS);
        if (n != 301 && n != 302) {
            n = 0;
        }
        return n;
    }

    public boolean setExternalHostName(String string) {
        if (string == null) {
            throw new NullPointerException("extServerURL is null");
        }
        if (string.isEmpty()) {
            throw new IllegalArgumentException("extServerURL is empty");
        }
        String string2 = WSHelper.validateExternalHostName((String)string);
        if (string2 != null) {
            throw new IllegalArgumentException(string2);
        }
        return this.setString(EXTERNAL_SERVER_URL, string);
    }

    public String getExternalHostName() {
        String string = this.getString(EXTERNAL_SERVER_URL);
        return string != null && !string.isEmpty() ? string : null;
    }

    public boolean setRootDirectory(String string) throws IOException {
        File file = new File(string).getCanonicalFile();
        string = file.getPath();
        if (!file.isDirectory()) {
            throw new FileNotFoundException("Root directory not found: " + string);
        }
        return this.setString(Atom.ROOT, string);
    }

    public String getRootDirectory() {
        String string = this.getString(Atom.ROOT, "./root");
        File file = new File(string).getAbsoluteFile();
        if (!file.exists()) {
            if (!file.mkdirs()) {
                ILog.SEVERE(((Object)((Object)this)).getClass(), (String)("Cannot create the Server root directory \"" + string + "\""));
                string = null;
            }
        } else if (!file.isDirectory()) {
            ILog.SEVERE(((Object)((Object)this)).getClass(), (String)("The Server root directory \"" + string + "\" is not a directory"));
            string = null;
        } else if (!file.canRead() || !file.canWrite()) {
            ILog.SEVERE(((Object)((Object)this)).getClass(), (String)("Cannot read or write to the Server root directory \"" + string + "\""));
            string = null;
        } else {
            try {
                string = file.getCanonicalPath();
            }
            catch (Exception exception) {
                string = file.getAbsolutePath();
            }
        }
        return string;
    }

    public String getWSLogDirectory() throws IOException {
        String string = this.getString(WS_LOG_DIR, "./logs/web");
        if (string.isBlank()) {
            return null;
        }
        File file = new File(string);
        try {
            file = file.getCanonicalFile();
            string = file.getPath();
            if (!file.exists()) {
                Files.createDirectories(file.toPath(), new FileAttribute[0]);
                ILog.INFO(((Object)((Object)this)).getClass(), (String)"Web server log file directory created: {}", (Object)file);
            } else if (!file.isDirectory()) {
                ILog.SEVERE(((Object)((Object)this)).getClass(), (String)"The web server logs directory \"{}\" is not a directory", (Object)file);
                string = null;
            } else if (!file.canRead() || !file.canWrite()) {
                ILog.SEVERE(((Object)((Object)this)).getClass(), (String)"Cannot read or write to the web server logs directory \"{}\"", (Object)file);
                string = null;
            }
        }
        catch (Throwable throwable) {
            ILog.SEVERE(((Object)((Object)this)).getClass(), (String)"Cannot create the web server logs directory \"{}\"", (Object[])new Object[]{string, throwable});
            string = null;
        }
        return string;
    }

    public int getWSLogsRetainDays() {
        int n = this.getInt(WS_LOG_RETAIN_DAYS, 14);
        return n > 0 && n <= 365 ? n : 0;
    }

    public String getWSLogTimeZone() {
        ZoneId zoneId = a;
        String string = this.getString(WS_LOG_TIME_ZONE);
        if (string != null && !string.isBlank()) {
            try {
                zoneId = ZoneId.of(string);
            }
            catch (Throwable throwable) {
                ILog.WARNING(((Object)((Object)this)).getClass(), (String)"Time zone specified for web server log files is invalid", (Throwable)throwable);
            }
        }
        return TimeZone.getTimeZone(zoneId).getID();
    }

    public boolean isDirectoryListingAllowed() {
        return this.getBool(DIR_LIST);
    }

    public boolean useGzip() {
        return this.getBool(GZIP, true);
    }

    public int getWSMaxThreads() {
        int n = this.getInt(WS_MAX_THREADS, 200);
        if (n < 20 || n > 1024) {
            n = 200;
        }
        int n2 = this.getWSMinThreads();
        return Math.max(n2, n);
    }

    public int getWSMinThreads() {
        int n = this.getInt(WS_MIN_THREADS, 8);
        if (n < 20 || n > 1024) {
            n = 8;
        }
        return n;
    }

    public int getWSReservedThreads() {
        int n = this.getInt(WS_RESERVED_THREADS);
        return n >= 8 && n <= 64 ? n : -1;
    }

    public int getWSIdleTimeout() {
        long l = this.getLong(WS_IDLE_TIMEOUT);
        return l >= 5000L && l <= 300000L ? (int)l : 60000;
    }

    public String getFileProviderRoot() {
        String string = this.getString(FILE_PROVIDER_ROOT, DEFAULT_FILE_PROVIDER_ROOT);
        return File.separatorChar == '/' ? string.replace('\\', '/') : string.replace('/', '\\');
    }

    public String getRealmPropertiesFileName() {
        String string = this.getString(REALM_PROPERTIES);
        return string != null && !string.isEmpty() ? string : "authentication-realm-properties.txt";
    }

    public String getAuthenticationRealm() {
        String string = this.getString(REALM);
        return string != null && !string.isEmpty() ? string : "iiziServer Authentication";
    }

    public boolean isBasicAuthenticationEnabled() {
        return this.getBool(AUTH_BASIC);
    }

    public String getUrlboxIOAPIKey() {
        PasswordProp passwordProp = (PasswordProp)this.getProp(URLBOX_IO_API_KEY, PasswordProp.class);
        if (passwordProp == null) {
            return "";
        }
        return passwordProp.getString("");
    }

    public int getMaxConcurrentThumbnailsRequests() {
        int n = this.getInt(MAX_CONCURRENT_THUMBNAILS_COUNT, 5);
        return Math.max(1, Math.min(100, n));
    }

    public boolean isFileUploadEnabled() {
        return this.getBool(ALLOW_UPLOAD, true);
    }

    public int getMaximumUploadFileSize() {
        return this.getInt(MAX_UPLOAD_SIZE, 50);
    }

    public String getFileUploadStagingDirectory() {
        return this.getString(UPLOAD_DIRECTORY, DEFAULT_UPLOAD_DIRECTORY);
    }

    public int getMaximumGeolocationHistorySizePerUser() {
        return Math.min(10000, Math.max(10, this.getInt(MAX_HISTORY_LOCATION, 100)));
    }

    public long getClientIdleTimeout() {
        long l = this.getLong(IDLE_TIMEOUT, 0x6DDD00L);
        return Math.max(120000L, Math.min(172800000L, l));
    }

    public long getClientDormantTimeout() {
        long l = this.getLong(DORMANT_TIMEOUT, 600000L);
        return Math.max(120000L, Math.min(43200000L, l));
    }

    public long getClientHeartBeatInterval() {
        long l = this.getLong(HEARTBEAT_INTERVAL, 45000L);
        return Math.max(30000L, Math.min(300000L, l));
    }

    public int getMaximumServerKeyAge() {
        int n = this.getInt(MAX_SERVER_KEY_AGE, 90);
        return Math.max(7, Math.min(365, n));
    }

    public void setCacheParams(int n, int n2, int n3) {
        if (n2 <= n || n < 7 || n2 > 1024 || n3 < 100 || n3 > 2048) {
            throw new IllegalArgumentException("Arguments not valid");
        }
        this.setInt(TRANS_CACHE_MIN, n);
        this.setInt(TRANS_CACHE_MAX, n2);
        this.setInt(TRANS_CACHE_COUNT, n3);
    }

    public int[] getCacheParams() {
        int[] nArray = new int[3];
        try {
            int n = this.getInt(TRANS_CACHE_MIN);
            int n2 = this.getInt(TRANS_CACHE_MAX);
            int n3 = this.getInt(TRANS_CACHE_COUNT);
            if (n3 < 200 || n3 > 8192 || n < 7 || n2 < n + 1 || n2 > 1024) {
                throw new Exception();
            }
            nArray[0] = n;
            nArray[1] = n2;
            nArray[2] = n3;
        }
        catch (Exception exception) {
            nArray[0] = 7;
            nArray[1] = 200;
            nArray[2] = 700;
        }
        return nArray;
    }

    public WebServerPortConfig[] getPortConfigurations() {
        return (WebServerPortConfig[])this.getProps(WebServerPortConfig.class);
    }

    public LetsEncryptDomain[] getLetsEncryptDomains() {
        return (LetsEncryptDomain[])this.getProps(LetsEncryptDomain.class);
    }

    public String getDefaultServerConfigurationEnvironmentName() {
        return this.getString(DEFAULT_SERVER_CONFIG_ENV, "default");
    }

    public ServerConfigEnvProps getServerConfigEnvironment(String string) {
        if (string == null) {
            string = this.getDefaultServerConfigurationEnvironmentName();
        }
        return (ServerConfigEnvProps)this.getProp(string, ServerConfigEnvProps.class);
    }

    public ServerConfigEnvProps[] getServerConfigEnvironments() {
        ServerConfigEnvProps[] serverConfigEnvPropsArray = this.a;
        if (serverConfigEnvPropsArray == null) {
            this.a = (ServerConfigEnvProps[])this.getProps(ServerConfigEnvProps.class);
            serverConfigEnvPropsArray = this.a;
        }
        return serverConfigEnvPropsArray;
    }

    protected void onServerSettingsChanged() {
        ServerProps serverProps = (ServerProps)this.getParent(ServerProps.class);
        serverProps.serverSettings = this;
        this.a = null;
    }

    public int getDBCacheMaxFileCount() {
        return Math.max(100, this.getInt(DB_MAX_FILE_COUNT, 10000));
    }

    public long getDBCacheMaxFileAge() {
        return Math.max(3600000L, this.getLong(DB_MAX_FILE_AGE, 7776000000L));
    }

    public boolean verify(PropVerification propVerification) {
        ServerAppConfig[] serverAppConfigArray;
        int n;
        Object object;
        int n2;
        Object object2;
        WebServerPortConfig webServerPortConfig;
        int n3;
        Object object3;
        if (!super.verify(propVerification)) {
            return false;
        }
        String string = this.getString(DB_DIRECTORY);
        StringProp stringProp = (StringProp)this.getProp(DB_HOST, StringProp.class);
        IntProp intProp = (IntProp)this.getProp(DB_PORT, IntProp.class);
        if (string != null && (stringProp != null || intProp != null)) {
            propVerification.add(new PropVerificationError("db.dir", PropVerificationError.Severity.ERROR, "Database directory", this.getProp(DB_DIRECTORY), "Database directory should not be specified together with database server settings such as Host name or Port number, they are mutually exclusive", new String[0]));
            if (stringProp != null) {
                propVerification.add(new PropVerificationError("db.host", PropVerificationError.Severity.ERROR, "Host name", (GProp)stringProp, "Host name and Database directory should not be specified together, they are mutually exclusive", new String[0]));
            }
            if (intProp != null) {
                propVerification.add(new PropVerificationError("db.port", PropVerificationError.Severity.ERROR, "Port number", (GProp)intProp, "Port number and Database directory should not be specified together, they are mutually exclusive", new String[0]));
            }
        }
        if ("".equals(string)) {
            propVerification.add(new PropVerificationError("db.host", PropVerificationError.Severity.ERROR, "Database directory", this.getProp(DB_DIRECTORY), "Database directory cannot be empty", new String[0]));
        }
        if (stringProp != null && "".equals(stringProp.getString())) {
            propVerification.add(new PropVerificationError("db.host", PropVerificationError.Severity.ERROR, "Host name", (GProp)stringProp, "Host name cannot be empty", new String[0]));
        }
        if (this.isBasicAuthenticationEnabled()) {
            stringProp = (StringProp)this.getProp(REALM, StringProp.class);
            if (stringProp == null) {
                propVerification.add(new PropVerificationError((PropCnr)this, REALM, PropVerificationError.Severity.ERROR, "Realm", "Missing value: Realm authentication string", new String[0]));
            } else {
                object3 = stringProp.getString();
                if (object3 == null || ((String)object3).isEmpty()) {
                    propVerification.add(new PropVerificationError("realm", PropVerificationError.Severity.ERROR, "Realm", (GProp)stringProp, "The Realm authentication string must be specified", new String[0]));
                }
            }
        }
        object3 = (IntProp)this.getProp(WS_MAX_THREADS, IntProp.class);
        IntProp intProp2 = (IntProp)this.getProp(WS_MIN_THREADS, IntProp.class);
        int n4 = object3 != null ? object3.getInt(200) : 200;
        int n5 = n3 = intProp2 != null ? intProp2.getInt(8) : 8;
        if (n4 < n3) {
            if (object3 != null) {
                propVerification.add(new PropVerificationError(WS_MAX_THREADS, PropVerificationError.Severity.ERROR, "Maximum threads", (GProp)object3, "Maximum thread count (" + n4 + ") for web server must be larger or equal to the Minimum thread count (" + n3 + ")", new String[0]));
            }
            if (intProp2 != null) {
                propVerification.add(new PropVerificationError(WS_MIN_THREADS, PropVerificationError.Severity.ERROR, "Minimum threads", (GProp)intProp2, "Minimum thread count (" + n3 + ") for web server must be smaller or equal to the Maximum thread count (" + n4 + ")", new String[0]));
            }
        }
        HashSet<String> hashSet = new HashSet<String>();
        PropCnr[] propCnrArray = (WebServerPortConfig[])this.getProps(WebServerPortConfig.class);
        int n6 = propCnrArray.length;
        int n7 = 0;
        while (n7 < n6) {
            webServerPortConfig = propCnrArray[n7];
            if (webServerPortConfig.isLocalHTTPS()) {
                hashSet.addAll(webServerPortConfig.getLetsEncryptDomainNamesSet());
            }
            ++n7;
        }
        propCnrArray = (LetsEncryptDomain[])this.getProps(LetsEncryptDomain.class);
        n6 = propCnrArray.length;
        n7 = 0;
        while (n7 < n6) {
            webServerPortConfig = propCnrArray[n7];
            if (!hashSet.contains(webServerPortConfig.getPropName())) {
                propVerification.add(new PropVerificationError("no.def", PropVerificationError.Severity.WARNING, "Let's Encrypt domain", (GProp)webServerPortConfig, "The Let's Encrypt domain \"" + webServerPortConfig.getPropName() + "\" is not referenced in the configured Let's Encrypt domains in the port configuration(s)", new String[0]));
            }
            ++n7;
        }
        int n8 = 0;
        MailProps[] mailPropsArray = (MailProps[])this.getProps(MailProps.class);
        if (mailPropsArray.length > 0) {
            object2 = mailPropsArray;
            n2 = mailPropsArray.length;
            int n9 = 0;
            while (n9 < n2) {
                MailProps mailProps = object2[n9];
                if (mailProps.getBool(Atom.DEFAULT, true)) {
                    ++n8;
                }
                ++n9;
            }
        }
        if (n8 > 1) {
            int n10 = 0;
            MailProps[] mailPropsArray2 = mailPropsArray;
            int n11 = mailPropsArray.length;
            n2 = 0;
            while (n2 < n11) {
                MailProps mailProps = mailPropsArray2[n2];
                object = (BoolProp)mailProps.getProp(Atom.DEFAULT, BoolProp.class);
                if (object == null) {
                    propVerification.add(new PropVerificationError((PropCnr)mailProps, Atom.DEFAULT, PropVerificationError.Severity.WARNING, "Default", "Only one default mail sender is allowed", new String[0]));
                } else {
                    propVerification.add(new PropVerificationError("one.def" + n10, PropVerificationError.Severity.WARNING, "Default", (GProp)object, "Only one default mail sender is allowed", new String[0]));
                }
                ++n10;
                ++n2;
            }
        }
        if ((n = (serverAppConfigArray = (ServerAppConfig[])this.getAllProps(ServerAppConfig.class)).length) > 0) {
            n2 = 0;
            while (n2 < n - 1) {
                object2 = serverAppConfigArray[n2].getPropName();
                int n12 = n2 + 1;
                while (n12 < n) {
                    object = serverAppConfigArray[n12].getPropName();
                    if (((String)object2).equals(object)) {
                        if (serverAppConfigArray[n2].getPropErroredName() == null) {
                            try {
                                serverAppConfigArray[n2].setPropErroredName((String)object2);
                            }
                            catch (PropException propException) {
                                // empty catch block
                            }
                        }
                        if (serverAppConfigArray[n12].getPropErroredName() == null) {
                            try {
                                serverAppConfigArray[n12].setPropErroredName((String)object2);
                            }
                            catch (PropException propException) {
                                // empty catch block
                            }
                        }
                    }
                    ++n12;
                }
                ++n2;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onApplicationLoad(AppFactory appFactory) throws ServerApplicationSetupException {
        ServerConfigEnvProps serverConfigEnvProps;
        String string = appFactory.getServerEnvironmentName();
        ZoneId zoneId = this.a;
        synchronized (zoneId) {
            a a2 = (a)((HashMap)((Object)this.a)).get(string);
            if (a2 != null) {
                return;
            }
            serverConfigEnvProps = this.getServerConfigEnvironment(string);
            if (serverConfigEnvProps == null) {
                throw new ServerApplicationSetupException("Server environment not found");
            }
            a2 = new a(serverConfigEnvProps);
            ((HashMap)((Object)this.a)).put(string, a2);
            a2.a();
        }
        serverConfigEnvProps.a(appFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onApplicationUnload(AppFactory appFactory) {
        a a2;
        ZoneId zoneId = this.a;
        synchronized (zoneId) {
            a2 = (a)((HashMap)((Object)this.a)).get(appFactory.getServerEnvironmentName());
        }
        if (a2 != null && a2.a()) {
            a2.a.b(appFactory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onApplicationSessionStarted(AppSessionGyro appSessionGyro) {
        a a2;
        ServerConfigEnvProps serverConfigEnvProps = appSessionGyro.getServerConfigurationEnvironment();
        String string = serverConfigEnvProps.getPropName();
        ZoneId zoneId = this.a;
        synchronized (zoneId) {
            a2 = (a)((HashMap)((Object)this.a)).get(string);
        }
        assert (a2 != null) : "Server environment \"" + string + "\" not prepared for the application load";
        assert (a2.a == serverConfigEnvProps) : "Different environment instances: has it been reloaded?";
        serverConfigEnvProps.a(appSessionGyro);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onApplicationSessionStopped(AppSessionGyro appSessionGyro) {
        a a2;
        ServerConfigEnvProps serverConfigEnvProps = appSessionGyro.getServerConfigurationEnvironment();
        String string = serverConfigEnvProps.getPropName();
        ZoneId zoneId = this.a;
        synchronized (zoneId) {
            a2 = (a)((HashMap)((Object)this.a)).get(string);
        }
        assert (a2 != null) : "Server environment \"" + string + "\" not prepared for the application load";
        assert (a2.a == serverConfigEnvProps) : "Different environment instances: has it been reloaded?";
        serverConfigEnvProps.b(appSessionGyro);
    }

    public MailSender getMailSender(String string, ExecutorService executorService, File file) throws NotFoundException, AddressException, NoSuchProviderException, IOException {
        MailSender mailSender;
        MailProps mailProps = null;
        if (string != null) {
            mailProps = (MailProps)this.getProp(string, MailProps.class);
            if (mailProps == null) {
                throw new NotFoundException("Mail sender \"" + string + "\" is not found");
            }
        } else {
            GProp[] gPropArray = this.getProps();
            int n = gPropArray.length;
            int n2 = 0;
            while (n2 < n) {
                mailSender = gPropArray[n2];
                if (mailSender instanceof MailProps) {
                    MailProps mailProps2 = (MailProps)mailSender;
                    if (mailProps2.isDefaultSender()) {
                        mailProps = mailProps2;
                        break;
                    }
                    if (mailProps == null) {
                        mailProps = mailProps2;
                    }
                }
                ++n2;
            }
            if (mailProps == null) {
                throw new NotFoundException("Default mail sender is not found");
            }
        }
        return (mailSender = mailProps.getMailSender()) != null ? mailSender : mailProps.createInstance(executorService, file);
    }

    public int getRegionLocationGlobalCacheSize() {
        return 20000;
    }

    public String getRegionLocationAPIKey(String string) {
        return null;
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    private static class a {
        private ServerConfigEnvProps a;
        private int a;

        private a(ServerConfigEnvProps serverConfigEnvProps) {
            this.a = serverConfigEnvProps;
        }

        private synchronized void a() {
            ++this.a;
        }

        private synchronized boolean a() {
            return this.a > 0 && --this.a == 0;
        }
    }
}

