/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.util;

import com.iizix.SystemConfig;
import com.iizix.Utilities;
import com.iizix.codepage.CodepageMapper;
import com.iizix.util.XFile;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Vector;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class XOutputFile {
    public static final String newLine = SystemConfig.LINE_SEPARATOR;
    public static final byte[] isoNewLine = Utilities.getBytes(newLine);
    private OutputStream a;
    private DataOutputStream a;

    public XOutputFile(File file) throws IOException {
        this.a(file.getCanonicalPath());
    }

    public XOutputFile(String string) throws IOException {
        this.a(string);
    }

    public XOutputFile(String string, XFile xFile) throws IOException {
        this.a(string, xFile.getFileName());
    }

    public XOutputFile(String string, String string2) throws IOException {
        this.a(string, string2);
    }

    public XOutputFile(OutputStream outputStream) {
        this.a = outputStream;
        this.a = new DataOutputStream(new BufferedOutputStream(this.a));
    }

    public XOutputFile() {
        this.a = new ByteArrayOutputStream();
        this.a = new DataOutputStream(this.a);
    }

    private void a(String string) throws IOException {
        this.a = new FileOutputStream(string);
        this.a = new DataOutputStream(new BufferedOutputStream(this.a));
    }

    private void a(String string, String string2) throws IOException {
        this.a(XFile.getFileNameFromAnother(string, string2));
    }

    public synchronized void close() throws IOException {
        IOException iOException = null;
        if (this.a != null) {
            try {
                this.a.close();
            }
            catch (IOException iOException2) {
                iOException = iOException2;
            }
            this.a = null;
        }
        if (this.a != null) {
            try {
                this.a.close();
                this.a = null;
            }
            catch (IOException iOException3) {
                // empty catch block
            }
        }
        if (iOException != null) {
            throw iOException;
        }
    }

    public void writeOEMStringVector(Vector<String> vector) throws IOException {
        for (String string : vector) {
            this.writeLine(CodepageMapper.convertStringToASCII(string));
        }
    }

    public void writeLine(byte[] byArray) throws IOException {
        this.a.write(byArray, 0, byArray.length);
        this.a.writeBytes(newLine);
    }

    public void writeISOLine(String string) throws IOException {
        this.a.write(Utilities.getBytes(string));
        this.a.write(isoNewLine, 0, isoNewLine.length);
    }

    public void writeBytes(byte[] byArray) throws IOException {
        this.a.write(byArray, 0, byArray.length);
    }

    public void writeBytes(byte[] byArray, int n2, int n3) throws IOException {
        this.a.write(byArray, n2, n3);
    }

    public void writeByte(byte by) throws IOException {
        this.a.writeByte(by);
    }

    public void writeByte(int n2) throws IOException {
        this.a.writeByte(n2);
    }

    public void writeOEMString(String string) throws IOException {
        this.writeBytes(CodepageMapper.convertStringToASCII(string));
    }

    public void writeOEMString(String string, int n2, byte by) throws IOException {
        this.writeOEMString(string, n2, (int)by);
    }

    public void writeOEMString(String string, int n2, int n3) throws IOException {
        int n4 = string.length();
        if (n4 > n2) {
            n4 = n2;
            string = string.substring(0, n2);
        }
        this.writeBytes(CodepageMapper.convertStringToASCII(string));
        int n5 = n2 - n4;
        while (n5 > 0) {
            this.writeByte(n3);
            --n5;
        }
    }

    public void writeString(String string, int n2, byte by) throws IOException {
        this.writeString(string, n2, (int)by);
    }

    public void writeString(String string, int n2, int n3) throws IOException {
        int n4 = string.length();
        if (n4 > n2) {
            n4 = n2;
            string = string.substring(0, n2);
        }
        this.writeBytes(CodepageMapper.convertStringToAnsi(string));
        int n5 = n2 - n4;
        while (n5 > 0) {
            this.writeByte(n3);
            --n5;
        }
    }

    public void writeUnicodeString(String string) throws IOException {
        int n2 = 0;
        int n3 = string.length();
        while (n2 < n3) {
            this.writeIntelUShort(string.charAt(n2));
            ++n2;
        }
    }

    public void writeZeroTermUnicodeString(String string) throws IOException {
        int n2 = 0;
        int n3 = string.length();
        while (n2 < n3) {
            char c2 = string.charAt(n2);
            if (c2 == '\u0000') break;
            this.writeIntelUShort(c2);
            ++n2;
        }
        this.writeIntelUShort(0);
    }

    public void writeUnicodeString(String string, int n2, char c2) throws IOException {
        int n3 = string.length();
        if (n3 > n2) {
            n3 = n2;
            string = string.substring(0, n2);
        }
        this.writeUnicodeString(string);
        int n4 = n2 - n3;
        while (n4 > 0) {
            this.writeIntelUShort(c2);
            --n4;
        }
    }

    public void writeIntelLong(int n2) throws IOException {
        this.writeByte(n2);
        this.writeByte(n2 >> 8);
        this.writeByte(n2 >> 16);
        this.writeByte(n2 >> 24);
    }

    public void writeIntelShort(int n2) throws IOException {
        int n3 = Math.abs(n2) & Short.MAX_VALUE;
        this.writeByte(n3);
        int n4 = n3 >> 8 & 0xFF;
        if (n2 < 0) {
            n4 |= 0x80;
        }
        this.writeByte(n4);
    }

    public void writeIntelUShort(int n2) throws IOException {
        this.writeByte(n2);
        this.writeByte(n2 >> 8);
    }

    public DataOutputStream getDataOutputStream() {
        return this.a;
    }

    public FileOutputStream getFileOutputStream() {
        try {
            this.a.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.a instanceof FileOutputStream ? (FileOutputStream)this.a : null;
    }

    public ByteArrayOutputStream getByteArrayOutputStream() {
        try {
            this.a.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.a instanceof ByteArrayOutputStream ? (ByteArrayOutputStream)this.a : null;
    }

    public OutputStream getOutputStream() {
        try {
            this.a.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.a;
    }

    public byte[] getByteArray() {
        try {
            this.a.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.a instanceof ByteArrayOutputStream ? ((ByteArrayOutputStream)this.a).toByteArray() : null;
    }
}

