/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.location;

import com.iizix.ILog;
import com.iizix.IWebServiceEngine;
import com.iizix.RunMode;
import com.iizix.Utilities;
import com.iizix.prop.GeoLocation;
import com.iizix.virtual.VirtualThreads;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.function.BiFunction;
import javax.net.ssl.HttpsURLConnection;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

public class LocationUtils {
    private LocationUtils() {
    }

    public static boolean getGeoLocation(InetAddress inetAddress, BiFunction<GeoLocation, Exception, Void> biFunction) {
        return LocationUtils.getGeoLocation(2, inetAddress, biFunction);
    }

    public static boolean getGeoLocation(int n2, InetAddress inetAddress, BiFunction<GeoLocation, Exception, Void> biFunction) {
        VirtualThreads.getVirtualThreads().startThread(() -> {
            try {
                GeoLocation geoLocation = LocationUtils.getGeoLocation(n2, inetAddress);
                biFunction.apply(geoLocation, null);
            }
            catch (Exception exception) {
                biFunction.apply(null, exception);
            }
        }, "geoIP");
        return true;
    }

    public static GeoLocation getGeoLocation(InetAddress inetAddress) throws IOException, JSONException {
        return LocationUtils.getGeoLocation(2, inetAddress);
    }

    public static GeoLocation getGeoLocation(int n2, InetAddress inetAddress) throws IOException, JSONException {
        Object object = "Build URL 'https://freegeoip.net/json/'...";
        String string = "https://freegeoip.net/json/" + Utilities.encodeURIComponent(inetAddress.getHostAddress());
        try {
            JSONObject jSONObject;
            URL uRL = new URI(string).toURL();
            object = "Open HTTPS connection to https://freegeoip.net/'";
            HttpsURLConnection httpsURLConnection = (HttpsURLConnection)uRL.openConnection();
            object = "Configure HTTPS connection to https://freegeoip.net/' proxy settings";
            IWebServiceEngine iWebServiceEngine = RunMode.getWebServiceConfigurator();
            iWebServiceEngine.configureProxy(httpsURLConnection);
            String string2 = "'" + String.valueOf(uRL) + "'";
            object = "Read reply from " + string2;
            Throwable throwable = null;
            Object var10_13 = null;
            try (InputStream inputStream = httpsURLConnection.getInputStream();){
                jSONObject = new JSONObject(new JSONTokener(inputStream));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            object = "Parse reply from " + string2;
            long l2 = jSONObject.getLong("latitude");
            long l3 = jSONObject.getLong("longitude");
            return new GeoLocation(l2, l3);
        }
        catch (URISyntaxException uRISyntaxException) {
            ILog.log(n2, LocationUtils.class, (String)object + ": " + uRISyntaxException.getMessage());
            throw new IOException("Invalid URI: " + string, uRISyntaxException);
        }
        catch (Exception exception) {
            ILog.log(n2, LocationUtils.class, (String)object + ": " + exception.getMessage());
            throw exception;
        }
    }

    public static void main(String[] stringArray) {
        String string = stringArray.length > 0 ? stringArray[0] : "google.com";
        try {
            System.out.println("Location of IP " + string + " is:\n");
            InetAddress inetAddress = InetAddress.getByName(string);
            System.out.println(LocationUtils.getGeoLocation(inetAddress));
        }
        catch (Throwable throwable) {
            throwable.printStackTrace(System.err);
            System.exit(1);
        }
    }
}

