/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.jdbc;

import com.iizix.IFileURLResolver;
import com.iizix.ILog;
import com.iizix.SystemConfig;
import com.iizix.Utilities;
import com.iizix.jdbc.JDBCHelper;
import com.iizix.jdbc.c;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public final class UpdateJDBCDriversDirectory {
    static boolean a;
    private final int a;

    public static void main(String[] stringArray) {
        if (stringArray.length != 1) {
            System.err.println(UpdateJDBCDriversDirectory.class.getName() + ": syntax: UpdateJDBCDriversDirectory destination_directory");
            System.exit(9);
        }
        try {
            File file = Utilities.getCanonicalFile((File)new File(stringArray[0]));
            UpdateJDBCDriversDirectory.copyJDBCDriversTo(file, new c());
        }
        catch (IOException iOException) {
            System.err.println(UpdateJDBCDriversDirectory.class.getName() + " failed: " + iOException.getMessage());
            System.exit(1);
        }
    }

    public static void copyJDBCDriversTo(File file, IFileURLResolver iFileURLResolver) throws IOException {
        if (!(file = Utilities.getCanonicalFile((File)file)).exists()) {
            throw new FileNotFoundException("Destination directory \"" + String.valueOf(file) + "\" does does not exist");
        }
        if (!file.isDirectory()) {
            throw new FileNotFoundException("Destination directory \"" + String.valueOf(file) + "\" is not a directory");
        }
        if (a) {
            ILog.INFO(UpdateJDBCDriversDirectory.class, (String)("Derby Database server is running, ignoring updating the JDBC drivers directory " + String.valueOf(file)));
        } else {
            new UpdateJDBCDriversDirectory(SystemConfig.isDevelopmentMode ? 3 : 5).a("", JDBCHelper.initialize(iFileURLResolver), file);
        }
        JDBCHelper.a = file;
    }

    private static boolean a(File file, File file2) {
        return file.length() == file2.length() && file.lastModified() == file2.lastModified();
    }

    private UpdateJDBCDriversDirectory(int n) {
        this.a = n;
    }

    private void a(String object, File file, File file2) throws IOException {
        if (!file2.exists()) {
            Files.createDirectory(file2.toPath(), new FileAttribute[0]);
            this.a((String)object, "- created directory ", file2, null);
        }
        this.a((String)object, "- processing directory ", file2, file);
        if (!file2.isDirectory()) {
            throw new FileNotFoundException("Destination directory \"" + String.valueOf(file2) + "\" is not a directory");
        }
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            throw new IOException("Failed listing directory \"" + String.valueOf(file) + "\"");
        }
        object = (String)object + "   ";
        File[] fileArray2 = fileArray;
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file3 = fileArray2[n2];
            String string = file3.getName();
            File file4 = new File(file2, string);
            if (file3.isDirectory()) {
                this.a((String)object, file3, file4);
            } else if (UpdateJDBCDriversDirectory.a(file3, file4)) {
                this.a((String)object, "- file unchanged ", file4, null);
            } else {
                if (ILog.isLogged((int)this.a)) {
                    if (file4.exists()) {
                        this.a((String)object, "- updating file ", file4, file3);
                    } else {
                        this.a((String)object, "- copy file ", file4, file3);
                    }
                }
                Files.copy(file3.toPath(), file4.toPath(), StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.COPY_ATTRIBUTES);
                long l = file3.lastModified();
                if (l != file4.lastModified() && !file4.setLastModified(l)) {
                    throw new IOException("Failed setting last modified date of destination copied file \"" + String.valueOf(file4) + "\": " + Utilities.formatDate((long)l));
                }
            }
            ++n2;
        }
    }

    private void a(String string, String string2, File file, File file2) {
        if (ILog.isLogged((int)this.a)) {
            String string3 = string + string2 + String.valueOf(file);
            if (file2 != null) {
                string3 = string3 + " from " + String.valueOf(file2);
            }
            ILog.log((int)this.a, (String)"UpdateJDBCDrivers", (String)string3);
        }
    }
}

