/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.value;

import com.iizix.LocaleInfo;
import com.iizix.Value;
import com.iizix.value.TermporalAmountValue;
import java.text.ParseException;
import java.time.Period;
import java.util.Date;
import javax.xml.datatype.Duration;

public class XMLDurationValue
extends TermporalAmountValue<Duration> {
    @Override
    public final Value.Type getValueType() {
        return Value.Type.XMLDuration;
    }

    @Override
    public Class<Duration> getValueClass() {
        return Duration.class;
    }

    @Override
    public String getDescription() {
        return "Duration of time as defined in XML Schema 1.0, such as PnYnMnDTnHnMnS";
    }

    @Override
    public Duration createDefault() {
        return Value.getXMLDataFactory().newDuration(0L);
    }

    @Override
    public Duration parse(String string) throws ParseException, IllegalAccessException, Exception {
        try {
            return Value.getXMLDataFactory().newDuration(string);
        }
        catch (Exception exception) {
            throw new ParseException(exception.getMessage(), 0);
        }
    }

    @Override
    public Duration convert(Object object, Value.Type type, LocaleInfo localeInfo) throws Exception {
        long l2;
        if (object instanceof Duration) {
            return (Duration)object;
        }
        if (object instanceof Number) {
            long l3 = ((Number)object).longValue();
            return Value.getXMLDataFactory().newDuration(l3);
        }
        if (object instanceof Period) {
            Period period = (Period)object;
            return Value.getXMLDataFactory().newDuration(!period.isNegative(), period.getYears(), period.getMonths(), period.getDays(), Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE);
        }
        if (type != null && (l2 = type.valueObject.asLongCast(object, localeInfo)) != Long.MIN_VALUE) {
            return Value.getXMLDataFactory().newDuration(l2);
        }
        String string = type != null ? type.valueObject.toStringForced(object) : String.valueOf(object);
        try {
            return Value.getXMLDataFactory().newDuration(string);
        }
        catch (Exception exception) {
            throw new ParseException(exception.getMessage(), 0);
        }
    }

    @Override
    public long asLong(Duration duration, LocaleInfo localeInfo) {
        try {
            return duration.getTimeInMillis(new Date(0L));
        }
        catch (ArithmeticException arithmeticException) {
            return Long.MIN_VALUE;
        }
    }
}

