/*
 * Decompiled with CFR 0.152.
 */
package com.iizigo.panel.prop;

import com.iizigo.ApplicationUI;
import com.iizigo.editor.PropHelper;
import com.iizigo.editor.complex.ComplexOperation;
import com.iizigo.panel.DropInfo;
import com.iizigo.panel.PanelEditor;
import com.iizigo.panel.prop.EGridData;
import com.iizigo.panel.prop.EGridLayout0;
import com.iizigo.panel.prop.EUIEmpty;
import com.iizigo.panel.prop.IClearComponentArea;
import com.iizigo.panel.prop.IELayoutMgrDND;
import com.iizigo.panel.prop.IReplaceLayoutData;
import com.iizigo.panel.prop.IScrollbarsValidation;
import com.iizigo.panel.prop.UILayoutDesignerProp;
import com.iizigo.panel.wizards.AddUICompWizard;
import com.iizigo.prop.tooltip.TooltipItem;
import com.iizix.ILog;
import com.iizix.prop.Atom;
import com.iizix.prop.GProp;
import com.iizix.prop.GUnit;
import com.iizix.prop.IGProp;
import com.iizix.prop.IntProp;
import com.iizix.prop.PropCnr;
import com.iizix.prop.PropValidateException;
import com.iizix.prop.PropVerification;
import com.iizix.prop.PropVerificationError;
import com.iizix.prop.UnitProp;
import com.iizix.prop.ui.GridLayout;
import com.iizix.prop.ui.LayoutMgr;
import com.iizix.prop.ui.LayoutProp;
import com.iizix.prop.ui.UIComp;
import com.iizix.prop.ui.UIComps;
import com.iizix.prop.ui.UIContainer;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class EGridLayout
extends GridLayout
implements IClearComponentArea,
IELayoutMgrDND<EGridData>,
IReplaceLayoutData,
IScrollbarsValidation {
    private UILayoutDesignerProp a = new UILayoutDesignerProp((LayoutMgr<?>)this);
    private static final List<TooltipItem> a;

    static {
        a = List.of(TooltipItem.HEADER_IMAGE_DESCR_TYPE, TooltipItem.SEPARATOR, TooltipItem.newNormal("Column count", "columnCount"), TooltipItem.newNormal("Same width", "sameWidth"), TooltipItem.newNormal("Same height", "sameHeight"), TooltipItem.newNormal("Horizontal cell spacing", "hspace"), TooltipItem.newNormal("Vertical cell spacing", "vspace"), TooltipItem.newNormal("Minimum width", "mx"), TooltipItem.newNormal("Minimum height", "my"), TooltipItem.SPACER_4PX, TooltipItem.ATOM_HSCROLL, TooltipItem.ATOM_VSCROLL);
    }

    public EGridLayout() {
    }

    public EGridLayout(Atom atom) {
        super(atom);
    }

    @Override
    public Class<EGridData> getLayoutDataClass() {
        return EGridData.class;
    }

    @Override
    public boolean isCNVisible() {
        return true;
    }

    @Override
    public UILayoutDesignerProp getDesigner() {
        return this.a;
    }

    @Override
    public Object[] getPropertyEditorLayoutDataSetup() {
        return EGridData.a;
    }

    @Override
    public Image getCNImage(boolean bl) {
        return ApplicationUI.getInstance().imageUIGridLayout;
    }

    @Override
    public String getCNDescriptionType() {
        return "Grid layout";
    }

    public EGridLayout clone() {
        EGridLayout eGridLayout = (EGridLayout)super.clone();
        eGridLayout.a = new UILayoutDesignerProp((LayoutMgr<?>)eGridLayout);
        return eGridLayout;
    }

    @Override
    public boolean isReplaceable() {
        return true;
    }

    @Override
    public EGridData createDefaultLayoutProp(UIComp uIComp) {
        return new EGridData(uIComp);
    }

    public void setColumnCount(int n2) {
        this.setInt("columnCount", n2);
    }

    @Override
    public Object[] getTransferProps() {
        return EGridLayout0.setup;
    }

    public boolean verify(PropVerification propVerification) {
        if (!super.verify(propVerification)) {
            return false;
        }
        this.verifyScrollbars(propVerification);
        IntProp intProp = (IntProp)this.getProp("columnCount", IntProp.class);
        if (intProp == null) {
            propVerification.add(new PropVerificationError("grid.columnCount", PropVerificationError.Severity.ERROR, "Column count", (GProp)this, "Column count must be specified", new String[0]));
        } else {
            int n2 = intProp.getInt();
            if (n2 <= 0) {
                propVerification.add(new PropVerificationError("grid.columnCount", PropVerificationError.Severity.ERROR, "Column count", (GProp)intProp, "Column count must be at least 1", new String[0]));
            }
        }
        Grid grid = this.getGrid();
        Iterator<int[]> iterator = grid.grid.iterator();
        while (iterator.hasNext()) {
            int[] nArray;
            int[] nArray2 = nArray = iterator.next();
            int n3 = nArray.length;
            int n4 = 0;
            while (n4 < n3) {
                UIComp uIComp;
                LayoutProp layoutProp;
                int n5 = nArray2[n4];
                if (n5 > 0 && !((layoutProp = (uIComp = grid.a.get(n5 - 1)).getLayout()) instanceof EGridData)) {
                    propVerification.add(new PropVerificationError("grid.data", PropVerificationError.Severity.ERROR, "Grid data", (GProp)uIComp, "Component is in Grid Layout but doesn't have Grid Data", new String[0]));
                }
                ++n4;
            }
        }
        return true;
    }

    public Grid getGrid() {
        return new Grid();
    }

    @Override
    public boolean clearComponentArea(ComplexOperation complexOperation, UIComp uIComp) {
        Grid grid = this.getGrid();
        boolean bl = grid.a(uIComp);
        if (bl) {
            grid.consolidateGrid(complexOperation);
        }
        return bl;
    }

    @Override
    public void checkReplaceLayoutData(ComplexOperation complexOperation, UIComp uIComp) {
        LayoutProp layoutProp = uIComp.getLayout();
        if (!(layoutProp instanceof EGridData)) {
            GUnit gUnit = layoutProp.getLayoutWidth();
            GUnit gUnit2 = layoutProp.getLayoutHeight();
            EGridData eGridData = new EGridData(Atom.LAYOUT);
            if (gUnit != null) {
                eGridData.addProp2((IGProp)new UnitProp(Atom.get((String)"cx"), gUnit));
            }
            if (gUnit2 != null) {
                eGridData.addProp2((IGProp)new UnitProp(Atom.get((String)"cy"), gUnit2));
            }
            int n2 = layoutProp.getInt("alignX");
            int n3 = layoutProp.getInt("alignY");
            if (n2 > 0) {
                eGridData.setInt("alignX", n2);
            }
            if (n3 > 0) {
                eGridData.setInt("alignY", n3);
            }
            if (complexOperation == null) {
                uIComp.removeProp2((IGProp)layoutProp);
                uIComp.addProp2((IGProp)eGridData);
            } else {
                complexOperation.removeProp((GProp<?>)layoutProp);
                complexOperation.addProp((PropCnr)uIComp, (GProp<?>)eGridData);
            }
        }
    }

    @Override
    public UIComp[] onDrop(DropInfo dropInfo) {
        LayoutProp layoutProp;
        GProp[] gPropArray;
        int n2;
        UIComp uIComp;
        int n3 = dropInfo.trans.readUnsigned();
        int n4 = dropInfo.trans.readUnsigned();
        int n5 = dropInfo.panelEditor.getDropMode();
        UIComp uIComp2 = dropInfo.comps;
        int n6 = ((UIComp[])uIComp2).length;
        String string = n6 > 1 ? "components" : "component";
        ComplexOperation complexOperation = new ComplexOperation(dropInfo.isCopy ? "Copy " + string : "Move " + string, dropInfo.panelEditor, dropInfo.panelEditor);
        HashSet<UIComp> hashSet = null;
        Grid grid = this.getGrid();
        UIComps uIComps = this.getCompsCnr();
        if (dropInfo.isWizardEditingRequested && !AddUICompWizard.doWizardBeforeDrop(uIComp2[0], uIComps, complexOperation)) {
            return null;
        }
        PropCnr propCnr = null;
        if (dropInfo.isCopy) {
            uIComp2 = (UIComp[])uIComp2.clone();
            int n7 = n6;
            while (--n7 >= 0) {
                UIComp uIComp3 = uIComp2[n7];
                uIComp3 = uIComp2[n7] = uIComp3.clone();
                this.checkReplaceLayoutData(null, uIComp3);
            }
        } else {
            uIComp = uIComp2;
            n2 = ((UIComp[])uIComp).length;
            int n8 = 0;
            while (n8 < n2) {
                UIComp uIComp4 = uIComp[n8];
                LayoutMgr layoutMgr = uIComp4.getUIParent().getLayoutMgr();
                if (layoutMgr instanceof IClearComponentArea) {
                    gPropArray = (GProp[])layoutMgr;
                    if (layoutMgr == this) {
                        if (hashSet == null || propCnr == null) {
                            hashSet = new HashSet<UIComp>();
                            propCnr = new PropCnr(Atom.TRANSACTION);
                            complexOperation.addProp((PropCnr)this, (GProp<?>)propCnr);
                        }
                        grid.a(complexOperation, uIComp4, false);
                        hashSet.add(uIComp4);
                        layoutProp = new PropCnr(propCnr.createUniqueAtom(""));
                        complexOperation.addProp(propCnr, (GProp<?>)layoutProp);
                        complexOperation.moveProp((GProp<?>)uIComp4, (PropCnr)layoutProp, null, -1);
                    } else {
                        gPropArray.clearComponentArea(complexOperation, uIComp4);
                    }
                }
                ++n8;
            }
        }
        Atom[] atomArray = PropHelper.getUniqueNames((PropCnr)uIComps, dropInfo.comps, dropInfo.isCopy ? " Copy" : " Moved", dropInfo.isCopy);
        int n9 = 0;
        n2 = 0;
        while (n2 < n6) {
            int n10;
            uIComp = uIComp2[n2];
            int n11 = 1;
            int n12 = 1;
            layoutProp = uIComp.getLayout();
            if (layoutProp instanceof EGridData) {
                n11 = Math.max(1, layoutProp.getInt("spanX", 1));
                n12 = Math.max(1, layoutProp.getInt("spanY", 1));
            }
            n9 = Math.max(n9, n12);
            while (grid.columnCount < n3) {
                grid.insertColumn(complexOperation, grid.columnCount);
            }
            while (grid.grid.size() < n4) {
                grid.insertRow(complexOperation, grid.grid.size());
            }
            if (n5 == 0) {
                n10 = n11;
                while (--n10 >= 0) {
                    grid.insertColumn(complexOperation, n3);
                }
            } else if (n5 == 1) {
                n10 = n12;
                while (--n10 >= 0) {
                    grid.insertRow(complexOperation, n4);
                }
            }
            while (grid.columnCount < n3 + n11) {
                grid.insertColumn(complexOperation, grid.columnCount);
            }
            while (grid.grid.size() < n4 + n12) {
                grid.insertRow(complexOperation, grid.grid.size());
            }
            if (!dropInfo.isCopy && hashSet != null && hashSet.contains(uIComp)) {
                assert (grid.a(uIComp) == null) : "Moved component still in grid: " + String.valueOf(uIComp);
                n10 = grid.a(complexOperation, uIComp, n3, n4, n11, n12);
                complexOperation.moveProp((GProp<?>)uIComp, (PropCnr)uIComps, atomArray[n2], n10);
            } else {
                n10 = grid.a(complexOperation, uIComp, n3, n4, n11, n12);
                if (dropInfo.isCopy) {
                    try {
                        uIComp.renameProp(atomArray[n2]);
                    }
                    catch (Exception exception) {
                        ILog.SEVERE(this.getClass(), (String)"Failed clone-rename", (Object[])new Object[]{uIComp, exception});
                    }
                    complexOperation.insertProp((PropCnr)uIComps, (GProp<?>)uIComp, n10);
                } else {
                    complexOperation.moveProp((GProp<?>)uIComp, (PropCnr)uIComps, atomArray[n2], n10);
                    this.checkReplaceLayoutData(complexOperation, uIComp);
                }
            }
            switch (n5) {
                case 0: 
                case 2: {
                    n3 += n11;
                    break;
                }
                case 1: 
                case 4: {
                    n4 += n12;
                    break;
                }
                case 3: {
                    if ((n3 += n11) < grid.columnCount) break;
                    n3 = 0;
                    n4 += n9;
                    n9 = 0;
                }
            }
            ++n2;
        }
        grid.consolidateGrid(complexOperation);
        if (propCnr != null) {
            gPropArray = propCnr.getProps();
            int n13 = gPropArray.length;
            int n14 = 0;
            while (n14 < n13) {
                GProp gProp = gPropArray[n14];
                layoutProp = (PropCnr)gProp;
                assert (layoutProp.getPropCount() == 0) : "Temp-wrap-container not empty!";
                complexOperation.removeProp(gProp);
                ++n14;
            }
            complexOperation.removeProp((GProp<?>)propCnr);
        }
        PropHelper.executeOperation(dropInfo.panelEditor.getShell(), complexOperation);
        return uIComp2;
    }

    @Override
    public void convertLayout(ComplexOperation complexOperation, UIContainer uIContainer, LayoutMgr<?> layoutMgr) {
        UIComp[] uICompArray = uIContainer.getCompsCnr().getUIComps();
        int n2 = uICompArray.length;
        int n3 = 0;
        while (n3 < n2) {
            UIComp uIComp = uICompArray[n3];
            this.checkReplaceLayoutData(complexOperation, uIComp);
            ++n3;
        }
    }

    @Override
    public List<TooltipItem> getTooltipPropertyList() {
        return a;
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public class Grid {
        public int columnCount;
        public ArrayList<int[]> grid;
        private List<UIComp> a;

        private Grid() {
            this.columnCount = Math.max(1, EGridLayout.this.getInt("columnCount", 1));
            this.grid = new ArrayList();
            this.a = Arrays.asList(EGridLayout.this.getUIComps());
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            int n5 = this.a.size();
            while (n4 < n5) {
                UIComp uIComp = this.a.get(n4);
                LayoutProp layoutProp = uIComp.getLayout();
                int n6 = Math.max(1, layoutProp.getInt("spanX", 1));
                int n7 = Math.max(1, layoutProp.getInt("spanY", 1));
                int n8 = n4 + 1;
                int n9 = -n8;
                while (n3 + n7 > this.grid.size()) {
                    this.grid.add(new int[this.columnCount]);
                }
                n6 = Math.min(n6, this.columnCount - n2);
                int n10 = 0;
                while (n10 < n7) {
                    int n11 = 0;
                    while (n11 < n6) {
                        this.grid.get((int)(n3 + n10))[n2 + n11] = n8;
                        n8 = n9;
                        ++n11;
                    }
                    ++n10;
                }
                while (this.grid.get(n3)[n2] != 0) {
                    if (++n2 < this.columnCount) continue;
                    n2 = 0;
                    if (++n3 >= this.grid.size()) break;
                }
                ++n4;
            }
        }

        private int a(ComplexOperation complexOperation, UIComp uIComp, int n2, int n3, int n4, int n5) {
            int n6;
            int n7;
            int n8;
            int[] nArray;
            int n9;
            HashSet<UIComp> hashSet = new HashSet<UIComp>();
            int n92 = n3 + n5;
            while (--n92 >= n3) {
                int n10 = n2 + n4;
                while (--n10 >= n2) {
                    UIComp object2 = this.a(n10, n92);
                    if (object2 == null) continue;
                    hashSet.add(object2);
                }
            }
            for (UIComp uIComp3 : hashSet) {
                this.a(complexOperation, uIComp3, true);
            }
            int n11 = 0;
            int n12 = 0;
            block3: for (int[] nArray2 : this.grid) {
                n9 = 0;
                nArray = nArray2;
                n8 = nArray2.length;
                n7 = 0;
                while (n7 < n8) {
                    n6 = nArray[n7];
                    if (n12 == n3 && n9 == n2) break block3;
                    if (n6 > 0) {
                        ++n11;
                    }
                    ++n9;
                    ++n7;
                }
                ++n12;
            }
            n12 = n11 + 1;
            for (int[] nArray3 : this.grid) {
                n9 = 0;
                nArray = nArray3;
                n8 = nArray3.length;
                n7 = 0;
                while (n7 < n8) {
                    n6 = nArray[n7];
                    if (n6 > 0) {
                        if (n6 >= n12) {
                            nArray3[n9] = n6 + 1;
                        }
                    } else if (n6 < 0 && -n6 >= n12) {
                        nArray3[n9] = n6 - 1;
                    }
                    ++n9;
                    ++n7;
                }
            }
            this.a(n2, n3, n4, n5, n11);
            this.a.add(n11, uIComp);
            return n11;
        }

        private void a(ComplexOperation complexOperation, UIComp uIComp, boolean bl) {
            int n2 = this.a.indexOf(uIComp);
            assert (n2 >= 0) : "Component not found";
            this.a(uIComp);
            if (bl) {
                complexOperation.removeProp((GProp<?>)uIComp);
            }
            this.a.remove(n2++);
            for (int[] nArray : this.grid) {
                int n3 = 0;
                int[] nArray2 = nArray;
                int n4 = nArray.length;
                int n5 = 0;
                while (n5 < n4) {
                    int n6 = nArray2[n5];
                    if (n6 > 0) {
                        if (n6 > n2) {
                            nArray[n3] = n6 - 1;
                        }
                    } else if (n6 < 0 && -n6 > n2) {
                        nArray[n3] = n6 + 1;
                    }
                    ++n3;
                    ++n5;
                }
            }
        }

        public void consolidateGrid(ComplexOperation complexOperation) {
            assert (this.a.size() == EGridLayout.this.getCompsCnr().getPropCount()) : "Component count different";
            int n2 = 0;
            for (int[] nArray : this.grid) {
                int n3 = 0;
                while (n3 < this.columnCount) {
                    int n4 = nArray[n3];
                    if (n4 > 0) {
                        ++n2;
                    } else if (n4 == 0) {
                        EUIEmpty eUIEmpty = new EUIEmpty(EGridLayout.this.getCompsCnr().createUniqueAtom("empty"));
                        eUIEmpty.addProp2((IGProp)new EGridData(Atom.LAYOUT));
                        complexOperation.insertProp((PropCnr)EGridLayout.this.getCompsCnr(), (GProp<?>)eUIEmpty, n2);
                        this.a.add(n2, (UIComp)eUIEmpty);
                        nArray[n3] = ++n2;
                    }
                    ++n3;
                }
            }
        }

        private UIComp a(int n2, int n3) {
            if (n3 < 0 || n2 < 0 || n3 >= this.grid.size()) {
                return null;
            }
            int[] nArray = this.grid.get(n3);
            if (n2 >= nArray.length) {
                return null;
            }
            int n4 = nArray[n2];
            if (n4 == 0) {
                return null;
            }
            n4 = n4 < 0 ? -n4 - 1 : n4 - 1;
            return n4 >= 0 && n4 < this.a.size() ? this.a.get(n4) : null;
        }

        public int getRow(UIComp uIComp) {
            int n2 = this.a.indexOf(uIComp);
            if (n2++ >= 0) {
                int n3 = 0;
                Iterator<int[]> iterator = this.grid.iterator();
                while (iterator.hasNext()) {
                    int[] nArray;
                    int[] nArray2 = nArray = iterator.next();
                    int n4 = nArray.length;
                    int n5 = 0;
                    while (n5 < n4) {
                        int n6 = nArray2[n5];
                        if (n6 == n2) {
                            return n3;
                        }
                        ++n5;
                    }
                    ++n3;
                }
            }
            return -1;
        }

        public int getColumn(UIComp uIComp) {
            int n2 = this.a.indexOf(uIComp);
            if (n2++ >= 0) {
                for (int[] nArray : this.grid) {
                    int n3 = 0;
                    int[] nArray2 = nArray;
                    int n4 = nArray.length;
                    int n5 = 0;
                    while (n5 < n4) {
                        int n6 = nArray2[n5];
                        if (n6 == n2) {
                            return n3;
                        }
                        ++n3;
                        ++n5;
                    }
                }
            }
            return -1;
        }

        private Point a(UIComp uIComp) {
            int n2 = this.a.indexOf(uIComp);
            if (n2++ >= 0) {
                int n3 = 0;
                for (int[] nArray : this.grid) {
                    int n4 = 0;
                    int[] nArray2 = nArray;
                    int n5 = nArray.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        int n7 = nArray2[n6];
                        if (n7 == n2) {
                            return new Point(n4, n3);
                        }
                        ++n4;
                        ++n6;
                    }
                    ++n3;
                }
            }
            return null;
        }

        private Rectangle a(UIComp uIComp) {
            int n2 = this.a.indexOf(uIComp);
            if (n2++ >= 0) {
                int n3 = 0;
                for (int[] nArray : this.grid) {
                    int n4 = 0;
                    int[] nArray2 = nArray;
                    int n5 = nArray.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        int n7 = nArray2[n6];
                        if (n7 == n2) {
                            int n8 = Math.max(1, uIComp.getLayout().getInt("spanX", 1));
                            int n9 = Math.max(1, uIComp.getLayout().getInt("spanY", 1));
                            return new Rectangle(n4, n3, n8, n9);
                        }
                        ++n4;
                        ++n6;
                    }
                    ++n3;
                }
            }
            return null;
        }

        private void a(int n2, int n3, int n4, int n5) {
            while (--n5 >= 0) {
                int[] nArray = this.grid.get(n3 + n5);
                int n6 = n4 + n2;
                while (--n6 >= n2) {
                    nArray[n6] = 0;
                }
            }
        }

        private boolean a(UIComp uIComp) {
            Rectangle rectangle = this.a(uIComp);
            if (rectangle == null) {
                return false;
            }
            this.a(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            return true;
        }

        private void a(int n2, int n3, int n4, int n5, int n6) {
            ++n6;
            while (--n5 >= 0) {
                if (n3 + n5 >= this.grid.size()) continue;
                int[] nArray = this.grid.get(n3 + n5);
                int n7 = n4;
                while (--n7 >= 0) {
                    if (n2 + n7 >= nArray.length) continue;
                    int n8 = nArray[n2 + n7] = n7 == 0 && n5 == 0 ? n6 : -n6;
                }
            }
        }

        public void deleteColumn(ComplexOperation complexOperation, int n2) {
            if (this.columnCount == 1 && n2 == 0) {
                this.a.clear();
                int n3 = this.grid.size();
                while (--n3 >= 0) {
                    this.grid.set(n3, new int[1]);
                }
                return;
            }
            HashSet<UIComp> hashSet = new HashSet<UIComp>();
            for (int[] nArray : this.grid) {
                int n4 = nArray[n2];
                if (n4 > 0) {
                    this.a(complexOperation, this.a.get(n4 - 1), true);
                    continue;
                }
                if (n4 >= 0) continue;
                hashSet.add(this.a.get(-n4 - 1));
            }
            int n5 = 0;
            int n6 = this.grid.size();
            while (n5 < n6) {
                int[] nArray = this.grid.get(n5);
                int[] nArray2 = new int[this.columnCount - 1];
                System.arraycopy(nArray, 0, nArray2, 0, n2);
                int n7 = n2 + 1;
                while (n7 < this.columnCount) {
                    nArray2[n7 - 1] = nArray[n7];
                    ++n7;
                }
                this.grid.set(n5, nArray2);
                ++n5;
            }
            for (UIComp uIComp : hashSet) {
                IntProp intProp = (IntProp)uIComp.getLayout().getProp("spanX");
                complexOperation.setPropValue((GProp<?>)intProp, intProp.getInt() - 1);
            }
            --this.columnCount;
            IntProp intProp = (IntProp)EGridLayout.this.getProp("columnCount");
            if (intProp != null) {
                complexOperation.setPropValue((GProp<?>)intProp, this.columnCount);
            } else {
                try {
                    intProp = new IntProp(Atom.get((String)"columnCount"), this.columnCount);
                }
                catch (PropValidateException propValidateException) {
                    // empty catch block
                }
                complexOperation.addProp((PropCnr)EGridLayout.this, (GProp<?>)intProp);
            }
        }

        public void deleteRow(ComplexOperation complexOperation, int n2) {
            HashSet<UIComp> hashSet = new HashSet<UIComp>();
            int[] nArray = this.grid.get(n2);
            int n3 = 0;
            while (n3 < this.columnCount) {
                int n4 = nArray[n3];
                if (n4 > 0) {
                    this.a(complexOperation, this.a.get(n4 - 1), true);
                } else if (n4 < 0) {
                    hashSet.add(this.a.get(-n4 - 1));
                }
                ++n3;
            }
            for (UIComp uIComp : hashSet) {
                IntProp intProp = (IntProp)uIComp.getLayout().getProp("spanY");
                complexOperation.setPropValue((GProp<?>)intProp, intProp.getInt() - 1);
            }
            this.grid.remove(n2);
        }

        public void insertRow(ComplexOperation complexOperation, int n2) {
            if (n2 == this.grid.size()) {
                this.grid.add(new int[this.columnCount]);
            } else {
                int n3;
                int[] nArray;
                HashSet<Integer> hashSet = new HashSet<Integer>();
                LinkedHashSet<UIComp> linkedHashSet = new LinkedHashSet<UIComp>();
                int[] nArray2 = nArray = this.grid.get(n2);
                int n4 = nArray.length;
                int n5 = 0;
                while (n5 < n4) {
                    n3 = nArray2[n5];
                    if (n3 > 0) {
                        hashSet.add(n3 - 1);
                    } else if (n3 < 0 && !hashSet.contains(-n3 - 1)) {
                        linkedHashSet.add(this.a.get(-n3 - 1));
                    }
                    ++n5;
                }
                nArray = (int[])nArray.clone();
                n3 = nArray.length;
                while (--n3 >= 0) {
                    n5 = nArray[n3];
                    if (n5 <= 0 && (n5 >= 0 || !hashSet.contains(-n5 - 1))) continue;
                    nArray[n3] = 0;
                }
                this.grid.add(n2, nArray);
                for (UIComp uIComp : linkedHashSet) {
                    IntProp intProp = (IntProp)uIComp.getLayout().getProp("spanY");
                    complexOperation.setPropValue((GProp<?>)intProp, intProp.getInt() + 1);
                }
            }
        }

        public void insertColumn(ComplexOperation complexOperation, int n2) {
            Object object;
            Object object2;
            HashSet<Integer> hashSet = new HashSet<Integer>();
            LinkedHashSet<UIComp> linkedHashSet = new LinkedHashSet<UIComp>();
            int n3 = 0;
            int n4 = this.grid.size();
            while (n3 < n4) {
                object2 = this.grid.get(n3);
                object = new int[this.columnCount + 1];
                System.arraycopy(object2, 0, object, 0, Math.min(this.columnCount, n2 + 1));
                int n5 = this.columnCount;
                while (--n5 >= n2) {
                    object[n5 + 1] = (int)object2[n5];
                }
                this.grid.set(n3++, (int[])object);
                n5 = object[n2];
                if (n5 > 0) {
                    hashSet.add(n5 - 1);
                    object[n2] = 0;
                    continue;
                }
                if (n5 >= 0) continue;
                if (hashSet.contains(-n5 - 1)) {
                    object[n2] = 0;
                    continue;
                }
                linkedHashSet.add(this.a.get(-n5 - 1));
            }
            ++this.columnCount;
            IntProp intProp = (IntProp)EGridLayout.this.getProp("columnCount");
            if (intProp != null) {
                complexOperation.setPropValue((GProp<?>)intProp, this.columnCount);
            } else {
                try {
                    intProp = new IntProp(Atom.get((String)"columnCount"), this.columnCount);
                }
                catch (PropValidateException propValidateException) {
                    // empty catch block
                }
                complexOperation.addProp((PropCnr)EGridLayout.this, (GProp<?>)intProp);
            }
            object2 = linkedHashSet.iterator();
            while (object2.hasNext()) {
                UIComp uIComp = (UIComp)object2.next();
                object = (IntProp)uIComp.getLayout().getProp("spanX");
                complexOperation.setPropValue((GProp<?>)object, object.getInt() + 1);
            }
        }

        public void clearCells(ComplexOperation complexOperation, PanelEditor.GridInfo gridInfo) {
            Grid grid = EGridLayout.this.getGrid();
            HashSet<UIComp> hashSet = gridInfo.comps;
            for (UIComp uIComp : hashSet) {
                grid.a(uIComp);
            }
            for (UIComp uIComp : hashSet) {
                complexOperation.removeProp((GProp<?>)uIComp);
            }
            grid.consolidateGrid(complexOperation);
        }

        public boolean shrinkExtendOverwrite(boolean bl, ComplexOperation complexOperation, PanelEditor.GridInfo gridInfo, int n2, int n3) {
            IntProp intProp;
            Object object;
            int n4;
            int n5;
            int n6 = n5 = this.columnCount;
            int n7 = n4 = this.grid.size();
            for (UIComp uIComp : gridInfo.comps) {
                object = this.a(uIComp);
                if (object == null) {
                    return false;
                }
                if (object.width + n2 < 1 || object.height + n3 < 1) {
                    return false;
                }
                if (n2 > 0 || n3 > 0) {
                    int n8 = object.width + n2;
                    while (--n8 >= 0) {
                        int n9 = object.height + n3;
                        while (--n9 >= 0) {
                            intProp = this.a(object.x + n8, object.y + n9);
                            if (intProp == null || intProp == uIComp) continue;
                            if (gridInfo.comps.contains(intProp)) {
                                return false;
                            }
                            if (!bl) continue;
                            this.a(complexOperation, (UIComp)intProp, true);
                        }
                    }
                }
                n5 = Math.max(object.x + object.width + n2, n5);
                n4 = Math.max(object.y + object.height + n3, n4);
            }
            if (!bl) {
                return true;
            }
            if (n5 > n6) {
                UIComp uIComp;
                int n10 = n7;
                while (--n10 >= 0) {
                    Object object2 = this.grid.get(n10);
                    object = new int[n5];
                    System.arraycopy(object2, 0, object, 0, n6);
                    this.grid.set(n10, (int[])object);
                }
                uIComp = (IntProp)EGridLayout.this.getProp("columnCount");
                if (uIComp != null) {
                    complexOperation.setPropValue((GProp<?>)uIComp, n5);
                } else {
                    try {
                        uIComp = new IntProp(Atom.get((String)"columnCount"), n5);
                    }
                    catch (PropValidateException propValidateException) {
                        // empty catch block
                    }
                    complexOperation.addProp((PropCnr)EGridLayout.this, (GProp<?>)uIComp);
                }
                this.columnCount = n5;
            }
            int n11 = n7;
            while (n11 < n4) {
                this.grid.add(new int[n5]);
                ++n11;
            }
            for (UIComp uIComp : gridInfo.comps) {
                Atom atom;
                object = this.a(uIComp);
                LayoutProp layoutProp = uIComp.getLayout();
                intProp = (IntProp)layoutProp.getProp(atom = Atom.get((String)"spanX"));
                int n12 = intProp != null ? Math.max(1, intProp.getInt(1)) : 1;
                Atom atom2 = Atom.get((String)"spanY");
                IntProp intProp2 = (IntProp)layoutProp.getProp(atom2);
                int n13 = intProp2 != null ? Math.max(1, intProp2.getInt(1)) : 1;
                this.a(object.x, object.y, n12, n13);
                this.a(object.x, object.y, n12 += n2, n13 += n3, uIComp.getPropIndex());
                if (n2 != 0) {
                    if (intProp != null) {
                        complexOperation.setPropValue((GProp<?>)intProp, n12);
                    } else {
                        try {
                            complexOperation.addProp((PropCnr)layoutProp, (GProp<?>)new IntProp(atom, n12));
                        }
                        catch (PropValidateException propValidateException) {
                            // empty catch block
                        }
                    }
                }
                if (n3 == 0) continue;
                if (intProp2 != null) {
                    complexOperation.setPropValue((GProp<?>)intProp2, n13);
                    continue;
                }
                try {
                    complexOperation.addProp((PropCnr)layoutProp, (GProp<?>)new IntProp(atom2, n13));
                }
                catch (PropValidateException propValidateException) {
                    // empty catch block
                }
            }
            this.consolidateGrid(complexOperation);
            return true;
        }

        public boolean shrinkExtendInsert(boolean bl, ComplexOperation complexOperation, PanelEditor.GridInfo gridInfo, int n2, int n3) {
            int uIComp;
            Object object;
            Object n14;
            int n5 = this.columnCount;
            int n6 = this.grid.size();
            for (UIComp uIComp2 : gridInfo.comps) {
                Rectangle rectangle = this.a(uIComp2);
                if (rectangle != null && rectangle.width + n2 >= 1 && rectangle.height + n3 >= 1) continue;
                return false;
            }
            if (!(bl || n2 <= 0 && n3 <= 0)) {
                return true;
            }
            int n7 = gridInfo.comps.size();
            UIComp[][] uICompArrayArray = new UIComp[n5 + n7][];
            int n8 = uICompArrayArray.length;
            while (--n8 >= 0) {
                uICompArrayArray[n8] = new UIComp[n6 + n7];
            }
            n8 = n6;
            while (--n8 >= 0) {
                int n9 = n5;
                while (--n9 >= 0) {
                    uICompArrayArray[n9][n8] = this.a(n9, n8);
                }
            }
            HashSet<UIComp> hashSet = new HashSet<UIComp>();
            LinkedHashSet<UIComp> linkedHashSet = new LinkedHashSet<UIComp>();
            for (UIComp object32 : gridInfo.comps) {
                int iterator;
                int uIComp3;
                int n4;
                int n9;
                block50: {
                    n9 = 1;
                    n4 = 1;
                    int n10 = 0;
                    while (n10 < n6) {
                        uIComp3 = 0;
                        while (uIComp3 < n5) {
                            if (uICompArrayArray[uIComp3][n10] == object32) {
                                uIComp = uIComp3;
                                iterator = n10;
                                while (uICompArrayArray[uIComp + n9][iterator] == object32) {
                                    ++n9;
                                }
                                while (uICompArrayArray[uIComp][iterator + n4] == object32) {
                                    ++n4;
                                }
                                break block50;
                            }
                            ++uIComp3;
                        }
                        ++n10;
                    }
                    return false;
                }
                if (n2 < 0) {
                    n14 = new HashSet();
                    uIComp3 = iterator + n4;
                    while (--uIComp3 >= iterator) {
                        uICompArrayArray[uIComp + n9 - 1][uIComp3] = null;
                        object = uICompArrayArray[uIComp + n9][uIComp3];
                        if (object == null || object instanceof EUIEmpty) continue;
                        ((HashSet)n14).add(object);
                    }
                    linkedHashSet.addAll((Collection<UIComp>)n14);
                    object = ((HashSet)n14).iterator();
                    while (object.hasNext()) {
                        UIComp uIComp4 = (UIComp)object.next();
                        if (this.a(uICompArrayArray, n5, n6, uIComp4, hashSet, linkedHashSet)) continue;
                        return false;
                    }
                    continue;
                }
                if (n3 < 0) {
                    n14 = new HashSet();
                    uIComp3 = uIComp + n9;
                    while (--uIComp3 >= uIComp) {
                        uICompArrayArray[uIComp3][iterator + n4 - 1] = null;
                        object = uICompArrayArray[uIComp3][iterator + n4];
                        if (object == null || object instanceof EUIEmpty) continue;
                        ((HashSet)n14).add(object);
                    }
                    linkedHashSet.addAll((Collection<UIComp>)n14);
                    object = ((HashSet)n14).iterator();
                    while (object.hasNext()) {
                        UIComp uIComp5 = (UIComp)object.next();
                        if (this.c(uICompArrayArray, n5, n6, uIComp5, hashSet, linkedHashSet)) continue;
                        return false;
                    }
                    continue;
                }
                if (n2 > 0) {
                    n14 = new HashSet();
                    uIComp3 = iterator + n4;
                    while (--uIComp3 >= iterator) {
                        object = uICompArrayArray[uIComp + n9][uIComp3];
                        if (object == null) continue;
                        if (object instanceof EUIEmpty) {
                            hashSet.add((UIComp)object);
                            this.a(uICompArrayArray, n5, n6, (UIComp)object);
                            continue;
                        }
                        ((HashSet)n14).add(object);
                    }
                    linkedHashSet.addAll((Collection<UIComp>)n14);
                    object = ((HashSet)n14).iterator();
                    while (object.hasNext()) {
                        UIComp n15 = (UIComp)object.next();
                        if (this.b(uICompArrayArray, n5, n6, n15, hashSet, linkedHashSet)) continue;
                        return false;
                    }
                    uIComp = iterator + n4;
                    while (--uIComp >= iterator) {
                        uICompArrayArray[uIComp + n9][uIComp] = object32;
                    }
                    continue;
                }
                n14 = new HashSet();
                uIComp3 = uIComp + n9;
                while (--uIComp3 >= uIComp) {
                    object = uICompArrayArray[uIComp3][iterator + n4];
                    if (object == null) continue;
                    if (object instanceof EUIEmpty) {
                        hashSet.add((UIComp)object);
                        this.a(uICompArrayArray, n5, n6, (UIComp)object);
                        continue;
                    }
                    ((HashSet)n14).add(object);
                }
                linkedHashSet.addAll((Collection<UIComp>)n14);
                object = ((HashSet)n14).iterator();
                while (object.hasNext()) {
                    UIComp n16 = (UIComp)object.next();
                    if (this.d(uICompArrayArray, n5, n6, n16, hashSet, linkedHashSet)) continue;
                    return false;
                }
                int intProp = uIComp + n9;
                while (--intProp >= uIComp) {
                    uICompArrayArray[intProp][iterator + n4] = object32;
                }
            }
            if (!bl) {
                return true;
            }
            ArrayList<a> arrayList = new ArrayList<a>();
            HashMap hashMap = new HashMap();
            for (UIComp uIComp6 : this.a) {
                if (hashSet.contains(uIComp6)) {
                    complexOperation.removeProp((GProp<?>)uIComp6);
                    continue;
                }
                a rectangle = new a(uIComp6);
                arrayList.add(rectangle);
                hashMap.put(uIComp6, rectangle);
            }
            for (UIComp uIComp7 : gridInfo.comps) {
                Rectangle rectangle = ((a)hashMap.get((Object)uIComp7)).a;
                LayoutProp rectangle2 = uIComp7.getLayout();
                n14 = Atom.get((String)"spanX");
                IntProp intProp = (IntProp)rectangle2.getProp((Atom)n14);
                object = Atom.get((String)"spanY");
                IntProp intProp2 = (IntProp)rectangle2.getProp((Atom)object);
                if (n2 != 0) {
                    rectangle.width += n2;
                    if (intProp != null) {
                        complexOperation.setPropValue((GProp<?>)intProp, rectangle.width);
                    } else {
                        try {
                            complexOperation.addProp((PropCnr)rectangle2, (GProp<?>)new IntProp((Atom)n14, rectangle.width));
                        }
                        catch (PropValidateException propValidateException) {
                            // empty catch block
                        }
                    }
                }
                if (n3 == 0) continue;
                rectangle.height += n3;
                if (intProp2 != null) {
                    complexOperation.setPropValue((GProp<?>)intProp2, rectangle.height);
                    continue;
                }
                try {
                    complexOperation.addProp((PropCnr)rectangle2, (GProp<?>)new IntProp((Atom)object, rectangle.height));
                }
                catch (PropValidateException propValidateException) {
                    // empty catch block
                }
            }
            for (UIComp a5 : linkedHashSet) {
                rectangle = ((a)hashMap.get((Object)a5)).a;
                rectangle.x += n2;
                rectangle.y += n3;
            }
            Collections.sort(arrayList, (a2, a3) -> {
                int n2 = a2.a.y - a3.a.y;
                return n2 == 0 ? a2.a.x - a3.a.x : n2;
            });
            if (n2 < 0 || n3 < 0) {
                n6 = 0;
                n5 = 0;
            }
            for (a intProp : arrayList) {
                if (n2 <= 0 && n3 <= 0 && intProp.a instanceof EUIEmpty) continue;
                Rectangle uIComp8 = intProp.a;
                n5 = Math.max(n5, uIComp8.x + uIComp8.width);
                n6 = Math.max(n6, uIComp8.y + uIComp8.height);
            }
            this.grid.clear();
            uIComp = n6;
            while (--uIComp >= 0) {
                this.grid.add(new int[n5]);
            }
            if (n5 != this.columnCount) {
                IntProp a6 = (IntProp)EGridLayout.this.getProp("columnCount");
                if (a6 != null) {
                    complexOperation.setPropValue((GProp<?>)a6, n5);
                } else {
                    try {
                        a6 = new IntProp(Atom.get((String)"columnCount"), n5);
                    }
                    catch (PropValidateException propValidateException) {
                        // empty catch block
                    }
                    complexOperation.addProp((PropCnr)EGridLayout.this, (GProp<?>)a6);
                }
                this.columnCount = n5;
            }
            this.a.clear();
            for (a a4 : arrayList) {
                UIComp uIComp9 = a4.a;
                Rectangle rectangle = a4.a;
                if (rectangle.x + rectangle.width <= n5 && rectangle.y + rectangle.height <= n6) {
                    this.a(rectangle.x, rectangle.y, rectangle.width, rectangle.height, this.a.size());
                    this.a.add(uIComp9);
                    continue;
                }
                assert (uIComp9 instanceof EUIEmpty) : "Non-empty component omitted: " + String.valueOf(uIComp9);
                complexOperation.removeProp((GProp<?>)uIComp9);
            }
            this.consolidateGrid(complexOperation);
            return true;
        }

        private void a(UIComp[][] uICompArray, int n2, int n3, UIComp uIComp) {
            int n4;
            int n5;
            int n6;
            int n7;
            int n8;
            int n9;
            block7: {
                n9 = 1;
                n8 = 1;
                n7 = 0;
                while (n7 < n3) {
                    n6 = 0;
                    while (n6 < n2) {
                        if (uICompArray[n6][n7] == uIComp) {
                            n5 = n6;
                            n4 = n7;
                            while (uICompArray[n5 + n9][n4] == uIComp) {
                                ++n9;
                            }
                            while (uICompArray[n5][n4 + n8] == uIComp) {
                                ++n8;
                            }
                            break block7;
                        }
                        ++n6;
                    }
                    ++n7;
                }
                return;
            }
            n7 = n4 + n8;
            while (--n7 >= n4) {
                n6 = n5 + n9;
                while (--n6 >= n5) {
                    uICompArray[n6][n7] = null;
                }
            }
        }

        private boolean a(UIComp[][] uICompArray, int n2, int n3, UIComp uIComp, HashSet<UIComp> hashSet, LinkedHashSet<UIComp> linkedHashSet) {
            int n4;
            int n5;
            int n6;
            int n7;
            int n8;
            block10: {
                n8 = 1;
                n7 = 1;
                int n9 = 0;
                while (n9 < n3) {
                    n6 = 0;
                    while (n6 < n2) {
                        if (uICompArray[n6][n9] == uIComp) {
                            n5 = n6;
                            n4 = n9;
                            while (uICompArray[n5 + n8][n4] == uIComp) {
                                ++n8;
                            }
                            while (uICompArray[n5][n4 + n7] == uIComp) {
                                ++n7;
                            }
                            break block10;
                        }
                        ++n6;
                    }
                    ++n9;
                }
                return false;
            }
            HashSet<UIComp> hashSet2 = new HashSet<UIComp>();
            n6 = n4 + n7;
            while (--n6 >= n4) {
                UIComp uIComp2 = uICompArray[n5 - 1][n6];
                if (uIComp2 != null) {
                    if (uIComp2 instanceof EUIEmpty) {
                        hashSet.add(uIComp2);
                        this.a(uICompArray, n2, n3, uIComp2);
                    } else {
                        return false;
                    }
                }
                uICompArray[n5 - 1][n6] = uIComp;
                uICompArray[n5 + n8 - 1][n6] = null;
                uIComp2 = uICompArray[n5 + n8][n6];
                if (uIComp2 == null || uIComp2 instanceof EUIEmpty) continue;
                hashSet2.add(uIComp2);
            }
            linkedHashSet.addAll(hashSet2);
            for (UIComp uIComp3 : hashSet2) {
                if (this.a(uICompArray, n2, n3, uIComp3, hashSet, linkedHashSet)) continue;
                return false;
            }
            return true;
        }

        private boolean b(UIComp[][] uICompArray, int n2, int n3, UIComp uIComp, HashSet<UIComp> hashSet, LinkedHashSet<UIComp> linkedHashSet) {
            int n4;
            int n5;
            int n6;
            int n7;
            int n8;
            block9: {
                n8 = 1;
                n7 = 1;
                int n9 = 0;
                while (n9 < n3) {
                    n6 = 0;
                    while (n6 < n2) {
                        if (uICompArray[n6][n9] == uIComp) {
                            n5 = n6;
                            n4 = n9;
                            while (uICompArray[n5 + n8][n4] == uIComp) {
                                ++n8;
                            }
                            while (uICompArray[n5][n4 + n7] == uIComp) {
                                ++n7;
                            }
                            break block9;
                        }
                        ++n6;
                    }
                    ++n9;
                }
                return false;
            }
            HashSet<UIComp> hashSet2 = new HashSet<UIComp>();
            n6 = n4 + n7;
            while (--n6 >= n4) {
                UIComp uIComp2 = uICompArray[n5 + n8][n6];
                if (uIComp2 == null) continue;
                if (uIComp2 instanceof EUIEmpty) {
                    hashSet.add(uIComp2);
                    this.a(uICompArray, n2, n3, uIComp2);
                    continue;
                }
                hashSet2.add(uIComp2);
            }
            linkedHashSet.addAll(hashSet2);
            for (UIComp uIComp3 : hashSet2) {
                if (this.b(uICompArray, n2, n3, uIComp3, hashSet, linkedHashSet)) continue;
                return false;
            }
            int n10 = n4 + n7;
            while (--n10 >= n4) {
                uICompArray[n5][n10] = null;
                uICompArray[n5 + n8][n10] = uIComp;
            }
            return true;
        }

        private boolean c(UIComp[][] uICompArray, int n2, int n3, UIComp uIComp, HashSet<UIComp> hashSet, LinkedHashSet<UIComp> linkedHashSet) {
            int n4;
            int n5;
            int n6;
            int n7;
            int n8;
            block10: {
                n8 = 1;
                n7 = 1;
                int n9 = 0;
                while (n9 < n3) {
                    n6 = 0;
                    while (n6 < n2) {
                        if (uICompArray[n6][n9] == uIComp) {
                            n5 = n6;
                            n4 = n9;
                            while (uICompArray[n5 + n8][n4] == uIComp) {
                                ++n8;
                            }
                            while (uICompArray[n5][n4 + n7] == uIComp) {
                                ++n7;
                            }
                            break block10;
                        }
                        ++n6;
                    }
                    ++n9;
                }
                return false;
            }
            HashSet<UIComp> hashSet2 = new HashSet<UIComp>();
            n6 = n5 + n8;
            while (--n6 >= n5) {
                UIComp uIComp2 = uICompArray[n6][n4 - 1];
                if (uIComp2 != null) {
                    if (uIComp2 instanceof EUIEmpty) {
                        hashSet.add(uIComp2);
                        this.a(uICompArray, n2, n3, uIComp2);
                    } else {
                        return false;
                    }
                }
                uICompArray[n6][n4 - 1] = uIComp;
                uICompArray[n6][n4 + n7 - 1] = null;
                uIComp2 = uICompArray[n6][n4 + n7];
                if (uIComp2 == null || uIComp2 instanceof EUIEmpty) continue;
                hashSet2.add(uIComp2);
            }
            linkedHashSet.addAll(hashSet2);
            for (UIComp uIComp3 : hashSet2) {
                if (this.c(uICompArray, n2, n3, uIComp3, hashSet, linkedHashSet)) continue;
                return false;
            }
            return true;
        }

        private boolean d(UIComp[][] uICompArray, int n2, int n3, UIComp uIComp, HashSet<UIComp> hashSet, LinkedHashSet<UIComp> linkedHashSet) {
            int n4;
            int n5;
            int n6;
            int n7;
            int n8;
            block9: {
                n8 = 1;
                n7 = 1;
                int n9 = 0;
                while (n9 < n3) {
                    n6 = 0;
                    while (n6 < n2) {
                        if (uICompArray[n6][n9] == uIComp) {
                            n5 = n6;
                            n4 = n9;
                            while (uICompArray[n5 + n8][n4] == uIComp) {
                                ++n8;
                            }
                            while (uICompArray[n5][n4 + n7] == uIComp) {
                                ++n7;
                            }
                            break block9;
                        }
                        ++n6;
                    }
                    ++n9;
                }
                return false;
            }
            HashSet<UIComp> hashSet2 = new HashSet<UIComp>();
            n6 = n5 + n8;
            while (--n6 >= n5) {
                UIComp uIComp2 = uICompArray[n6][n4 + n7];
                if (uIComp2 == null) continue;
                if (uIComp2 instanceof EUIEmpty) {
                    hashSet.add(uIComp2);
                    this.a(uICompArray, n2, n3, uIComp2);
                    continue;
                }
                hashSet2.add(uIComp2);
            }
            linkedHashSet.addAll(hashSet2);
            for (UIComp uIComp3 : hashSet2) {
                if (this.d(uICompArray, n2, n3, uIComp3, hashSet, linkedHashSet)) continue;
                return false;
            }
            int n10 = n5 + n8;
            while (--n10 >= n5) {
                uICompArray[n10][n4] = null;
                uICompArray[n10][n4 + n7] = uIComp;
            }
            return true;
        }

        public void list(PrintStream printStream) {
            if (printStream == null) {
                printStream = System.out;
            }
            int n2 = 0;
            printStream.println("\n--- GRID DUMP ---");
            for (int[] nArray : this.grid) {
                printStream.println("\nline " + n2++ + ":");
                int n3 = 0;
                int[] nArray2 = nArray;
                int n4 = nArray.length;
                int n5 = 0;
                while (n5 < n4) {
                    int n6 = nArray2[n5];
                    UIComp uIComp = n6 > 0 ? this.a.get(n6 - 1) : (n6 < 0 ? this.a.get(-n6 - 1) : null);
                    String string = "<n/a>";
                    if (uIComp != null) {
                        StringWriter stringWriter = new StringWriter();
                        uIComp.list(new PrintWriter(stringWriter));
                        string = stringWriter.toString().replace("\n", "\n    | ");
                    }
                    printStream.println(" - " + n3++ + ": index = " + n6 + " ==> " + (String)(uIComp != null ? uIComp.toString() + " --> " + string : ""));
                    ++n5;
                }
            }
        }

        /*
         * Duplicate member names - consider using --renamedupmembers true
         */
        private class a {
            private UIComp a;
            private Rectangle a;

            private a(UIComp uIComp) {
                this.a = uIComp;
                this.a = Grid.this.a(uIComp);
            }
        }
    }
}

