/*
 * Decompiled with CFR 0.152.
 */
package com.iizigo.editor;

import com.iizigo.Activator;
import com.iizigo.editor.P;
import com.iizix.ILog;
import java.util.ArrayDeque;
import java.util.ArrayList;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.AbstractOperation;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IOperationHistoryListener;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.undo.WorkspaceUndoUtil;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class UndoTransaction
extends AbstractOperation {
    private static final IUndoableOperation[] a = new IUndoableOperation[0];
    private static final ArrayDeque<UndoTransaction> a;
    private static final IOperationHistoryListener a;
    private final IOperationHistory a;
    private final ArrayList<IUndoableOperation> a;
    private boolean a = new ArrayList();

    static {
        a = new ArrayDeque();
        a = new P();
    }

    public UndoTransaction(String string, IUndoContext iUndoContext) {
        super(string);
        this.addContext(iUndoContext);
        this.a = PlatformUI.getWorkbench().getOperationSupport().getOperationHistory();
        if (a.isEmpty()) {
            this.a.addOperationHistoryListener(a);
        }
        a.addLast(this);
    }

    public boolean rollback(Shell shell, boolean bl) {
        if (this.a) {
            return true;
        }
        this.a = true;
        if (a.removeLast() != this) {
            throw new InternalError("Wrong call order to rollback transaction");
        }
        if (a.isEmpty()) {
            this.a.removeOperationHistoryListener(a);
        }
        boolean bl2 = true;
        if (bl) {
            try {
                ResourcesPlugin.getWorkspace().run(iProgressMonitor -> {
                    try {
                        IAdaptable iAdaptable = WorkspaceUndoUtil.getUIInfoAdapter((Shell)shell);
                        int n2 = this.a.size();
                        while (--n2 >= 0) {
                            Status status;
                            IUndoableOperation iUndoableOperation = (IUndoableOperation)this.a.get(n2);
                            Object object = status = iUndoableOperation.canUndo() ? iUndoableOperation.undo(iProgressMonitor, iAdaptable) : Activator.createErrorStatus("Rollback undo operation transaction failed, one operation couldn't be undone");
                            if (!status.isOK()) {
                                ILog.SEVERE(((Object)((Object)this)).getClass(), (String)"Rollback undo operation transaction failed", (Object)status);
                                throw new CoreException((IStatus)status);
                            }
                            iUndoableOperation.dispose();
                            this.a.remove(n2);
                        }
                    }
                    catch (ExecutionException executionException) {
                        ILog.SEVERE(((Object)((Object)this)).getClass(), (String)"Rollback undo operation transaction failed, execution error", (Throwable)executionException);
                        Throwable throwable = executionException.getCause();
                        if (throwable instanceof CoreException) {
                            CoreException coreException = (CoreException)throwable;
                            throw coreException;
                        }
                        throw new CoreException((IStatus)new Status(4, "com.iizigo", executionException.getMessage(), (Throwable)executionException));
                    }
                }, null, 1, null);
            }
            catch (CoreException coreException) {
                Activator.openError(shell, "Rollback undo operation error", coreException.getStatus());
                bl2 = false;
            }
            for (IUndoableOperation iUndoableOperation : this.a) {
                this.a.add(iUndoableOperation);
            }
        }
        return bl2;
    }

    public void commit() {
        if (this.a) {
            return;
        }
        this.a = true;
        if (a.removeLast() != this) {
            throw new InternalError("Wrong call order to commit transaction");
        }
        if (a.isEmpty()) {
            this.a.removeOperationHistoryListener(a);
        }
        if (!this.a.isEmpty()) {
            if (this.a.size() == 1) {
                this.a.add((IUndoableOperation)this.a.get(0));
            } else {
                for (IUndoableOperation iUndoableOperation : this.a) {
                    IUndoContext[] iUndoContextArray = iUndoableOperation.getContexts();
                    int n2 = iUndoContextArray.length;
                    int n3 = 0;
                    while (n3 < n2) {
                        IUndoContext iUndoContext = iUndoContextArray[n3];
                        this.addContext(iUndoContext);
                        ++n3;
                    }
                }
                this.a.add((IUndoableOperation)this);
            }
        }
    }

    public void dispose() {
        for (IUndoableOperation iUndoableOperation : this.a) {
            iUndoableOperation.dispose();
        }
    }

    public boolean canExecute() {
        return false;
    }

    public boolean canRedo() {
        for (IUndoableOperation iUndoableOperation : this.a) {
            if (iUndoableOperation.canRedo()) continue;
            return false;
        }
        return true;
    }

    public boolean canUndo() {
        int n2 = this.a.size();
        while (--n2 >= 0) {
            IUndoableOperation iUndoableOperation = (IUndoableOperation)this.a.get(n2);
            if (iUndoableOperation.canUndo()) continue;
            return false;
        }
        return true;
    }

    public IStatus execute(IProgressMonitor iProgressMonitor, IAdaptable iAdaptable) throws ExecutionException {
        throw new InternalError("Should not be executed!");
    }

    public IStatus redo(IProgressMonitor iProgressMonitor, IAdaptable iAdaptable) throws ExecutionException {
        for (IUndoableOperation iUndoableOperation : this.a) {
            if (!iUndoableOperation.canRedo()) {
                return Activator.createErrorStatus("Transactional undo operation cannot be re-done: " + iUndoableOperation.getLabel());
            }
            IStatus iStatus = iUndoableOperation.redo(iProgressMonitor, iAdaptable);
            if (iStatus.isOK()) continue;
            return iStatus;
        }
        return Status.OK_STATUS;
    }

    public IStatus undo(IProgressMonitor iProgressMonitor, IAdaptable iAdaptable) throws ExecutionException {
        int n2 = this.a.size();
        while (--n2 >= 0) {
            IUndoableOperation iUndoableOperation = (IUndoableOperation)this.a.get(n2);
            if (!iUndoableOperation.canUndo()) {
                return Activator.createErrorStatus("Transactional undo operation cannot be undone: " + iUndoableOperation.getLabel());
            }
            IStatus iStatus = iUndoableOperation.undo(iProgressMonitor, iAdaptable);
            if (iStatus.isOK()) continue;
            return iStatus;
        }
        return Status.OK_STATUS;
    }
}

