/**
 * Function ignore(_e)
 * 
 * <p>Ignore mouse and keyboard events.
 * 
 * @type Function
 */
function ignore(_e)
  {
  // Let it pass for the entry fields.
  document.body.style.cursor='default';
  var e=_e || window.event;
  e.cancelBubble=true; // IE
  if ( e.stopPropagation ) e.stopPropagation();
  if ( e.preventDefault  ) e.preventDefault();    
  return false;
  }
  
// Disable mouse and keyboard.
document.onmousedown=
document.onmousemove=
document.onmouseup=
document.oncontextmenu=
document.body.onkeydown=
document.body.onkeypress=
document.body.onkeyup=ignore;

/**
 * Function setPreviewsContent(s)
 * 
 * <p>Setup for the content of the previews.
 * 
 * @type Function
 * 
 * @param {String} s  The content string.
 */
function setPreviewsContent(s)
  {
  // Set "iconN" where N is 1-7.
  for ( var ii=8; --ii; )
    document.getElementById('icon'+ii).innerHTML=s;
  }

/**
 * Function setStateContent(s)
 * 
 * <p>Setup for the content of the previews.
 * 
 * @type Function
 * 
 * @param {String} s  The content string.
 */
function setStateContent(s)
  {
  document.getElementById('icon_normal' ).innerHTML=
  document.getElementById('icon_disable').innerHTML=
  document.getElementById('icon_press'  ).innerHTML=
  document.getElementById('icon_focus'  ).innerHTML=
  document.getElementById('icon_hover'  ).innerHTML=
  document.getElementById('icon_capture').innerHTML=s;
  }

///
/// --- Initialize in a jiffy ---
///

// Asynchronous events are only fired if the browser is ready.
// The browser is not ready when loading.
setTimeout(function()
  {
  // Callback to Eclipse when done.
  onJSInitialized();
  },0);
