/*
 * Decompiled with CFR 0.152.
 */
package com.iizigo.prop.editor;

import com.iizigo.prop.BaseEditor;
import com.iizigo.prop.editor.TransformValidator;
import com.iizigo.prop.editor.dialog.TransformDialog;
import com.iizix.prop.StringProp;
import org.eclipse.swt.widgets.Event;

public class TransformPropEditor
extends BaseEditor<StringProp, String> {
    @Override
    protected void create() {
        this.createGridLayout(2, 0);
        this.createMoreButton("Display Transform designer");
        this.createText();
    }

    @Override
    protected void onDoubleClick(Event event) {
        event.doit = false;
        this.onMore();
    }

    @Override
    public void onMore() {
        String string = new TransformDialog(this.shell, this.getCurrentInput()).open();
        if (string != null) {
            this.setInput(string);
        }
    }

    @Override
    protected String getToolTipText() {
        return "Enter a CSS transform string as \"none | transform-functions(...params)\"";
    }

    @Override
    public String getDefaultValue() {
        return "";
    }

    @Override
    protected String getValue(String string) throws Exception {
        if (string.isEmpty()) {
            return null;
        }
        TransformValidator transformValidator = new TransformValidator(string);
        String string2 = transformValidator.error;
        if (string2 == null) {
            return transformValidator.getCSSValue();
        }
        throw new Exception(string2);
    }

    @Override
    public String formatValue(String string) {
        try {
            return this.getValue(string.trim());
        }
        catch (Exception exception) {
            return string.trim();
        }
    }
}

