/*
 * Decompiled with CFR 0.152.
 */
package com.iizigo.app.prop;

import com.iizigo.app.prop.AppDistributionDesignerProp;
import com.iizigo.project.ModuleModel;
import com.iizigo.project.ProjectManager;
import com.iizigo.prop.IPropDesigner;
import com.iizigo.prop.tooltip.ITooltipPropList;
import com.iizigo.prop.tooltip.TooltipItem;
import com.iizix.prop.Atom;
import com.iizix.prop.BoolProp;
import com.iizix.prop.GProp;
import com.iizix.prop.PropCnr;
import com.iizix.prop.PropVerification;
import com.iizix.prop.PropVerificationError;
import com.iizix.prop.StringProp;
import com.iizix.server.app.prop.ServerAppDistributionProps;
import java.io.File;
import java.nio.file.InvalidPathException;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class AppDistributionProps
extends ServerAppDistributionProps
implements IPropDesigner,
ITooltipPropList {
    private AppDistributionDesignerProp a;
    private ModuleModel a = new AppDistributionDesignerProp((PropCnr)this);
    private static final List<TooltipItem> a;

    static {
        a = List.of(TooltipItem.HEADER_IMAGE_DESCR_TYPE, TooltipItem.SEPARATOR, TooltipItem.newNormal("Name", Atom.NAME), TooltipItem.newNormal("Description", Atom.DESCR), TooltipItem.SPACER_8PX, TooltipItem.newNormal("Group ID", "groupID"), TooltipItem.newNormal("Developer ID", "developerID"), TooltipItem.newNormal("Register app", "registerApp"), TooltipItem.newNormal("Registered App ID", "registeredAppID"), TooltipItem.SPACER_8PX, TooltipItem.newNormal("Destination Jar", "destJar"), TooltipItem.newNormal("Jar compression", "jarCompression"), TooltipItem.newNormal("Jar sealing", "jarSeal"), TooltipItem.newNormal("Jar obfuscation", "jarObfuscation"), TooltipItem.newNormal("Jar signing", "jarSign"), TooltipItem.SPACER_8PX, TooltipItem.newNormal("Include app source", "includeAppSource"), TooltipItem.newNormal("Include externals", "includeExternals"), TooltipItem.SPACER_8PX, TooltipItem.newNormal("Include modules", "modules"));
    }

    public AppDistributionProps() {
    }

    public AppDistributionProps(Atom atom) {
        super(atom);
    }

    public void setModule(ModuleModel moduleModel) {
        this.a = moduleModel;
    }

    public void setLoadedFile(IFile iFile) {
        this.projectDir = iFile.getProject().getLocation().toFile();
    }

    public File getProjectDir() {
        if (this.projectDir != null) {
            return this.projectDir;
        }
        if (this.a == null) {
            throw new InternalError("ModuleModel is not st, cannot return project directory");
        }
        return this.a.getProject().getLocation().toFile();
    }

    @Override
    public AppDistributionDesignerProp getDesigner() {
        return this.a;
    }

    public AppDistributionProps clone() {
        AppDistributionProps appDistributionProps = (AppDistributionProps)super.clone();
        appDistributionProps.a = new AppDistributionDesignerProp((PropCnr)appDistributionProps);
        return appDistributionProps;
    }

    @Override
    public List<TooltipItem> getTooltipPropertyList() {
        return a;
    }

    public boolean verify(PropVerification propVerification) {
        CharSequence[] charSequenceArray;
        File file;
        Object object;
        String string;
        StringProp stringProp;
        if (!super.verify(propVerification)) {
            return false;
        }
        if (this.doRegisterApp()) {
            stringProp = (StringProp)this.getProp(Atom.NAME, StringProp.class);
            if (stringProp == null) {
                propVerification.add(new PropVerificationError((PropCnr)this, Atom.NAME, PropVerificationError.Severity.ERROR, "Name", "Register app requires Name to be filled in", new String[0]));
            } else if (stringProp.getString().isEmpty()) {
                propVerification.add(new PropVerificationError("name", PropVerificationError.Severity.ERROR, "Name", (GProp)stringProp, "Register app requires Name to be filled in", new String[0]));
            }
            stringProp = (StringProp)this.getProp(Atom.DESCR, StringProp.class);
            if (stringProp == null) {
                propVerification.add(new PropVerificationError((PropCnr)this, Atom.DESCR, PropVerificationError.Severity.ERROR, "Description", "Register app requires Description to be filled in", new String[0]));
            } else if (stringProp.getString().isEmpty()) {
                propVerification.add(new PropVerificationError("descr", PropVerificationError.Severity.ERROR, "Description", (GProp)stringProp, "Register app requires Description to be filled in", new String[0]));
            }
            string = this.getGroupID();
            object = this.getDeveloperID();
            if (string.isEmpty() && ((String)object).isEmpty()) {
                stringProp = (StringProp)this.getProp("groupID", StringProp.class);
                if (stringProp == null) {
                    propVerification.add(new PropVerificationError((PropCnr)this, "groupID", PropVerificationError.Severity.ERROR, "Group ID", "Register app requires Group ID or Developer ID to be filled in", new String[0]));
                } else {
                    propVerification.add(new PropVerificationError("grp", PropVerificationError.Severity.ERROR, "Group ID", (GProp)stringProp, "Register app requires Group ID or Developer ID to be filled in", new String[0]));
                }
                stringProp = (StringProp)this.getProp("developerID", StringProp.class);
                if (stringProp == null) {
                    propVerification.add(new PropVerificationError((PropCnr)this, "developerID", PropVerificationError.Severity.ERROR, "Developer ID", "Register app requires Group ID or Developer ID to be filled in", new String[0]));
                } else {
                    propVerification.add(new PropVerificationError("dev", PropVerificationError.Severity.ERROR, "Developer ID", (GProp)stringProp, "Register app requires Group ID or Developer ID to be filled in", new String[0]));
                }
            } else {
                boolean bl = this.doJarSeal();
                boolean bl2 = this.doJarSign();
                if (!bl2) {
                    file = (BoolProp)this.getProp("jarSign", BoolProp.class);
                    if (file == null) {
                        propVerification.add(new PropVerificationError((PropCnr)this, "jarSign", PropVerificationError.Severity.WARNING, "Signing", "Signing the Jar file is a must HIGHLY recommended as the app otherwise could be changed by another developer", new String[0]));
                    } else {
                        propVerification.add(new PropVerificationError("sign", PropVerificationError.Severity.WARNING, "Signing", (GProp)file, "Signing the Jar file is a must HIGHLY recommended as the app otherwise could be changed by another developer", new String[0]));
                    }
                }
                if (!bl) {
                    file = (BoolProp)this.getProp("jarSeal", BoolProp.class);
                    if (file == null) {
                        propVerification.add(new PropVerificationError((PropCnr)this, "jarSeal", PropVerificationError.Severity.WARNING, "Sealing", "Sealing the Jar file is a must HIGHLY recommended as the app otherwise could be changed by another developer", new String[0]));
                    } else {
                        propVerification.add(new PropVerificationError("sign", PropVerificationError.Severity.WARNING, "Sealing", (GProp)file, "Sealing the Jar file is a must HIGHLY recommended as the app otherwise could be changed by another developer", new String[0]));
                    }
                }
                if ((file = (BoolProp)this.getProp("includeAppSource", BoolProp.class)) != null && file.getBool() && bl2 && bl) {
                    propVerification.add(new PropVerificationError("nosrc", PropVerificationError.Severity.WARNING, "Include app's source", (GProp)file, "You should NEVER include the source of the App", new String[0]));
                }
            }
        }
        if ((stringProp = (StringProp)this.getProp("destJar", StringProp.class)) == null) {
            propVerification.add(new PropVerificationError((PropCnr)this, "destJar", PropVerificationError.Severity.WARNING, "Jar file name", "Jar file name must be defined", new String[0]));
        } else {
            string = stringProp.getString();
            if (string.isEmpty()) {
                propVerification.add(new PropVerificationError("fn", PropVerificationError.Severity.WARNING, "Jar file name", (GProp)stringProp, "Jar file name must be specified", new String[0]));
            } else {
                if (!string.endsWith(".jar")) {
                    propVerification.add(new PropVerificationError("ext", PropVerificationError.Severity.WARNING, "Jar file name", (GProp)stringProp, "File extension must be \".jar\"", new String[0]));
                }
                object = null;
                File file2 = this.getProjectDir();
                try {
                    File file3 = file2.toPath().resolve(string).toFile();
                    file = file3.getParentFile();
                    if (file == null) {
                        object = "Invalid destination directory for Jar file: " + file3.getPath();
                    } else if (!file.isDirectory()) {
                        object = "Destination directory '" + file.getAbsolutePath() + "' does not exist";
                    }
                }
                catch (InvalidPathException invalidPathException) {
                    object = "Invalid path for destination directory '" + string + ": " + invalidPathException.getMessage();
                }
                if (object != null) {
                    propVerification.add(new PropVerificationError("fn", PropVerificationError.Severity.ERROR, "Jar file name", (GProp)stringProp, (String)object, new String[0]));
                }
            }
        }
        stringProp = (StringProp)this.getProp("modules", StringProp.class);
        string = null;
        if (stringProp != null) {
            string = stringProp.getString();
            if (string.isEmpty()) {
                propVerification.add(new PropVerificationError("mod", PropVerificationError.Severity.WARNING, "Modules", (GProp)stringProp, "Project name is empty", new String[0]));
            } else {
                int n2 = 0;
                HashSet<String> hashSet = new HashSet<String>();
                String[] stringArray = string.split(",");
                int n3 = stringArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    String string2 = stringArray[n4];
                    if (string2.isEmpty()) {
                        propVerification.add(new PropVerificationError("e" + n2++, PropVerificationError.Severity.ERROR, "Modules", (GProp)stringProp, "Project name is empty", new String[0]));
                    } else {
                        if (this.a != null && this.a.getProject().getName().equals(string2)) {
                            propVerification.add(new PropVerificationError("e" + n2++, PropVerificationError.Severity.ERROR, "Modules", (GProp)stringProp, "Do not specify the current Module '" + string2 + "'", new String[0]));
                        }
                        if (hashSet.contains(string2)) {
                            propVerification.add(new PropVerificationError("e" + n2++, PropVerificationError.Severity.ERROR, "Modules", (GProp)stringProp, "Duplicate Module '" + string2 + "' entry", new String[0]));
                        }
                        hashSet.add(string2);
                        IProject iProject = null;
                        try {
                            iProject = ResourcesPlugin.getWorkspace().getRoot().getProject(string2);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (iProject == null || !iProject.isAccessible()) {
                            propVerification.add(new PropVerificationError("e" + n2++, PropVerificationError.Severity.ERROR, "Modules", (GProp)stringProp, "Project '" + string2 + "' is not found", new String[0]));
                        } else if (!ProjectManager.getInstance().isRegistered(iProject)) {
                            propVerification.add(new PropVerificationError("e" + n2++, PropVerificationError.Severity.ERROR, "Modules", (GProp)stringProp, "Project '" + string2 + "' is not a Module project", new String[0]));
                        }
                    }
                    ++n4;
                }
            }
        }
        if (this.a != null && (string == null || string.isEmpty()) && (charSequenceArray = this.a.getModuleNameReferences()).length > 0) {
            String string3 = charSequenceArray.length == 1 ? "Dependent Module must be specified: " + charSequenceArray[0] : "Dependent Modules must be specified: " + String.join((CharSequence)", ", charSequenceArray);
            stringProp = (StringProp)this.getProp("modules", StringProp.class);
            if (stringProp == null) {
                propVerification.add(new PropVerificationError((PropCnr)this, "modules", PropVerificationError.Severity.ERROR, "Modules", string3, new String[0]));
            } else {
                propVerification.add(new PropVerificationError("modules", PropVerificationError.Severity.ERROR, "Modules", (GProp)stringProp, string3, new String[0]));
            }
        }
        return true;
    }
}

