/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.server;

import com.iizix.ILog;
import com.iizix.IWebServerCompression;
import com.iizix.Loggers;
import com.iizix.RunMode;
import com.iizix.SystemConfig;
import com.iizix.Utilities;
import com.iizix.comm.IServerSettings;
import com.iizix.comm.PortConfig;
import com.iizix.jdbc.JDBCHelper;
import com.iizix.jetty.IExternalBrowserPages;
import com.iizix.jetty.IWSFileProviderServer;
import com.iizix.jetty.IWSUploaderService;
import com.iizix.jetty.IWebServerDirectoryMapper;
import com.iizix.jetty.RunConfigurationWebServer;
import com.iizix.jetty.WSHelper;
import com.iizix.nio.WebSocketAcceptor;
import com.iizix.prop.Atom;
import com.iizix.prop.PropException;
import com.iizix.security.CertificateHelper;
import com.iizix.server.IServer;
import com.iizix.server.ServerShell;
import com.iizix.server.app.AppDefinition;
import com.iizix.server.app.DBApp;
import com.iizix.server.app.SystemApp;
import com.iizix.server.client.ClientEndPointConstructor;
import com.iizix.server.db.DBFunctions;
import com.iizix.server.db.DBUtilities;
import com.iizix.server.devel.ExternalBrowserPagesImpl;
import com.iizix.server.modules.IServerModule;
import com.iizix.server.monitor.VirtualizedMonitorEndPointConstructor;
import com.iizix.server.oauth.OAuthEngine;
import com.iizix.server.prop.ServerSettings;
import com.iizix.server.push.PushNotificationInterceptor;
import com.iizix.server.vsviewer.VSViewerEndPointConstructor;
import com.iizix.web.ICommonServletInterface;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class JettyRunConfiguration
extends ServerShell {
    private String a;
    private String b;
    private File a;
    private final boolean a;
    private RunConfigurationWebServer a;
    private final AppDefinition[] a;
    private boolean b;

    public static void main(String[] stringArray) {
        JettyRunConfiguration.main(stringArray, true, JettyRunConfiguration.class);
    }

    protected static void main(String[] stringArray, boolean bl, Class<? extends JettyRunConfiguration> clazz) {
        RunMode.setRunMode((RunMode)(bl ? RunMode.SERVER_DEVELOPMENT : RunMode.SERVER));
        StringBuilder stringBuilder = new StringBuilder("\nIIZI ").append(bl ? "Development " : "Production ").append("Server, Version ").append(SystemConfig.VERSION_BUILD).append('\n');
        stringBuilder.append("-".repeat(stringBuilder.length() - 2)).append("\n\n").append("(C) Copyright Mindus SARL, 2025.\nAll rights reserved.").append('\n');
        if (!SystemConfig.HAS_UNLIMITED_CRYPTO) {
            System.err.println(String.valueOf(stringBuilder) + "\nJava Unlimited Cryptography is missing or cannot be configured!\niiziServer does not function if the Java Unlimited JCE Policy is not installed\nin JRE/JDK lib/security directory.\n\nPlease download it from the Oracle Java site\nand install it before continuing.\n\niiziServer cannot start.\n\n");
            System.exit(9);
        }
        if (stringArray.length == 0) {
            System.out.println(JettyRunConfiguration.addSyntax(bl, stringBuilder));
            System.exit(9);
        }
        System.out.println(stringBuilder);
        ILog.setLogLevel((int)3);
        ArrayList<IServerModule> arrayList = new ArrayList<IServerModule>();
        HashMap<String, File> hashMap = new HashMap<String, File>();
        File file = new File("config.iiziServer").getAbsoluteFile();
        Object object = null;
        ServerShell serverShell = null;
        boolean bl2 = false;
        try {
            Object object2;
            String string;
            String string2 = null;
            String string3 = null;
            int n = stringArray.length;
            HashMap<Object, String> hashMap2 = new HashMap<Object, String>();
            LinkedHashMap<String, AppDefinition> linkedHashMap = new LinkedHashMap<String, AppDefinition>();
            boolean bl3 = true;
            boolean bl4 = true;
            String string4 = string = "default";
            String string5 = null;
            String string6 = null;
            String string7 = null;
            String string8 = null;
            Integer n2 = null;
            Boolean bl5 = null;
            Boolean bl6 = null;
            boolean bl7 = false;
            int n3 = 0;
            while (n3 < n) {
                block139: {
                    object2 = stringArray[n3].toLowerCase();
                    boolean bl8 = ((String)object2).startsWith("##");
                    do {
                        if (++n3 >= n) {
                            if (!bl8) {
                                throw new Exception("Illegal option " + (String)object2 + ": missing parameter");
                            }
                            break block139;
                        }
                        if (bl8) break block139;
                    } while (stringArray[n3].startsWith("##"));
                    String string9 = Utilities.unquotedStringWithSpaces((String)stringArray[n3]);
                    switch (object2) {
                        case "-config": {
                            file = new File(string9).getCanonicalFile();
                            if (file.isFile()) break;
                            throw new FileNotFoundException("Configuration file '" + file.getPath() + "' does not exist");
                        }
                        case "-defaultenv": {
                            if (string9.isEmpty()) {
                                throw new Exception("Empty default server environment name");
                            }
                            string = string4 = string9;
                            break;
                        }
                        case "-serverdescr": {
                            if (string9.isEmpty()) {
                                throw new Exception("Empty server description, often a (double-)quoted string");
                            }
                            if (string5 != null) {
                                throw new Exception("Server description is set twice, first time = \"" + string5 + "\"");
                            }
                            string5 = string9;
                            break;
                        }
                        case "-compresshtml": {
                            boolean bl9;
                            if (bl) {
                                bl9 = string9.equalsIgnoreCase("true");
                                if (!bl9 && !string9.equalsIgnoreCase("false")) {
                                    object = "Set compressHTML flag \"" + (String)string9 + "\" error: must be 'true' or 'false'";
                                    throw new Exception((String)object);
                                }
                                bl2 = bl9;
                                break;
                            }
                            object = "Unknown option " + (String)object2;
                            throw new Exception((String)object);
                        }
                        case "-jdbcdrivers": {
                            boolean bl10 = string9.equalsIgnoreCase("privatecopy");
                            object = bl10 || string9.equalsIgnoreCase("private") ? JDBCHelper.setUsePrivateDirectory((boolean)bl10) : "Set jdbcdrivers flag must be \"" + (String)string9 + "\" error: must be 'private' or 'privatecopy'";
                            break;
                        }
                        case "-dbconf": {
                            object = "Database configuration directory \"" + Utilities.getCanonicalFile((String)string9).getPath() + "\" error";
                            DBUtilities.setDBConfDir(string9);
                            break;
                        }
                        case "-dbdir": {
                            object = "Set database directory \"" + (String)string9 + "\" error";
                            string7 = string9;
                            DBUtilities.setDirectory(string9);
                            break;
                        }
                        case "-dbhost": {
                            object = "Set database host \"" + (String)string9 + "\" error";
                            string8 = string9;
                            DBUtilities.setServerHost(string9);
                            break;
                        }
                        case "-dbport": {
                            object = "Set database port \"" + (String)string9 + "\" error";
                            n2 = Integer.parseInt(string9);
                            DBUtilities.setServerPort(n2);
                            break;
                        }
                        case "-dbautocreate": {
                            boolean bl9 = string9.equalsIgnoreCase("true");
                            if (!bl9 && !string9.equalsIgnoreCase("false")) {
                                object = "Set database auto-creation flag \"" + (String)string9 + "\" error: must be 'true' or 'false'";
                                throw new Exception((String)object);
                            }
                            bl5 = bl9;
                            break;
                        }
                        case "-dbautostart": {
                            boolean bl9 = string9.equalsIgnoreCase("true");
                            if (!bl9 && !string9.equalsIgnoreCase("false")) {
                                object = "Set database server auto-start flag \"" + (String)string9 + "\" error: must be 'true' or 'false'";
                                throw new Exception((String)object);
                            }
                            bl6 = bl9;
                            break;
                        }
                        case "-extserverurl": {
                            if (string9.isEmpty()) {
                                object = "External server URL is empty";
                                throw new Exception("External server URL is empty");
                            }
                            object = WSHelper.validateExternalHostName((String)string9);
                            if (object != null) {
                                throw new Exception((String)object);
                            }
                            string2 = string9;
                            break;
                        }
                        case "-root": {
                            object = "Invalid root: " + (String)string9;
                            File file2 = new File(string9).getCanonicalFile();
                            if (!file2.isDirectory()) {
                                throw new FileNotFoundException("Directory '" + file2.getPath() + "' does not exist");
                            }
                            string3 = file2.getPath();
                            break;
                        }
                        case "-alias": {
                            String string10 = Utilities.unquotedStringWithSpaces((String)string9);
                            if (n3 + 1 >= n) {
                                throw new Exception("Directory alias '" + string10 + "' does not specify a directory");
                            }
                            String string11 = Utilities.unquotedStringWithSpaces((String)stringArray[++n3]);
                            File file3 = null;
                            try {
                                file3 = new File(string11).getCanonicalFile();
                                if (!file3.isDirectory() || !file3.canRead()) {
                                    throw new Exception("Directory alias '" + string10 + "', directory \"" + String.valueOf(file3) + "\" does not exist or cannot be read from");
                                }
                            }
                            catch (IOException iOException) {
                                throw new Exception("Directory alias '" + string10 + "' does not specify a directory: " + string11);
                            }
                            hashMap.put(string10, file3);
                            break;
                        }
                        case "-hotdeploy": {
                            boolean bl9 = Boolean.parseBoolean(string9);
                            if (string6 == null) {
                                bl4 = bl9;
                                break;
                            }
                            bl3 = bl9;
                            break;
                        }
                        case "-app": {
                            Object object3;
                            String[] stringArray2 = string9.split(":");
                            if (stringArray2.length == 0 || (string6 = stringArray2[0]).isEmpty()) {
                                throw new Exception("App ID is not specified: " + (String)string9);
                            }
                            if (linkedHashMap.containsKey(stringArray2[0])) {
                                throw new Exception("App ID already specified: " + stringArray2[0]);
                            }
                            String[] stringArray3 = stringArray2;
                            int n4 = stringArray2.length;
                            int n5 = 0;
                            while (n5 < n4) {
                                object3 = stringArray3[n5];
                                IServer.InvalidAppID invalidAppID = IServer.validateAppID((String)object3);
                                if (invalidAppID != null) {
                                    throw new Exception(invalidAppID.englishText + ": " + (String)object3);
                                }
                                if (hashMap2.putIfAbsent(object3, string6) != null) {
                                    throw new Exception("App (alias) ID '" + (String)object3 + "' already specified: " + (String)string9);
                                }
                                ++n5;
                            }
                            bl7 = false;
                            bl3 = bl4;
                            break;
                        }
                        case "-env": {
                            if (string9.isEmpty()) {
                                throw new Exception("Empty server environment name");
                            }
                            string4 = string9;
                            break;
                        }
                        case "-project": {
                            if (string6 == null) {
                                throw new Exception("Application ID not specified (-app AppID) prior to project (-project NAME=path)");
                            }
                            if (bl7) {
                                throw new Exception("Projects cannot be mixed with a single Application Jar file in Application ID " + string6);
                            }
                            object = "Invalid project: " + (String)string9;
                            File file2 = new File(string9).getCanonicalFile();
                            if (!file2.isDirectory()) {
                                throw new FileNotFoundException("Directory does not exist");
                            }
                            Object object3 = (AppDefinition)linkedHashMap.get(string6);
                            if (object3 == null) {
                                object3 = new AppDefinition(string6, string4, null, bl3);
                                linkedHashMap.put(string6, (AppDefinition)object3);
                            }
                            ((AppDefinition)object3).addModuleDirectory(file2);
                            break;
                        }
                        case "-appjar": {
                            if (string6 == null) {
                                throw new Exception("Application ID not specified (-app AppID) prior to project (-appjar NAME=path)");
                            }
                            if (bl7) {
                                throw new Exception("A single Application Jar file per Application ID (" + string6 + ") is allowed");
                            }
                            object = "Invalid application jar: " + (String)string9;
                            File file4 = new File(string9).getCanonicalFile();
                            if (!file4.isFile()) {
                                throw new FileNotFoundException("Application jar file does not exist: " + (String)string9);
                            }
                            if (!file4.getName().toLowerCase().endsWith(".jar")) {
                                throw new FileNotFoundException("Application jar file name must end with \".jar\": " + (String)string9);
                            }
                            Object object3 = new AppDefinition(string6, string4, file4, bl3);
                            linkedHashMap.put(string6, (AppDefinition)object3);
                            bl7 = true;
                            break;
                        }
                        case "-module": {
                            if (bl) {
                                throw new Exception("Server Modules is only available in Standard iiziServer");
                            }
                            try {
                                IServerModule iServerModule = (IServerModule)IServerModule.class.cast(Class.forName(string9).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
                                arrayList.add(iServerModule);
                                break;
                            }
                            catch (Throwable throwable) {
                                throw new Exception("Server Module " + (String)string9 + " failed loading", throwable);
                            }
                        }
                        case "-#eclipsecertsdir#": {
                            if (bl) {
                                File file5 = Utilities.getCanonicalFile((File)new File(string9));
                                try {
                                    JettyRunConfiguration.a(file5);
                                    break;
                                }
                                catch (Exception exception) {
                                    object = "Failed loading code signing certificate from \"" + String.valueOf(file5) + "\"";
                                    throw new Exception((String)object, exception);
                                }
                            }
                        }
                        default: {
                            for (IServerModule iServerModule : arrayList) {
                                int n6 = iServerModule.processServerArg(stringArray, string9, n3 + 1);
                                if (n6 <= 0) continue;
                                n3 += n6 - 1;
                                break;
                            }
                            object = "Unknown option " + (String)object2;
                            throw new Exception((String)object);
                        }
                    }
                }
                ++n3;
            }
            stringBuilder.setLength(0);
            stringBuilder.append("Config file         = ").append(file.getAbsolutePath()).append('\n').append("Environment         = ").append(string4).append('\n');
            if (string2 != null) {
                stringBuilder.append("External server URL = ").append(string2).append('\n');
            }
            if (string5 != null) {
                stringBuilder.append("Server description  = ").append(string5).append('\n');
            }
            stringBuilder.append("Web server root     = ").append(string3).append('\n').append("Hot deploy          = ").append(bl4).append('\n').append("Database directory  = ").append(DBUtilities.getDatabaseDirectory());
            System.out.println(stringBuilder);
            if (linkedHashMap.isEmpty()) {
                System.out.println("No IIZI Module projects are specified!");
                System.exit(9);
            }
            if (!file.isFile()) {
                System.out.println("Server configuration file '" + file.getAbsolutePath() + "' is not found");
                System.exit(9);
            }
            object = "Failed server creation";
            AppDefinition[] appDefinitionArray = linkedHashMap.values().toArray(new AppDefinition[linkedHashMap.size()]);
            serverShell = clazz.getConstructor(File.class, String.class, String.class, Boolean.TYPE, appDefinitionArray.getClass(), Map.class).newInstance(file, string2, string3, bl4, appDefinitionArray, hashMap2);
            try {
                SystemApp.loadApp(serverShell.getPropertyFactory(), serverShell.getPropertyManager());
            }
            catch (PropException | IOException throwable) {
                throw new IOException("Failed loading System application", throwable);
            }
            object2 = serverShell.getServerSettings();
            if (string5 != null) {
                ((ServerSettings)((Object)object2)).setDescription(string5);
            }
            ((JettyRunConfiguration)serverShell).b = bl2;
            serverShell.loadPluginsAndConfig();
            serverShell.configureSessionMgr();
            for (IServerModule iServerModule : arrayList) {
                serverShell.addModule(iServerModule);
            }
            if (string7 == null) {
                string7 = (String)object2.getPropValue("$dbDirectory", String.class);
            }
            if (string8 == null) {
                string8 = (String)object2.getPropValue("$dbHost", String.class);
            }
            if (n2 == null) {
                n2 = (Integer)object2.getPropValue("$dbPort", Integer.class);
            }
            if (bl5 == null) {
                bl5 = (Boolean)object2.getPropValue("$dbAutoCreate", Boolean.class);
            }
            if (bl6 == null) {
                bl6 = (Boolean)object2.getPropValue("$dbAutoStart", Boolean.class);
            }
            if (string7 != null) {
                object = "Database directory \"" + string7 + "\" configuration parameter error";
                DBUtilities.setDirectory(string7);
            }
            if (string8 != null) {
                object = "Database host \"" + string8 + "\" configuration parameter error";
                DBUtilities.setServerHost(string8);
            }
            if (n2 != null) {
                object = "Database server port number configuration parameter error";
                DBUtilities.setServerPort(n2);
            }
            if (bl5 != null) {
                DBUtilities.setAutoCreate(bl5);
            }
            if (bl6 != null) {
                DBUtilities.setServerAutoStart(bl6);
            }
            object = "Failed starting server";
            serverShell.startServer();
        }
        catch (Throwable throwable) {
            ILog.SEVERE(clazz, object, (Throwable)throwable);
            ILog.SEVERE(clazz, (String)"iiziServer failed to start, exiting with RC = 9");
            Loggers.setRedirector(null);
            if (serverShell != null) {
                serverShell.dispose();
            }
            Throwable throwable2 = null;
            Object var12_16 = null;
            try (PrintStream printStream = Loggers.get_stdout();){
                printStream.println(JettyRunConfiguration.addSyntax(bl, new StringBuilder()));
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
            System.exit(9);
        }
    }

    protected static String addSyntax(boolean bl, StringBuilder stringBuilder) {
        stringBuilder.append("\nSyntax:\n  ##[anytext]   Any option or parameter prefixed with '##' will automatically discard the option followed by its parameter.\n\nGeneral:\n  -config       {path/config.iiziServer}  Specifies the server configuration file\n  -defaultenv   {envName} config          Sets the default environment name\n  -extserverurl {URL}                     Sets the external URL of the server as e.g. http[s]://hostName[:port]/[path/]\n  -serverDescr  {String}                  Sets the description of the server, overriding the server settings\n");
        if (bl) {
            stringBuilder.append("  -compressHTML {true|false}              Enables compression of e.g. iiziApp.html, iiziVSViewer.html (default true)\n");
        }
        stringBuilder.append("\nDatabase:\n  -dbconf       {driverspec-URL}          Database configuration directory with JDBC driver Jar, settings, etc\n  -dbdir        {directory}               Sets the database directory for the iiziServer (default 'db')\n  -dbhost       {nameOrIPaddress}         Sets the host name or IP address to the Derby server (default localhost)\n  -dbport       {port}                    Sets the port number to the Derby server (default 1527)\n  -dbautostart  {true|false}              Turns on (default) or off automatic database server start\n  -dbautocreate {true|false}              Turns on (default) or off database creation at start\n\nApplication:\n  -hotdeploy    {true|false}              Turns on (default) or off for the application defintions that follows\n  -app          {appID:...:appIDnn}       Begins the definition of the application 'appID' with additional colon-separated aliases\n  -env          {name}                    Defines the name for the application environment (specify -env after -app)\n  -project      {directory}               A module project directory 'dir' (as defined in Eclipse) to the current application\n  -appjar       {iiziApp.jar}             Adds an IIZI Distribution Application 'iiziApp.jar' by Jar file path and name\n\n");
        if (!bl) {
            stringBuilder.append("Modules:\n  -module       fullyQualifiedclassName   Adds a server module to load and initialize\n\n");
        }
        return stringBuilder.toString();
    }

    private static void a(File file) throws CertificateException, FileNotFoundException, IOException {
        X509Certificate[] x509CertificateArray = CertificateHelper.loadCertificates((File)file);
        CertificateHelper.assignCertificateFromEclipseBundle(clazz -> {
            String string = clazz.getName();
            return string.startsWith("com.iizix.") || string.startsWith("com.iizigo.") ? x509CertificateArray : CertificateHelper.EMPTY_ARRAY;
        });
    }

    public JettyRunConfiguration(File file, String string, String string2, boolean bl, AppDefinition[] appDefinitionArray, Map<String, String> map) throws IOException, PropException {
        super(file);
        this.a = string;
        this.a = new File(string2).getCanonicalFile();
        this.b = string2;
        this.a = bl;
        this.a = appDefinitionArray;
        this.a(map);
    }

    @Override
    public void onStartServer() throws Throwable {
        Object object;
        if (this.a() == null) {
            throw new Exception("License System is not found");
        }
        ServerSettings serverSettings = this.getServerProperties().getServerSettings();
        if (this.a != null) {
            serverSettings.setExternalHostName(this.a);
        } else {
            this.a = serverSettings.getExternalHostName();
        }
        if (this.b != null) {
            serverSettings.setRootDirectory(this.b);
        } else if (serverSettings.getString(Atom.ROOT) == null) {
            try {
                this.b = new File("/iizi/com.iizix.js/js/root").getCanonicalPath();
            }
            catch (IOException iOException) {
                this.b = new File(".").getAbsolutePath();
            }
            serverSettings.setRootDirectory(this.b);
        } else {
            this.b = serverSettings.getRootDirectory();
        }
        DBUtilities.getPooledConnection().close();
        this.registerEndPointConstructor(new ClientEndPointConstructor());
        if (RunMode.isServerRunDevelopmentMode()) {
            this.registerEndPointConstructor(new VirtualizedMonitorEndPointConstructor());
            this.registerEndPointConstructor(new VSViewerEndPointConstructor());
        }
        this.a = new RunConfigurationWebServer(this.b, (IWSFileProviderServer)this.a, (IWSUploaderService)this.a);
        this.externalBrowserPages = new ExternalBrowserPagesImpl(this);
        ICommonServletInterface[] iCommonServletInterfaceArray = new ICommonServletInterface[]{PushNotificationInterceptor.register(this)};
        PortConfig[] portConfigArray = this.a.startWebServer((IExternalBrowserPages)this.externalBrowserPages, (WebSocketAcceptor)this, (IServerSettings)serverSettings, () -> {
            this.initializeCompressedFiles();
            return null;
        }, iCommonServletInterfaceArray);
        String string = null;
        boolean bl = false;
        int n = 0;
        int n2 = 0;
        PortConfig[] portConfigArray2 = portConfigArray;
        int n3 = portConfigArray.length;
        int n4 = 0;
        while (n4 < n3) {
            object = portConfigArray2[n4];
            if (object.isHTTPS) {
                n2 = object.port;
                string = object.bind;
                break;
            }
            if (object.isFrontEndSecured) {
                bl = true;
                string = object.bind;
                break;
            }
            n = object.port;
            string = object.bind;
            ++n4;
        }
        object = WSHelper.getExternalBaseServerURL((String)this.a, string, (int)n, (int)n2, (boolean)bl);
        OAuthEngine.initializeNewInstance((String)object);
        ILog.INFO(this.getClass(), (String)("Web server external server URL is " + (String)object));
    }

    @Override
    public String getRootDirectory() {
        return this.b;
    }

    @Override
    public File getRootCanonicalDirectory() {
        return this.a;
    }

    public final boolean useHotDeploy() {
        return this.a;
    }

    @Override
    public final void loadApplications() throws Throwable {
        Object object;
        HashSet<String> hashSet = new HashSet<String>();
        AppDefinition[] appDefinitionArray = this.a;
        int n = this.a.length;
        int n2 = 0;
        while (n2 < n) {
            object = appDefinitionArray[n2];
            ((AppDefinition)object).loadApplication(this);
            hashSet.add(((AppDefinition)object).id);
            ++n2;
        }
        object = DBFunctions.getEnabledApps(hashSet);
        DBApp[] dBAppArray = object;
        int n3 = ((DBApp[])object).length;
        n = 0;
        while (n < n3) {
            DBApp dBApp = dBAppArray[n];
            AppDefinition appDefinition = new AppDefinition(dBApp, this.a);
            appDefinition.loadApplication(this);
            ++n;
        }
    }

    @Override
    protected void onDispose() {
        if (this.a != null) {
            this.a.stopWebServer(5000L);
        }
    }

    @Override
    public File getWebServerMapping(String string) {
        return this.a != null ? this.a.getWebServerMapping(string) : null;
    }

    @Override
    public IWebServerCompression getWebServerCompression() {
        return this.a;
    }

    @Override
    public boolean doCompressNormalHTML() {
        return SystemConfig.WEB_COMPRESS || this.b;
    }

    public Proxy getProxy(URL uRL) {
        return Proxy.NO_PROXY;
    }

    public void configureProxy(HttpURLConnection httpURLConnection) {
    }

    @Override
    public final IWebServerDirectoryMapper getWebServerDirectoryMapper() {
        return this.a;
    }
}

