/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.image;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.imageio.ImageIO;

public class RoundedCorners {
    public static void round(File file, File file2, String string, int n2) throws IOException {
        BufferedImage bufferedImage = ImageIO.read(file);
        BufferedImage bufferedImage2 = RoundedCorners.round(bufferedImage, n2);
        Throwable throwable = null;
        Object var7_8 = null;
        try (FileOutputStream fileOutputStream = new FileOutputStream(file2);){
            ImageIO.write((RenderedImage)bufferedImage2, string, fileOutputStream);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static BufferedImage round(BufferedImage bufferedImage, int n2) {
        if (n2 < 0 || n2 > 100) {
            throw new IllegalArgumentException("radiusPercent must be 0-100: " + n2);
        }
        int n3 = bufferedImage.getWidth();
        int n4 = bufferedImage.getHeight();
        int n5 = Math.max(n3, n4);
        int n6 = 100 * n5 / n2;
        BufferedImage bufferedImage2 = new BufferedImage(n3, n4, 2);
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        graphics2D.setComposite(AlphaComposite.Src);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setColor(Color.WHITE);
        graphics2D.fill(new RoundRectangle2D.Float(0.0f, 0.0f, n3, n4, n6, n6));
        graphics2D.setComposite(AlphaComposite.SrcAtop);
        graphics2D.drawImage((Image)bufferedImage, 0, 0, null);
        graphics2D.dispose();
        return bufferedImage2;
    }
}

