/*
 * Decompiled with CFR 0.152.
 */
package com.tabnine.eclipse.shared.api.binary.fetch;

import com.tabnine.eclipse.shared.api.binary.fetch.BinaryValidator;
import com.tabnine.eclipse.shared.api.binary.fetch.BinaryVersion;
import com.tabnine.eclipse.shared.api.services.ConfigService;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BinaryFetchUtils {
    static Logger logger = LogManager.getLogger(BinaryFetchUtils.class);
    public static final String BAD_VERSION = "4.0.47";
    public static final String TARGET_NAME = BinaryFetchUtils.getDistributionName();
    public static final String EXECUTABLE_NAME = BinaryFetchUtils.getExeName();
    public static final String USER_HOME_PATH_PROPERTY = "user.home";
    public static final String TABNINE_FOLDER_NAME = ConfigService.CONFIG.isSelfHosted() ? ".tabnine-eclipse-enterprise" : ".tabnine-eclipse";
    public static final String REMOTE_BASE_URL_PROPERTY = "TABNINE_REMOTE_BASE_URL";
    public static final String REMOTE_VERSION_URL_PROPERTY = "TABNINE_REMOTE_VERSION_URL";
    public static final int REMOTE_CONNECTION_TIMEOUT = 5000;
    public static final int BINARY_READ_TIMEOUT = 300000;
    public static final String TABNINE_BINARY_DIR_NAME = ConfigService.CONFIG.isSelfHosted() ? "tabnine-eclipse-selfhosted" : "tabnine-eclipse";
    public static final String TABNINE_BINARY_LOCATION = System.getenv("TABNINE_BINARY_LOCATION");
    public static final String TABNINE_DATA_LOCATION = System.getenv("TABNINE_DATA_LOCATION");

    public static Path getBaseDirectory() {
        if (TABNINE_BINARY_LOCATION != null && !TABNINE_BINARY_LOCATION.isEmpty()) {
            return Paths.get(BinaryFetchUtils.expandTilde(TABNINE_BINARY_LOCATION).toString(), TABNINE_BINARY_DIR_NAME);
        }
        if (TABNINE_DATA_LOCATION != null && !TABNINE_DATA_LOCATION.isEmpty()) {
            return Paths.get(BinaryFetchUtils.expandTilde(TABNINE_DATA_LOCATION).toString(), TABNINE_BINARY_DIR_NAME);
        }
        return Paths.get(System.getProperty(USER_HOME_PATH_PROPERTY), TABNINE_FOLDER_NAME);
    }

    private static Path expandTilde(String string) {
        if (string.startsWith("~/") || string.startsWith("~\\")) {
            return Paths.get(System.getProperty(USER_HOME_PATH_PROPERTY), string.substring(2)).normalize();
        }
        return Paths.get(string, new String[0]).normalize();
    }

    public static Path getActiveVersionPath() {
        return BinaryFetchUtils.getBaseDirectory().resolve(".active");
    }

    public static String getServerUrl() {
        return Optional.ofNullable(System.getProperty(REMOTE_BASE_URL_PROPERTY)).orElse(ConfigService.CONFIG.getServerUrl());
    }

    public static String versionFullPath(String string) {
        return Paths.get(BinaryFetchUtils.getBaseDirectory().toString(), string, TARGET_NAME, EXECUTABLE_NAME).toString();
    }

    public static String getTabNineBundleVersionUrl() {
        return Optional.ofNullable(System.getProperty(REMOTE_VERSION_URL_PROPERTY)).orElse(String.valueOf(BinaryFetchUtils.getBundleServerUrl()) + "/version");
    }

    public static String getBundleServerUrl() {
        return Optional.ofNullable(System.getProperty(REMOTE_BASE_URL_PROPERTY)).orElse(String.valueOf(ConfigService.CONFIG.getServerUrl()) + ConfigService.CONFIG.getBundlesUrlPath());
    }

    private static String getExeName() {
        if (System.getProperty("os.name").toLowerCase().contains("win")) {
            return "TabNine.exe";
        }
        return "TabNine";
    }

    private static String getDistributionName() {
        String string;
        String string2 = System.getProperty("os.arch");
        String string3 = string = string2 != null && string2.contains("32") ? "i686" : "x86_64";
        if ("aarch64".equals(string2)) {
            string = "aarch64";
        }
        if ((string2 = System.getProperty("os.name").toLowerCase()).contains("win")) {
            string2 = "pc-windows-gnu";
        } else if (string2.contains("nix") || string2.contains("nux") || string2.contains("aix")) {
            string2 = "unknown-linux-musl";
        } else if (string2.contains("mac")) {
            string2 = "apple-darwin";
        } else {
            throw new RuntimeException("Platform was not recognized as any of Windows, macOS, Linux, FreeBSD");
        }
        return String.valueOf(string) + "-" + string2;
    }

    public static String bundleFullPath(String string) {
        return Paths.get(BinaryFetchUtils.getBaseDirectory().toString(), string, TARGET_NAME, "TabNine.zip").toString();
    }

    public static String readContent(InputStream inputStream) {
        int n2;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[1024];
        while ((n2 = inputStream.read(byArray)) != -1) {
            byteArrayOutputStream.write(byArray, 0, n2);
        }
        return byteArrayOutputStream.toString(StandardCharsets.UTF_8.name()).trim();
    }

    public static Optional<BinaryVersion> activeVersion() {
        List<String> list = BinaryFetchUtils.readActiveFile();
        if (list.size() == 0) {
            return Optional.empty();
        }
        if (((String)((Object)(list = list.get(0)))).equals(BAD_VERSION)) {
            return Optional.empty();
        }
        if (!new BinaryValidator().isWorking(((BinaryVersion)((Object)(list = new BinaryVersion((String)((Object)list))))).getVersionFullPath())) {
            logger.warn("Version in .active file is not working");
            return Optional.empty();
        }
        return Optional.of(list);
    }

    private static List<String> readActiveFile() {
        Path path = BinaryFetchUtils.getActiveVersionPath();
        List<String> list = new ArrayList<String>();
        if (path.toFile().exists()) {
            try {
                list = Files.readAllLines(path);
            }
            catch (IOException iOException) {
                logger.warn("Failed to read .active file", (Throwable)iOException);
            }
        }
        return list;
    }
}

