/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.extension;

import org.eclipse.core.resources.IProject;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.elements.ElementList;
import org.eclipse.pde.internal.ui.wizards.extension.ExtensionEditorSelectionPage;
import org.eclipse.pde.internal.ui.wizards.extension.NewExtensionRegistryReader;

public class ExtensionEditorWizard
extends Wizard {
    public static final String PLUGIN_POINT = "newExtension";
    private ExtensionEditorSelectionPage pointPage;
    private final IPluginModelBase model;
    private final IProject project;
    private final IStructuredSelection selection;
    private ElementList wizards;

    public ExtensionEditorWizard(IProject project, IPluginModelBase model, IStructuredSelection selection) {
        this.setDialogSettings(PDEPlugin.getDefault().getDialogSettings());
        this.setDefaultPageImageDescriptor(PDEPluginImages.DESC_NEWEX_WIZ);
        this.model = model;
        this.project = project;
        this.selection = selection;
        this.setForcePreviousAndNextButtons(true);
        this.setWindowTitle(PDEUIMessages.ExtensionEditorWizard_wtitle);
        PDEPlugin.getDefault().getLabelProvider().connect((Object)this);
        this.loadWizardCollection();
    }

    public void addPages() {
        this.pointPage = new ExtensionEditorSelectionPage(this.wizards);
        this.pointPage.init(this.project, this.model.getPluginBase(), this.selection);
        this.addPage((IWizardPage)this.pointPage);
    }

    private void loadWizardCollection() {
        NewExtensionRegistryReader reader = new NewExtensionRegistryReader(true);
        this.wizards = reader.readRegistry(PDEPlugin.getPluginId(), PLUGIN_POINT, true);
    }

    public boolean performFinish() {
        return true;
    }

    public void dispose() {
        super.dispose();
        PDEPlugin.getDefault().getLabelProvider().disconnect((Object)this);
    }
}

