/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.plugin;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.pde.core.IModel;
import org.eclipse.pde.internal.core.project.PDEProject;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.editor.PDEFormEditor;
import org.eclipse.pde.internal.ui.wizards.ResizableWizardDialog;
import org.eclipse.pde.internal.ui.wizards.exports.PluginExportWizard;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.wizards.IWizardDescriptor;

public class PluginExportAction
extends Action {
    private PDEFormEditor fEditor;

    public PluginExportAction(PDEFormEditor editor) {
        this.fEditor = editor;
    }

    public PluginExportAction() {
    }

    private void ensureContentSaved() {
        if (this.fEditor.isDirty()) {
            try {
                IRunnableWithProgress op = monitor -> this.fEditor.doSave(monitor);
                PlatformUI.getWorkbench().getProgressService().runInUI((IRunnableContext)PDEPlugin.getActiveWorkbenchWindow(), op, (ISchedulingRule)PDEPlugin.getWorkspace().getRoot());
            }
            catch (InvocationTargetException e) {
                PDEPlugin.logException(e);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void run() {
        IWizardDescriptor descriptor;
        StructuredSelection selection;
        if (this.fEditor != null) {
            this.ensureContentSaved();
        }
        IResource resource = null;
        if (this.fEditor != null) {
            IModel model = (IModel)this.fEditor.getAggregateModel();
            resource = model == null ? null : model.getUnderlyingResource();
        }
        String customWizard = null;
        if (resource != null) {
            selection = new StructuredSelection(resource);
            IProject project = resource.getProject();
            if (project != null) {
                customWizard = PDEProject.getExportWizard((IProject)project);
            }
        } else {
            selection = new StructuredSelection();
        }
        PluginExportWizard wizard = null;
        if (customWizard != null && (descriptor = PlatformUI.getWorkbench().getExportWizardRegistry().findWizard(customWizard)) != null) {
            try {
                wizard = descriptor.createWizard();
            }
            catch (CoreException e) {
                PDEPlugin.log(e);
                this.notifyResult(false);
                return;
            }
        }
        if (wizard == null) {
            wizard = new PluginExportWizard();
        }
        wizard.init(PlatformUI.getWorkbench(), (IStructuredSelection)selection);
        ResizableWizardDialog wd = new ResizableWizardDialog(PDEPlugin.getActiveWorkbenchShell(), (IWizard)wizard);
        wd.create();
        int result = wd.open();
        this.notifyResult(result == 0);
    }
}

