/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.push.vapid;

import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.util.Base64;
import org.bouncycastle.jce.ECNamedCurveTable;
import org.bouncycastle.jce.interfaces.ECPrivateKey;
import org.bouncycastle.jce.interfaces.ECPublicKey;
import org.bouncycastle.jce.spec.ECNamedCurveParameterSpec;
import org.bouncycastle.jce.spec.ECParameterSpec;
import org.bouncycastle.jce.spec.ECPrivateKeySpec;
import org.bouncycastle.jce.spec.ECPublicKeySpec;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.util.BigIntegers;

public class Utils {
    public static final String CURVE = "prime256v1";
    public static final String ALGORITHM = "ECDH";

    public static byte[] encode(ECPublicKey eCPublicKey) {
        return eCPublicKey.getQ().getEncoded(false);
    }

    public static byte[] encode(ECPrivateKey eCPrivateKey) {
        return eCPrivateKey.getD().toByteArray();
    }

    public static PublicKey loadPublicKey(String string) throws NoSuchProviderException, NoSuchAlgorithmException, InvalidKeySpecException {
        byte[] byArray = Base64.getUrlDecoder().decode(string);
        return Utils.loadPublicKey(byArray);
    }

    public static PublicKey loadPublicKey(byte[] byArray) throws NoSuchProviderException, NoSuchAlgorithmException, InvalidKeySpecException {
        KeyFactory keyFactory = KeyFactory.getInstance(ALGORITHM, "BC");
        ECNamedCurveParameterSpec eCNamedCurveParameterSpec = ECNamedCurveTable.getParameterSpec((String)CURVE);
        ECCurve eCCurve = eCNamedCurveParameterSpec.getCurve();
        ECPoint eCPoint = eCCurve.decodePoint(byArray);
        ECPublicKeySpec eCPublicKeySpec = new ECPublicKeySpec(eCPoint, (ECParameterSpec)eCNamedCurveParameterSpec);
        return keyFactory.generatePublic((KeySpec)eCPublicKeySpec);
    }

    public static PrivateKey loadPrivateKey(String string) throws NoSuchProviderException, NoSuchAlgorithmException, InvalidKeySpecException {
        byte[] byArray = Base64.getUrlDecoder().decode(string);
        return Utils.loadPrivateKey(byArray);
    }

    public static PrivateKey loadPrivateKey(byte[] byArray) throws NoSuchProviderException, NoSuchAlgorithmException, InvalidKeySpecException {
        BigInteger bigInteger = BigIntegers.fromUnsignedByteArray((byte[])byArray);
        ECNamedCurveParameterSpec eCNamedCurveParameterSpec = ECNamedCurveTable.getParameterSpec((String)CURVE);
        ECPrivateKeySpec eCPrivateKeySpec = new ECPrivateKeySpec(bigInteger, (ECParameterSpec)eCNamedCurveParameterSpec);
        KeyFactory keyFactory = KeyFactory.getInstance(ALGORITHM, "BC");
        return keyFactory.generatePrivate((KeySpec)eCPrivateKeySpec);
    }

    public static ECPublicKey loadPublicKey(ECPrivateKey eCPrivateKey) throws NoSuchProviderException, NoSuchAlgorithmException, InvalidKeySpecException {
        KeyFactory keyFactory = KeyFactory.getInstance(ALGORITHM, "BC");
        ECNamedCurveParameterSpec eCNamedCurveParameterSpec = ECNamedCurveTable.getParameterSpec((String)CURVE);
        ECPoint eCPoint = eCNamedCurveParameterSpec.getG().multiply(eCPrivateKey.getD());
        byte[] byArray = eCPoint.getEncoded(false);
        ECPoint eCPoint2 = eCNamedCurveParameterSpec.getCurve().decodePoint(byArray);
        ECPublicKeySpec eCPublicKeySpec = new ECPublicKeySpec(eCPoint2, (ECParameterSpec)eCNamedCurveParameterSpec);
        return (ECPublicKey)keyFactory.generatePublic((KeySpec)eCPublicKeySpec);
    }

    public static boolean verifyKeyPair(PrivateKey privateKey, PublicKey publicKey) {
        ECNamedCurveParameterSpec eCNamedCurveParameterSpec = ECNamedCurveTable.getParameterSpec((String)CURVE);
        ECPoint eCPoint = eCNamedCurveParameterSpec.getG();
        ECPoint eCPoint2 = eCPoint.multiply(((java.security.interfaces.ECPrivateKey)privateKey).getS());
        return eCPoint2.equals(((ECPublicKey)publicKey).getQ());
    }

    public static byte[] concat(byte[] ... byArray) {
        int n2 = 0;
        byte[] byArray2 = new byte[Utils.combinedLength(byArray)];
        byte[][] byArray3 = byArray;
        int n3 = byArray.length;
        int n4 = 0;
        while (n4 < n3) {
            byte[] byArray4 = byArray3[n4];
            if (byArray4 != null) {
                System.arraycopy(byArray4, 0, byArray2, n2, byArray4.length);
                n2 += byArray4.length;
            }
            ++n4;
        }
        return byArray2;
    }

    public static int combinedLength(byte[] ... byArray) {
        int n2 = 0;
        byte[][] byArray2 = byArray;
        int n3 = byArray.length;
        int n4 = 0;
        while (n4 < n3) {
            byte[] byArray3 = byArray2[n4];
            if (byArray3 != null) {
                n2 += byArray3.length;
            }
            ++n4;
        }
        return n2;
    }

    public static byte[] toByteArray(int n2, int n3) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(n3);
        byteBuffer.putInt(n2);
        return byteBuffer.array();
    }
}

