/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.prop;

import com.iizix.ILog;
import com.iizix.LocaleInfo;
import com.iizix.ReadTransaction;
import com.iizix.SendTransaction;
import com.iizix.Utilities;
import com.iizix.Value;
import com.iizix.prop.Atom;
import com.iizix.prop.StringArrayProp;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.DateTimeException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeParseException;
import java.time.temporal.Temporal;
import java.util.Arrays;
import java.util.Set;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class GDateTime
implements Cloneable {
    public static final GDateTime EPOCH_DATE = new GDateTime(LocalDate.of(1970, 1, 1));
    public static final GDateTime MIDNIGHT = new GDateTime(LocalTime.MIDNIGHT);
    private static final StringArrayProp a;
    private static final Set<String> a;
    private final Type a;
    private final Object a;
    private String a;
    private static volatile /* synthetic */ int[] a;

    static {
        a = ZoneId.getAvailableZoneIds();
        String[] stringArray = a.toArray(new String[a.size()]);
        Arrays.sort(stringArray, Utilities.COLLATOR);
        a = StringArrayProp.createUnmodifiableReadOnly(Atom.ZONES, stringArray);
    }

    public static StringArrayProp createTimeZonesProp() {
        return a.clone();
    }

    public static Type getType(Object object) {
        if (object instanceof LocalTime) {
            return Type.LocalTime;
        }
        if (object instanceof OffsetTime) {
            return Type.OffsetTime;
        }
        if (object instanceof LocalDate) {
            return Type.LocalDate;
        }
        if (object instanceof LocalDateTime) {
            return Type.LocalDateTime;
        }
        if (object instanceof OffsetDateTime) {
            return Type.OffsetDateTime;
        }
        if (object instanceof ZonedDateTime) {
            return Type.ZonedDateTime;
        }
        if (object instanceof ZoneId) {
            return Type.ZoneId;
        }
        return null;
    }

    public static int nanoOfSecond(java.util.Date date) {
        return (int)(date.getTime() % 1000L) * 1000000;
    }

    public static GDateTime fromTime(Time time) {
        return new GDateTime(time.toLocalTime());
    }

    public static GDateTime fromTime(java.util.Date date) {
        return new GDateTime(LocalTime.from(Instant.ofEpochMilli(date.getTime())));
    }

    public static GDateTime fromDate(Date date) {
        return new GDateTime(date.toLocalDate());
    }

    public static GDateTime fromDate(java.util.Date date) {
        return new GDateTime(LocalDate.of(date.getYear() + 1900, date.getMonth() + 1, date.getDate()));
    }

    public static GDateTime fromDateTime(Timestamp timestamp) {
        return new GDateTime(timestamp.toLocalDateTime());
    }

    public static GDateTime fromDateTime(java.util.Date date) {
        return new GDateTime(LocalDateTime.of(date.getYear() + 1900, date.getMonth() + 1, date.getDate(), date.getHours(), date.getMinutes(), date.getSeconds(), GDateTime.nanoOfSecond(date)));
    }

    public static GDateTime fromString(Type type, String string) throws DateTimeParseException {
        switch (GDateTime.a()[type.ordinal()]) {
            case 1: {
                return new GDateTime(LocalTime.parse(string));
            }
            case 2: {
                return new GDateTime(OffsetTime.parse(string));
            }
            case 3: {
                return new GDateTime(LocalDate.parse(string));
            }
            case 4: {
                return new GDateTime(LocalDateTime.parse(string));
            }
            case 5: {
                return new GDateTime(OffsetDateTime.parse(string));
            }
            case 6: {
                return new GDateTime(ZonedDateTime.parse(string));
            }
            case 7: {
                return new GDateTime(ZoneId.of(string));
            }
        }
        throw new DateTimeException("Invalid date type: " + String.valueOf((Object)type));
    }

    public static GDateTime now(Type type, LocaleInfo localeInfo) {
        switch (GDateTime.a()[type.ordinal()]) {
            case 1: {
                return new GDateTime(LocalTime.now());
            }
            case 2: {
                return new GDateTime(OffsetTime.now(LocaleInfo.getNonNull(localeInfo, false).getZoneId()));
            }
            case 3: {
                return new GDateTime(LocalDate.now());
            }
            case 4: {
                return new GDateTime(LocalDateTime.now());
            }
            case 5: {
                return new GDateTime(OffsetDateTime.now(LocaleInfo.getNonNull(localeInfo, false).getZoneId()));
            }
            case 6: {
                return new GDateTime(ZonedDateTime.now(LocaleInfo.getNonNull(localeInfo, false).getZoneId()));
            }
            case 7: {
                return new GDateTime(LocaleInfo.getNonNull(localeInfo, false).getZoneId());
            }
        }
        throw new DateTimeException("Invalid date type: " + String.valueOf((Object)type));
    }

    public static GDateTime fromValue(Value value) {
        if (value.isNull()) {
            throw new IllegalArgumentException("Value is null");
        }
        switch (value.type) {
            case LocalTime: {
                return new GDateTime((LocalTime)value.value);
            }
            case OffsetTime: {
                return new GDateTime((OffsetTime)value.value);
            }
            case LocalDate: {
                return new GDateTime((LocalDate)value.value);
            }
            case LocalDateTime: {
                return new GDateTime((LocalDateTime)value.value);
            }
            case OffsetDateTime: {
                return new GDateTime((OffsetDateTime)value.value);
            }
            case ZonedDateTime: {
                return new GDateTime((ZonedDateTime)value.value);
            }
        }
        throw new IllegalArgumentException("Illegal type: " + String.valueOf((Object)value.type));
    }

    public GDateTime(LocalTime localTime) {
        if (localTime == null) {
            throw new NullPointerException("localTime is null");
        }
        this.a = localTime;
        this.a = Type.LocalTime;
    }

    public GDateTime(OffsetTime offsetTime) {
        if (offsetTime == null) {
            throw new NullPointerException("offsetTime is null");
        }
        this.a = offsetTime;
        this.a = Type.OffsetTime;
    }

    public GDateTime(LocalDate localDate) {
        if (localDate == null) {
            throw new NullPointerException("parameter is null");
        }
        this.a = localDate;
        this.a = Type.LocalDate;
    }

    public GDateTime(LocalDateTime localDateTime) {
        if (localDateTime == null) {
            throw new NullPointerException("localDateTime is null");
        }
        this.a = localDateTime;
        this.a = Type.LocalDateTime;
    }

    public GDateTime(OffsetDateTime offsetDateTime) {
        if (offsetDateTime == null) {
            throw new NullPointerException("offsetDateTime is null");
        }
        this.a = offsetDateTime;
        this.a = Type.OffsetDateTime;
    }

    public GDateTime(ZonedDateTime zonedDateTime) {
        if (zonedDateTime == null) {
            throw new NullPointerException("offsetDateTime is null");
        }
        this.a = zonedDateTime;
        this.a = Type.ZonedDateTime;
    }

    public GDateTime(ZoneId zoneId) {
        if (zoneId == null) {
            throw new NullPointerException("zone is null");
        }
        this.a = zoneId;
        this.a = Type.ZoneId;
    }

    GDateTime(String string) {
        int n2 = string.indexOf(44);
        if (n2 < 0) {
            throw new DateTimeParseException("Missing GDateTime Type", string, 0);
        }
        try {
            this.a = Type.valueOf(string.substring(0, n2));
        }
        catch (Exception exception) {
            throw new DateTimeParseException("Invalid GDateTime Type", string, 0);
        }
        string = string.substring(n2 + 1);
        this.a = switch (GDateTime.a()[this.a.ordinal()]) {
            case 1 -> LocalTime.parse(string);
            case 2 -> OffsetTime.parse(string);
            case 3 -> LocalDate.parse(string);
            case 4 -> LocalDateTime.parse(string);
            case 5 -> OffsetDateTime.parse(string);
            case 6 -> ZonedDateTime.parse(string);
            case 7 -> ZoneId.of(string);
            default -> throw new InternalError("Unknown type: " + String.valueOf((Object)this.a));
        };
    }

    GDateTime(ReadTransaction readTransaction) throws DateTimeParseException {
        this.a = Type.values()[readTransaction.readByte()];
        ZoneOffset zoneOffset = null;
        ZoneId zoneId = null;
        switch (GDateTime.a()[this.a.ordinal()]) {
            case 2: 
            case 5: 
            case 6: {
                zoneOffset = ZoneOffset.ofTotalSeconds(readTransaction.readSigned() * 60);
                this.a = readTransaction.readString();
                try {
                    zoneId = ZoneId.of(this.a);
                }
                catch (DateTimeException dateTimeException) {
                    zoneId = ZoneId.ofOffset("GMT", zoneOffset);
                    ILog.WARNING(this.getClass(), "Invalid Zone ID from remote party: '" + this.a + "', assuming '" + String.valueOf(zoneId) + "'");
                }
                break;
            }
            case 7: {
                this.a = readTransaction.readString();
                try {
                    zoneId = ZoneId.of(this.a);
                    break;
                }
                catch (DateTimeException dateTimeException) {
                    zoneId = ZoneId.ofOffset("GMT", zoneOffset);
                    ILog.WARNING(this.getClass(), "Invalid Zone ID from remote party: '" + this.a + "', assuming '" + String.valueOf(zoneId) + "'");
                }
            }
        }
        this.a = switch (GDateTime.a()[this.a.ordinal()]) {
            case 1 -> LocalTime.of(readTransaction.readByte(), readTransaction.readByte(), readTransaction.readByte(), readTransaction.readUnsigned() * 1000000);
            case 2 -> OffsetTime.of(readTransaction.readByte(), readTransaction.readByte(), readTransaction.readByte(), readTransaction.readUnsigned() * 1000000, zoneOffset);
            case 3 -> LocalDate.of(readTransaction.readSigned(), readTransaction.readByte(), readTransaction.readByte());
            case 4 -> LocalDateTime.of(readTransaction.readSigned(), readTransaction.readByte(), readTransaction.readByte(), readTransaction.readByte(), readTransaction.readByte(), readTransaction.readByte(), readTransaction.readUnsigned() * 1000000);
            case 5 -> OffsetDateTime.of(readTransaction.readSigned(), readTransaction.readByte(), readTransaction.readByte(), readTransaction.readByte(), readTransaction.readByte(), readTransaction.readByte(), readTransaction.readUnsigned() * 1000000, zoneOffset);
            case 6 -> ZonedDateTime.of(readTransaction.readSigned(), readTransaction.readByte(), readTransaction.readByte(), readTransaction.readByte(), readTransaction.readByte(), readTransaction.readByte(), readTransaction.readUnsigned() * 1000000, zoneId);
            case 7 -> zoneId;
            default -> throw new InternalError("Unknown type: " + String.valueOf((Object)this.a));
        };
    }

    public boolean hasDate() {
        return this.a != Type.LocalTime && this.a != Type.OffsetTime;
    }

    public boolean hasTime() {
        return this.a != Type.LocalDate;
    }

    public boolean hasTimeOffset() {
        return this.a == Type.OffsetTime || this.a == Type.OffsetDateTime;
    }

    void a(SendTransaction sendTransaction) {
        sendTransaction.appendByte(this.a.ordinal());
        switch (GDateTime.a()[this.a.ordinal()]) {
            case 1: {
                LocalTime localTime = (LocalTime)this.a;
                sendTransaction.appendByte(localTime.getHour());
                sendTransaction.appendByte(localTime.getMinute());
                sendTransaction.appendByte(localTime.getSecond());
                sendTransaction.appendUnsigned(localTime.getNano() / 1000000);
                break;
            }
            case 2: {
                OffsetTime offsetTime = (OffsetTime)this.a;
                ZoneOffset zoneOffset = offsetTime.getOffset();
                sendTransaction.appendSigned(zoneOffset.getTotalSeconds() / 60);
                sendTransaction.appendString(zoneOffset.getId());
                LocalTime localTime = offsetTime.toLocalTime();
                sendTransaction.appendByte(localTime.getHour());
                sendTransaction.appendByte(localTime.getMinute());
                sendTransaction.appendByte(localTime.getSecond());
                sendTransaction.appendUnsigned(localTime.getNano() / 1000000);
                break;
            }
            case 3: {
                LocalDate localDate = (LocalDate)this.a;
                sendTransaction.appendSigned(localDate.getYear());
                sendTransaction.appendByte(localDate.getMonthValue());
                sendTransaction.appendByte(localDate.getDayOfMonth());
                break;
            }
            case 4: {
                LocalDateTime localDateTime = (LocalDateTime)this.a;
                sendTransaction.appendSigned(localDateTime.getYear());
                sendTransaction.appendByte(localDateTime.getMonthValue());
                sendTransaction.appendByte(localDateTime.getDayOfMonth());
                sendTransaction.appendByte(localDateTime.getHour());
                sendTransaction.appendByte(localDateTime.getMinute());
                sendTransaction.appendByte(localDateTime.getSecond());
                sendTransaction.appendUnsigned(localDateTime.getNano() / 1000000);
                break;
            }
            case 5: {
                OffsetDateTime offsetDateTime = (OffsetDateTime)this.a;
                ZoneOffset zoneOffset = offsetDateTime.getOffset();
                sendTransaction.appendSigned(zoneOffset.getTotalSeconds() / 60);
                sendTransaction.appendString(zoneOffset.getId());
                LocalDateTime localDateTime = offsetDateTime.toLocalDateTime();
                sendTransaction.appendSigned(localDateTime.getYear());
                sendTransaction.appendByte(localDateTime.getMonthValue());
                sendTransaction.appendByte(localDateTime.getDayOfMonth());
                sendTransaction.appendByte(localDateTime.getHour());
                sendTransaction.appendByte(localDateTime.getMinute());
                sendTransaction.appendByte(localDateTime.getSecond());
                sendTransaction.appendUnsigned(localDateTime.getNano() / 1000000);
                break;
            }
            case 6: {
                ZonedDateTime zonedDateTime = (ZonedDateTime)this.a;
                sendTransaction.appendSigned(zonedDateTime.getOffset().getTotalSeconds() / 60);
                String string = zonedDateTime.getZone().getId();
                sendTransaction.appendString(a.contains(string) ? string : "GMT");
                LocalDateTime localDateTime = zonedDateTime.toLocalDateTime();
                sendTransaction.appendSigned(localDateTime.getYear());
                sendTransaction.appendByte(localDateTime.getMonthValue());
                sendTransaction.appendByte(localDateTime.getDayOfMonth());
                sendTransaction.appendByte(localDateTime.getHour());
                sendTransaction.appendByte(localDateTime.getMinute());
                sendTransaction.appendByte(localDateTime.getSecond());
                sendTransaction.appendUnsigned(localDateTime.getNano() / 1000000);
                break;
            }
            case 7: {
                ZoneId zoneId = (ZoneId)this.a;
                String string = zoneId.getId();
                sendTransaction.appendString(a.contains(string) ? string : "GMT");
            }
        }
    }

    public boolean equals(Object object) {
        return object == this || object instanceof GDateTime && this.a.equals(((GDateTime)object).a);
    }

    public Type getType() {
        return this.a;
    }

    public Temporal getValue() {
        return this.a != Type.ZoneId ? (Temporal)this.a : null;
    }

    public String getString() {
        return this.paramString();
    }

    public String getValueString() {
        return this.a.toString();
    }

    protected String paramString() {
        return this.a.toString() + "," + String.valueOf(this.a);
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.paramString() + "]";
    }

    public LocalTime getLocalTime() {
        return this.a == Type.LocalTime ? (LocalTime)this.a : null;
    }

    public OffsetTime getOffsetTime() {
        return this.a == Type.OffsetTime ? (OffsetTime)this.a : null;
    }

    public LocalDate getLocalDate() {
        return this.a == Type.LocalDate ? (LocalDate)this.a : null;
    }

    public LocalDateTime getLocalDateTime() {
        return this.a == Type.LocalDateTime ? (LocalDateTime)this.a : null;
    }

    public OffsetDateTime getOffsetDateTime() {
        return this.a == Type.OffsetDateTime ? (OffsetDateTime)this.a : null;
    }

    public ZonedDateTime getZonedDateTime() {
        return this.a == Type.ZonedDateTime ? (ZonedDateTime)this.a : null;
    }

    public ZoneOffset getOffset() {
        switch (GDateTime.a()[this.a.ordinal()]) {
            case 2: {
                return ((OffsetTime)this.a).getOffset();
            }
            case 5: {
                return ((OffsetDateTime)this.a).getOffset();
            }
            case 6: {
                return ((ZonedDateTime)this.a).getOffset();
            }
        }
        return null;
    }

    public ZoneId getZone() {
        switch (GDateTime.a()[this.a.ordinal()]) {
            case 2: {
                return ((OffsetTime)this.a).getOffset();
            }
            case 5: {
                return ((OffsetDateTime)this.a).getOffset();
            }
            case 6: {
                return ((ZonedDateTime)this.a).getZone();
            }
            case 7: {
                return (ZoneId)this.a;
            }
        }
        return null;
    }

    public String getGivenZoneName() {
        if (this.a != null) {
            return this.a;
        }
        ZoneId zoneId = this.getZone();
        return zoneId != null ? zoneId.getId() : null;
    }

    public GDateTime toDateValue() {
        switch (GDateTime.a()[this.a.ordinal()]) {
            case 1: {
                throw new IllegalStateException("Cannot convert GDateTime value to LocalDate, LocalTime: " + String.valueOf(this.a));
            }
            case 2: {
                throw new IllegalStateException("Cannot convert GDateTime value to LocalDate, OffsetTime: " + String.valueOf(this.a));
            }
            case 3: {
                return this;
            }
            case 4: {
                return new GDateTime(((LocalDateTime)this.a).toLocalDate());
            }
            case 5: {
                return new GDateTime(((OffsetDateTime)this.a).toLocalDate());
            }
            case 6: {
                return new GDateTime(((ZonedDateTime)this.a).toLocalDate());
            }
            case 7: {
                throw new IllegalStateException("Cannot convert GDateTime value to LocalDate, ZoneId: " + String.valueOf(this.a));
            }
        }
        throw new InternalError("Unknown GDateTime Type: " + String.valueOf((Object)this.a));
    }

    public GDateTime toTimeValue() {
        switch (GDateTime.a()[this.a.ordinal()]) {
            case 1: 
            case 2: {
                return this;
            }
            case 3: {
                throw new IllegalStateException("Cannot convert GDateTime value to time value, LocalDate: " + String.valueOf(this.a));
            }
            case 4: {
                return new GDateTime(((LocalDateTime)this.a).toLocalTime());
            }
            case 5: {
                return new GDateTime(((OffsetDateTime)this.a).toOffsetTime());
            }
            case 6: {
                return new GDateTime(((ZonedDateTime)this.a).toOffsetDateTime().toOffsetTime());
            }
            case 7: {
                throw new IllegalStateException("Cannot convert GDateTime value to time value, ZoneId: " + String.valueOf(this.a));
            }
        }
        throw new InternalError("Unknown GDateTime Type: " + String.valueOf((Object)this.a));
    }

    public LocalTime toLocalTime() {
        switch (GDateTime.a()[this.a.ordinal()]) {
            case 1: {
                return (LocalTime)this.a;
            }
            case 2: {
                return ((OffsetTime)this.a).toLocalTime();
            }
            case 3: {
                throw new IllegalStateException("Cannot convert GDateTime value to LocalTime, LocalDate: " + String.valueOf(this.a));
            }
            case 4: {
                return ((LocalDateTime)this.a).toLocalTime();
            }
            case 5: {
                return ((OffsetDateTime)this.a).toLocalTime();
            }
            case 6: {
                return ((ZonedDateTime)this.a).toLocalTime();
            }
            case 7: {
                throw new IllegalStateException("Cannot convert GDateTime value to LocalTime, ZoneId: " + String.valueOf(this.a));
            }
        }
        throw new InternalError("Unknown GDateTime Type: " + String.valueOf((Object)this.a));
    }

    public OffsetTime toOffsetTime(LocaleInfo localeInfo) {
        switch (GDateTime.a()[this.a.ordinal()]) {
            case 1: {
                return OffsetTime.of((LocalTime)this.a, LocaleInfo.getNonNull(localeInfo, false).getZoneOffset());
            }
            case 2: {
                return (OffsetTime)this.a;
            }
            case 3: {
                throw new IllegalStateException("Cannot convert GDateTime value to OffsetTime, LocalDate: " + String.valueOf(this.a));
            }
            case 4: {
                return OffsetTime.of(((LocalDateTime)this.a).toLocalTime(), LocaleInfo.getNonNull(localeInfo, false).getZoneOffset());
            }
            case 5: {
                return ((OffsetDateTime)this.a).toOffsetTime();
            }
            case 6: {
                return ((ZonedDateTime)this.a).toOffsetDateTime().toOffsetTime();
            }
            case 7: {
                throw new IllegalStateException("Cannot convert GDateTime value to OffsetTime, ZoneId: " + String.valueOf(this.a));
            }
        }
        throw new InternalError("Unknown GDateTime Type: " + String.valueOf((Object)this.a));
    }

    public LocalDate toLocalDate() {
        switch (GDateTime.a()[this.a.ordinal()]) {
            case 1: {
                throw new IllegalStateException("Cannot convert GDateTime value to LocalDate, LocalTime: " + String.valueOf(this.a));
            }
            case 2: {
                throw new IllegalStateException("Cannot convert GDateTime value to LocalDate, OffsetTime: " + String.valueOf(this.a));
            }
            case 3: {
                return (LocalDate)this.a;
            }
            case 4: {
                return ((LocalDateTime)this.a).toLocalDate();
            }
            case 5: {
                return ((OffsetDateTime)this.a).toLocalDate();
            }
            case 6: {
                return ((ZonedDateTime)this.a).toLocalDate();
            }
            case 7: {
                throw new IllegalStateException("Cannot convert GDateTime value to LocalDate, ZoneId: " + String.valueOf(this.a));
            }
        }
        throw new InternalError("Unknown GDateTime Type: " + String.valueOf((Object)this.a));
    }

    public LocalDateTime toLocalDateTime() {
        switch (GDateTime.a()[this.a.ordinal()]) {
            case 1: {
                throw new IllegalStateException("Cannot convert GDateTime value to LocalDateTime, LocalTime: " + String.valueOf(this.a));
            }
            case 2: {
                throw new IllegalStateException("Cannot convert GDateTime value to LocalDateTime, OffsetTime: " + String.valueOf(this.a));
            }
            case 3: {
                throw new IllegalStateException("Cannot convert GDateTime value to LocalDateTime, LocalDate: " + String.valueOf(this.a));
            }
            case 4: {
                return (LocalDateTime)this.a;
            }
            case 5: {
                return ((OffsetDateTime)this.a).toLocalDateTime();
            }
            case 6: {
                return ((ZonedDateTime)this.a).toLocalDateTime();
            }
            case 7: {
                throw new IllegalStateException("Cannot convert GDateTime value to LocalDateTime, ZoneId: " + String.valueOf(this.a));
            }
        }
        throw new InternalError("Unknown GDateTime Type: " + String.valueOf((Object)this.a));
    }

    public OffsetDateTime toOffsetDateTime(LocaleInfo localeInfo) {
        switch (GDateTime.a()[this.a.ordinal()]) {
            case 1: {
                throw new IllegalStateException("Cannot convert GDateTime value to OffsetDateTime, LocalTime: " + String.valueOf(this.a));
            }
            case 2: {
                throw new IllegalStateException("Cannot convert GDateTime value to OffsetDateTime, OffsetTime: " + String.valueOf(this.a));
            }
            case 3: {
                throw new IllegalStateException("Cannot convert GDateTime value to OffsetDateTime, LocalDate: " + String.valueOf(this.a));
            }
            case 4: {
                return ((LocalDateTime)this.a).atOffset(LocaleInfo.getNonNull(localeInfo, false).getZoneOffset());
            }
            case 5: {
                return (OffsetDateTime)this.a;
            }
            case 6: {
                return ((ZonedDateTime)this.a).toOffsetDateTime();
            }
            case 7: {
                throw new IllegalStateException("Cannot convert GDateTime value to OffsetDateTime, ZoneId: " + String.valueOf(this.a));
            }
        }
        throw new InternalError("Unknown GDateTime Type: " + String.valueOf((Object)this.a));
    }

    public ZonedDateTime toZonedDateTime(LocaleInfo localeInfo) {
        switch (GDateTime.a()[this.a.ordinal()]) {
            case 1: {
                throw new IllegalStateException("Cannot convert GDateTime value to ZonedDateTime, LocalTime: " + String.valueOf(this.a));
            }
            case 2: {
                throw new IllegalStateException("Cannot convert GDateTime value to ZonedDateTime, OffsetTime: " + String.valueOf(this.a));
            }
            case 3: {
                throw new IllegalStateException("Cannot convert GDateTime value to ZonedDateTime, LocalDate: " + String.valueOf(this.a));
            }
            case 4: {
                return ((LocalDateTime)this.a).atZone(LocaleInfo.getNonNull(localeInfo, false).getZoneId());
            }
            case 5: {
                return ((OffsetDateTime)this.a).toZonedDateTime();
            }
            case 6: {
                return (ZonedDateTime)this.a;
            }
            case 7: {
                throw new IllegalStateException("Cannot convert GDateTime value to ZonedDateTime, ZoneId: " + String.valueOf(this.a));
            }
        }
        throw new InternalError("Unknown GDateTime Type: " + String.valueOf((Object)this.a));
    }

    public GDateTime toType(Type type, LocaleInfo localeInfo) {
        if (type == this.a) {
            return this;
        }
        switch (GDateTime.a()[type.ordinal()]) {
            case 1: {
                return new GDateTime(this.toLocalTime());
            }
            case 2: {
                return new GDateTime(this.toOffsetTime(localeInfo));
            }
            case 3: {
                return new GDateTime(this.toLocalDate());
            }
            case 4: {
                return new GDateTime(this.toLocalDateTime());
            }
            case 5: {
                return new GDateTime(this.toOffsetDateTime(localeInfo));
            }
            case 6: {
                return new GDateTime(this.toZonedDateTime(localeInfo));
            }
            case 7: {
                ZoneId zoneId = this.getZone();
                if (zoneId == null) {
                    throw new IllegalStateException("Cannot convert GDateTime value to ZoneId, " + String.valueOf((Object)type) + ": " + String.valueOf(this.a));
                }
                return new GDateTime(zoneId);
            }
        }
        throw new InternalError("Unknown GDateTime Type: " + String.valueOf((Object)type));
    }

    static /* synthetic */ int[] a() {
        if (a != null) {
            return a;
        }
        int[] nArray = new int[Type.values().length];
        try {
            nArray[Type.LocalDate.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Type.LocalDateTime.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Type.LocalTime.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Type.OffsetDateTime.ordinal()] = 5;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Type.OffsetTime.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Type.ZoneId.ordinal()] = 7;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Type.ZonedDateTime.ordinal()] = 6;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        a = nArray;
        return nArray;
    }

    public static enum Type {
        LocalTime,
        OffsetTime,
        LocalDate,
        LocalDateTime,
        OffsetDateTime,
        ZonedDateTime,
        ZoneId;

    }
}

