/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.prop;

public class ClasspathEntry {
    public final Type type;
    public final String path;

    public static ClasspathEntry fromString(String string) {
        int n2 = string.indexOf(61);
        if (n2 < 0) {
            throw new IllegalArgumentException("ClasspathEntry invalid: missing '='");
        }
        return new ClasspathEntry(Type.valueOf(string.substring(0, n2)), string.substring(n2 + 1));
    }

    public ClasspathEntry(Type type, String string) {
        if (type == null) {
            throw new NullPointerException("type is null");
        }
        if (string == null) {
            throw new NullPointerException("path is null");
        }
        this.type = type;
        this.path = string;
    }

    public String toString() {
        return this.type.name() + "=" + this.path;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof ClasspathEntry) {
            ClasspathEntry classpathEntry = (ClasspathEntry)object;
            if (classpathEntry.type == this.type && classpathEntry.path.equals(this.path)) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return this.path.hashCode() ^ 7 * (1 + this.type.ordinal());
    }

    public static enum Type {
        SOURCE_DIRECTORY,
        PROJECT_DIRECTORY,
        PROJECT_LIBRARY,
        EXTERNAL_LIBRARY,
        EXTERNAL_DIRECTORY,
        PROJECT,
        CONTAINER;

    }
}

