/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.barcode;

import com.google.zxing.Binarizer;
import com.google.zxing.BinaryBitmap;
import com.google.zxing.DecodeHintType;
import com.google.zxing.LuminanceSource;
import com.google.zxing.MultiFormatReader;
import com.google.zxing.Result;
import com.google.zxing.client.j2se.BufferedImageLuminanceSource;
import com.google.zxing.common.HybridBinarizer;
import com.iizix.NotFoundException;
import com.iizix.barcode.BarcodeData;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import javax.imageio.ImageIO;

public class BarcodeReader {
    public static BarcodeData readBarcode(String string) throws IOException, NotFoundException {
        return BarcodeReader.readBarcode(new File(string));
    }

    public static BarcodeData readBarcode(File file) throws IOException, NotFoundException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            return BarcodeReader.readBarcode(fileInputStream);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static BarcodeData readBarcode(InputStream inputStream) throws IOException, NotFoundException {
        BufferedImage bufferedImage = ImageIO.read(inputStream);
        if (bufferedImage == null) {
            throw new IOException("Failed reading image");
        }
        return BarcodeReader.readBarcode(bufferedImage);
    }

    public static BarcodeData readBarcode(BufferedImage bufferedImage) throws NotFoundException {
        HashMap<DecodeHintType, Boolean> hashMap = new HashMap<DecodeHintType, Boolean>();
        hashMap.put(DecodeHintType.TRY_HARDER, Boolean.TRUE);
        BinaryBitmap binaryBitmap = new BinaryBitmap((Binarizer)new HybridBinarizer((LuminanceSource)new BufferedImageLuminanceSource(bufferedImage)));
        try {
            Result result = new MultiFormatReader().decode(binaryBitmap, hashMap);
            return new BarcodeData(result.getBarcodeFormat(), result.getText(), result.getTimestamp());
        }
        catch (com.google.zxing.NotFoundException notFoundException) {
            throw new NotFoundException(notFoundException.getMessage(), (Throwable)notFoundException);
        }
    }
}

