/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.run.common;

import com.iizix.ILog;
import com.iizix.IPrintAdapter;
import com.iizix.IPropProgressMonitor;
import com.iizix.PropProgressMonitor;
import com.iizix.SystemConfig;
import com.iizix.Utilities;
import com.iizix.run.RuntimeBuilderSettings;
import com.iizix.run.common.BuildRC;
import com.iizix.run.common.BuildReply;
import com.iizix.run.common.CommonBuilder;
import com.iizix.run.common.CommonJobs;
import com.iizix.run.common.ICommonJobCreator;
import com.iizix.run.common.a;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class BuildEnvironment {
    public static final boolean isWindows;
    public static final boolean isMac;
    public static final boolean isLinux;
    public static final boolean isARM64;
    public static final char sep;
    public static final char pathSep;
    public static final String lineSep;
    public static final String EXE_EXT;
    public static final String BAT_EXT;
    public static final String CMD_EXT;
    private static final String i;
    private static final String j;
    static String a;
    static String b;
    private static String k;
    private static String l;
    private static String m;
    private static String n;
    private static String o;
    private static String p;
    static final Set<PosixFilePermission> a;
    public static final String TARGET_IOS_VERSION = "15.0";
    private static final String[] a;
    private static final String[] b;
    final File a;
    File b;
    File c;
    String c;
    File d;
    File e;
    String d;
    final File f;
    final File g;
    final File h;
    private final File k;
    String e;
    String f;
    String g;
    File i;
    String h;
    File j;
    private final ICommonJobCreator a;
    public final File output;
    private final File l;
    public final File homeDir;
    private final ArrayList<File> a;
    private final LinkedHashMap<String, String> a;
    public final File tempDir;
    private Map<String, String> a = new LinkedHashMap();

    static {
        String[] stringArray;
        String string;
        a = PosixFilePermissions.fromString("rwxr-x---");
        boolean bl = false;
        boolean bl2 = false;
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = "node";
        String string6 = "npm";
        sep = File.separatorChar;
        pathSep = File.pathSeparatorChar;
        isWindows = sep == '\\';
        String string7 = lineSep = isWindows ? "\r\n" : "\n";
        if (isWindows) {
            string2 = ".exe";
            string3 = ".bat";
            string4 = ".cmd";
            string5 = "node.exe";
            string6 = "npm.cmd";
        } else {
            string = System.getProperty("os.name").toLowerCase();
            bl = string.startsWith("mac");
            bl2 = !bl;
        }
        isMac = bl;
        isLinux = bl2;
        string = System.getProperty("os.arch", "").toLowerCase();
        isARM64 = string.equals("arm64") || string.equals("aarch64");
        EXE_EXT = string2;
        BAT_EXT = string3;
        CMD_EXT = string4;
        i = string5;
        j = string6;
        if (isMac) {
            String[] stringArray2 = new String[5];
            stringArray2[0] = "cordova-custom-config";
            stringArray2[1] = "ios-deploy";
            stringArray2[2] = "cordova@12.0.0";
            stringArray2[3] = "cordova-common@6.0.0";
            stringArray = stringArray2;
            stringArray2[4] = "cordova-fetch@5.0.0";
        } else {
            String[] stringArray3 = new String[5];
            stringArray3[0] = "cordova-custom-config";
            stringArray3[1] = "cordova@12.0.0";
            stringArray3[2] = "cordova-common@6.0.0";
            stringArray3[3] = "cordova-fetch@5.0.0";
            stringArray = stringArray3;
            stringArray3[4] = "loud-rejection";
        }
        a = stringArray;
        b = new String[]{"SystemRoot", "SystemDrive", "windir", "ComSpec", "OS", "COMPUTERNAME", "ALLUSERSPROFILE", "NUMBER_OF_PROCESSORS", "PROCESSOR_ARCHITECTURE", "PROCESSOR_IDENTIFIER", "PROCESSOR_LEVEL", "PROCESSOR_REVISION", "CommonProgramFiles", "CommonProgramFiles(x86)", "CommonProgramW6432", "ProgramData", "ProgramFiles", "ProgramFiles(x86)", "ProgramW6432", "PROMPT", "PSModulePath"};
    }

    static List<String> a(String ... stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (isWindows) {
            arrayList.add("cmd.exe");
            arrayList.add("/c");
        }
        arrayList.add(k);
        arrayList.add("--no-telemetry");
        arrayList.add("--no-update-notifier");
        String[] stringArray2 = stringArray;
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray2[n2];
            arrayList.add(string);
            ++n2;
        }
        return arrayList;
    }

    private static void a() {
        if (p != null) {
            return;
        }
        Object object = System.getenv("PATH");
        File file = new File("/opt/homebrew/opt");
        if (!file.isDirectory() && !(file = new File("/usr/local/opt")).isDirectory()) {
            throw new RuntimeException("Cannot find homebrew directory: it's neither '/opt/homebrew/opt' (Apple Silicon) or '/usr/local/opt' (Intel)");
        }
        File file2 = file.getParentFile();
        l = new File(file2, "bin").getPath();
        m = new File(file2, "sbin").getPath();
        object = l + ":" + m + ":" + (String)object;
        if (!(file = new File(file, "ruby")).isDirectory()) {
            throw new RuntimeException("Ruby not installed: cannot find directory \"" + String.valueOf(file) + "\"");
        }
        n = file.getPath();
        o = new File(file, "bin").getPath();
        object = o + ":" + n + ":" + (String)object;
        file = new File(n, "lib");
        if (!file.isDirectory()) {
            throw new RuntimeException("Cannot find ruby's 'lib' directory: \"" + String.valueOf(file) + "\"");
        }
        file = new File(n, "include");
        if (!file.isDirectory()) {
            throw new RuntimeException("Cannot find ruby's 'include' directory: \"" + String.valueOf(file) + "\"");
        }
        String string = o + "/gem environment gemdir";
        try {
            String string2;
            int n;
            byte[] byArray;
            InputStream inputStream;
            ProcessBuilder processBuilder = new ProcessBuilder(string.split(" ")).redirectErrorStream(true);
            processBuilder.environment().put("PATH", (String)object);
            Process process = processBuilder.start();
            Throwable throwable = null;
            Object var7_13 = null;
            try {
                inputStream = process.getInputStream();
                try {
                    process.waitFor();
                    byArray = new byte[256];
                    n = inputStream.read(byArray);
                    string2 = new String(byArray, 0, n).trim();
                    if (string2.isEmpty()) {
                        throw new RuntimeException("Found gem's environment directory empty!");
                    }
                    file = new File(string2, "bin");
                    if (!file.isDirectory()) {
                        throw new RuntimeException("Found gem's environment directory \"" + string2 + "\", but the 'bin' subdirectory is not found: \"" + String.valueOf(file) + "\"");
                    }
                    p = file.getPath();
                    object = p + ":" + (String)object;
                    ILog.WARNING(BuildEnvironment.class, (String)("Gem's environment binary directory = " + p));
                }
                finally {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            string = o + "/ruby -v";
            processBuilder = new ProcessBuilder(string.split(" ")).redirectErrorStream(true);
            processBuilder.environment().put("PATH", (String)object);
            process = processBuilder.start();
            throwable = null;
            var7_13 = null;
            try {
                inputStream = process.getInputStream();
                try {
                    process.waitFor();
                    byArray = new byte[256];
                    n = inputStream.read(byArray);
                    string2 = new String(byArray, 0, n).trim();
                    if (string2.isEmpty()) {
                        throw new RuntimeException("Found Ruby's version empty!");
                    }
                    ILog.WARNING(BuildEnvironment.class, (String)("Ruby version = " + string2));
                }
                finally {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                } else if (throwable != throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
            string = o + "/gem -v";
            processBuilder = new ProcessBuilder(string.split(" ")).redirectErrorStream(true);
            processBuilder.environment().put("PATH", (String)object);
            process = processBuilder.start();
            throwable = null;
            var7_13 = null;
            try {
                inputStream = process.getInputStream();
                try {
                    process.waitFor();
                    byArray = new byte[256];
                    n = inputStream.read(byArray);
                    string2 = new String(byArray, 0, n).trim();
                    if (string2.isEmpty()) {
                        throw new RuntimeException("Found gem's version empty!");
                    }
                    ILog.WARNING(BuildEnvironment.class, (String)("Gem version = " + string2));
                }
                finally {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
            string = p + "/pod --version";
            processBuilder = new ProcessBuilder(string.split(" ")).redirectErrorStream(true);
            processBuilder.environment().put("PATH", (String)object);
            processBuilder.environment().put("LANG", "en_US.UTF-8");
            process = processBuilder.start();
            throwable = null;
            var7_13 = null;
            try {
                inputStream = process.getInputStream();
                try {
                    process.waitFor();
                    byArray = new byte[1024];
                    n = inputStream.read(byArray);
                    string2 = new String(byArray, 0, n).trim();
                    if (string2.isEmpty()) {
                        throw new RuntimeException("Found pod's version empty!");
                    }
                    ILog.WARNING(BuildEnvironment.class, (String)("Pod (CocoaPods) version = " + string2));
                }
                finally {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
            }
            catch (Throwable throwable5) {
                if (throwable == null) {
                    throwable = throwable5;
                } else if (throwable != throwable5) {
                    throwable.addSuppressed(throwable5);
                }
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Throwable throwable) {
            throw new RuntimeException("Failed executing command: \"" + string + "\"\nPATH = " + (String)object);
        }
    }

    public static String getVersionFromCommand(String string) {
        string = string.trim();
        int n;
        while ((n = string.indexOf(10)) >= 0) {
            char c2;
            String string2 = string.substring(0, n).trim();
            if (string2.startsWith("v")) {
                string2 = string2.substring(1);
            }
            if (!string2.isEmpty() && (c2 = string2.charAt(0)) >= '1' && c2 <= '9') {
                return string2;
            }
            string = string.substring(n + 1).trim();
        }
        return (string = string.trim()).startsWith("v") ? string.substring(1).trim() : string;
    }

    public BuildEnvironment(File file, boolean bl, boolean bl2, ICommonJobCreator iCommonJobCreator, IPrintAdapter iPrintAdapter) throws IOException {
        Object object;
        if (file == null) {
            object = isWindows ? "/iiziBuildInstall" : System.getProperty("user.home") + "/iiziBuildInstall";
            file = new File((String)object);
        }
        this.output = file;
        this.a = iCommonJobCreator;
        file = file.getCanonicalFile();
        try {
            if (!file.isDirectory()) {
                iPrintAdapter.println("Creating build root directory " + String.valueOf(file));
                Files.createDirectories(file.toPath(), new FileAttribute[0]);
            }
            this.a = new File(file, isWindows ? "windows" : (isMac ? "mac" : "linux"));
            if (!this.a.isDirectory()) {
                iPrintAdapter.println("Creating OS directory " + String.valueOf(this.a));
                Files.createDirectory(this.a.toPath(), new FileAttribute[0]);
            }
            this.tempDir = new File(file, "temp");
            if (!this.tempDir.isDirectory()) {
                iPrintAdapter.println("Creating temporary directory " + String.valueOf(this.tempDir));
                Files.createDirectory(this.tempDir.toPath(), new FileAttribute[0]);
            }
            if (!((File)(object = new File(file, "home"))).isDirectory()) {
                iPrintAdapter.println("Creating home directory for building " + String.valueOf(object));
                Files.createDirectory(((File)object).toPath(), new FileAttribute[0]);
            }
            if (isWindows && !((File)(object = new File((File)object, "appdata"))).isDirectory()) {
                iPrintAdapter.println("Creating Windows application data directory " + String.valueOf(object));
                Files.createDirectory(((File)object).toPath(), new FileAttribute[0]);
            }
            this.l = object;
            this.homeDir = object;
            this.f = new File(this.a, "node").getCanonicalFile();
            if (!this.f.isDirectory()) {
                iPrintAdapter.println("Creating Node.js directory " + String.valueOf(this.f));
                Files.createDirectory(this.f.toPath(), new FileAttribute[0]);
            }
            File file2 = this.g = isWindows ? this.f : new File(this.f, "bin").getCanonicalFile();
            if (!this.g.isDirectory()) {
                iPrintAdapter.println("Creating Node binary directory " + String.valueOf(this.g));
                Files.createDirectories(this.g.toPath(), new FileAttribute[0]);
            }
            this.h = (isWindows ? new File(this.g, "node_modules") : new File(this.f, "lib/node_modules")).getCanonicalFile();
            if (!this.h.isDirectory()) {
                iPrintAdapter.println("Creating Node modules directory " + String.valueOf(this.h));
                Files.createDirectories(this.h.toPath(), new FileAttribute[0]);
            }
            this.k = new File(file, "npm-cache");
            if (!this.k.isDirectory()) {
                iPrintAdapter.println("Creating NPM cache directory " + String.valueOf(this.k));
                Files.createDirectory(this.k.toPath(), new FileAttribute[0]);
            }
            if (bl) {
                this.i = new File(file, "common" + sep + "gradle");
                if (!this.i.isDirectory()) {
                    iPrintAdapter.println("Creating Gradle directory " + String.valueOf(this.i));
                    Files.createDirectories(this.i.toPath(), new FileAttribute[0]);
                }
                this.j = new File(this.a, "android" + sep + "SDK");
                if (!this.j.isDirectory()) {
                    iPrintAdapter.println("Creating Android SDK directory " + String.valueOf(this.j));
                    Files.createDirectories(this.j.toPath(), new FileAttribute[0]);
                }
            }
        }
        catch (InvalidPathException invalidPathException) {
            throw new IOException("Invalid path", invalidPathException);
        }
    }

    public File getOutputDirectory() {
        return this.output;
    }

    /*
     * WARNING - void declaration
     */
    public BuildReply getExternalProcessEnvironment(Map<String, String> map, boolean bl) {
        if (this.a == null) {
            Object object4;
            int n;
            Object object22;
            String string = this.homeDir.getPath();
            ((HashMap)((Object)this.a)).put("HOME", string);
            if (isWindows) {
                if (string.length() > 3 && string.charAt(1) == ':' && string.charAt(2) == '\\') {
                    ((HashMap)((Object)this.a)).put("HOMEDRIVE", string.substring(0, 2));
                    ((HashMap)((Object)this.a)).put("HOMEPATH", string.substring(2));
                }
                ((HashMap)((Object)this.a)).put("APPDATA", this.l.getPath());
                ((HashMap)((Object)this.a)).put("USERPROFILE", string);
            }
            Map<String, String> map2 = System.getenv();
            if (isWindows) {
                void var5_7;
                String object42 = map2.get("WINDIR");
                if (object42 == null) {
                    for (String string2 : map2.keySet()) {
                        if (!string2.equalsIgnoreCase("WINDIR")) continue;
                        String string3 = map2.get(string2);
                        break;
                    }
                }
                if (var5_7 == null) {
                    return new BuildReply(BuildRC.EnvironmentError, "The Windows system environment variable 'WINDIR' was not found");
                }
                File file = new File((String)var5_7);
                if (!file.isDirectory()) {
                    return new BuildReply(BuildRC.EnvironmentError, "The Windows system environment variable 'windir' was not found: " + file.getAbsolutePath());
                }
                object22 = new File(file, "System32");
                if (!((File)object22).isDirectory()) {
                    return new BuildReply(BuildRC.EnvironmentError, "The Windows System32 directory was not found: " + ((File)object22).getAbsolutePath());
                }
                ((ArrayList)((Object)this.a)).add(Utilities.getCanonicalFile((File)file));
                ((ArrayList)((Object)this.a)).add(Utilities.getCanonicalFile((File)object22));
                ((ArrayList)((Object)this.a)).add(Utilities.getCanonicalFile((File)new File((File)object22, "wbem")));
                ((HashMap)((Object)this.a)).put("WINDIR", var5_7);
                ((HashMap)((Object)this.a)).put("PATHEXT", ".COM;.EXE;.BAT;.CMD;.VBS;.VBE;.JS;.JSE;.WSF;.WSH;.MSC");
                String[] stringArray = b;
                int n2 = b.length;
                n = 0;
                while (n < n2) {
                    Object object3 = object4 = stringArray[n];
                    String string4 = map2.get(object4);
                    if (string4 == null) {
                        for (String string5 : map2.keySet()) {
                            if (!string5.equalsIgnoreCase((String)object4)) continue;
                            object3 = string5;
                            string4 = map2.get(string5);
                            break;
                        }
                    }
                    if (string4 != null) {
                        ((HashMap)((Object)this.a)).put(object3, string4);
                    }
                    ++n;
                }
            } else {
                for (Map.Entry<String, String> entry : map2.entrySet()) {
                    ((HashMap)((Object)this.a)).putIfAbsent(entry.getKey().toUpperCase(), entry.getValue());
                }
            }
            ((HashMap)((Object)this.a)).put("NODE_HOME", this.f.getPath());
            ((HashMap)((Object)this.a)).put("NPM_CONFIG_CACHE", this.k.getPath());
            this.a(this.g, this.h);
            if (!isWindows) {
                String string6;
                LinkedHashSet<Object> linkedHashSet = new LinkedHashSet<Object>();
                if (isMac) {
                    BuildEnvironment.a();
                    linkedHashSet.add(p);
                    linkedHashSet.add(o);
                    linkedHashSet.add(BuildEnvironment.n);
                    linkedHashSet.add(l);
                    linkedHashSet.add(m);
                    ((HashMap)((Object)this.a)).put("LDFLAGS", "-L" + BuildEnvironment.n + "/lib");
                    ((HashMap)((Object)this.a)).put("CPPFLAGS", "-I" + BuildEnvironment.n + "/include");
                    ((HashMap)((Object)this.a)).put("LC_CTYPE", "UTF-8");
                    ((HashMap)((Object)this.a)).put("LANG", "en-US.UTF-8");
                    try {
                        File file = new File("/usr/bin");
                        this.a(file);
                        object22 = "<unknown>";
                        object4 = new StringBuilder();
                        n = new CommonJobs(IPropProgressMonitor.NULL, null, true).exec(true, file, (Map<String, String>)((Object)this.a), (StringBuilder)object4, "/usr/bin/xcode-select", "-print-path");
                        object22 = ((StringBuilder)object4).toString().trim();
                        if (n != 0) {
                            return new BuildReply(BuildRC.XCODE_Path, "Failed getting the path to 'xcodebuild' using '/usr/bin/xcode-select -print-path': RC = " + n + ", xcode-select path: " + (String)object22);
                        }
                        File file2 = new File((String)object22);
                        if (!file2.isDirectory()) {
                            return new BuildReply(BuildRC.XCODE_Path, "Failed getting the path to 'xcodebuild' using '/usr/bin/xcode-select -print-path': RC = " + n + ", xcode-select path: '" + String.valueOf(file2) + "' is not a directory");
                        }
                        linkedHashSet.add(object22);
                    }
                    catch (Exception exception) {
                        return new BuildReply(BuildRC.XCODE_Path, "Failed getting the path to 'xcodebuild' using '/usr/bin/xcode-select -print-path': exception: " + String.valueOf(exception));
                    }
                }
                linkedHashSet.add("/bin");
                linkedHashSet.add("/sbin");
                String string7 = System.getenv("PATH");
                if (string7 != null) {
                    linkedHashSet.addAll(Arrays.asList(string7.split(":")));
                }
                if ((string6 = (String)((LinkedHashMap)((Object)this.a)).get("PATH")) != null) {
                    linkedHashSet.addAll(Arrays.asList(string6.split(":")));
                }
                object22 = new LinkedHashSet();
                for (Object object4 : linkedHashSet) {
                    File file = Utilities.getCanonicalFile((String)object4);
                    if (!file.isDirectory()) continue;
                    ((HashSet)object22).add(file.getPath());
                }
                String string8 = object22.stream().collect(Collectors.joining(":"));
                ((HashMap)((Object)this.a)).put("PATH", string8);
            }
            Iterator iterator = ((LinkedHashMap)((Object)this.a)).keySet().iterator();
            while (iterator.hasNext()) {
                String string9 = (String)iterator.next();
                if (string9.equals("PATH") || !string9.equalsIgnoreCase("PATH")) continue;
                iterator.remove();
            }
            ArrayList arrayList = new ArrayList(((LinkedHashMap)((Object)this.a)).keySet());
            arrayList.sort(Utilities.COLLATOR);
            StringBuilder stringBuilder = new StringBuilder("Environment:");
            for (Object object22 : arrayList) {
                stringBuilder.append("\n - ").append((String)object22).append(" = ").append((String)((LinkedHashMap)((Object)this.a)).get(object22));
            }
            ILog.INFO(CommonBuilder.class, (String)stringBuilder.toString());
            this.a = new HashMap(this.a);
        }
        if (map != null) {
            map.putAll((Map<String, String>)((Object)this.a));
        }
        return BuildReply.OK;
    }

    private void a(File ... fileArray) {
        Object object;
        int n = 0;
        File[] fileArray2 = fileArray;
        int n2 = fileArray.length;
        int n3 = 0;
        while (n3 < n2) {
            block3: {
                object = fileArray2[n3];
                object = Utilities.getCanonicalFile((File)object);
                Iterator iterator = ((ArrayList)((Object)this.a)).iterator();
                while (iterator.hasNext()) {
                    File file = (File)iterator.next();
                    if (!file.equals(object)) {
                        continue;
                    }
                    break block3;
                }
                ((ArrayList)((Object)this.a)).add(n++, object);
            }
            ++n3;
        }
        object = this.a.stream().map(File::getPath).collect(Collectors.joining(File.pathSeparator));
        ((HashMap)((Object)this.a)).put("PATH", object);
    }

    public BuildReply getJavaEnvironment(RuntimeBuilderSettings runtimeBuilderSettings, ICommonJobCreator iCommonJobCreator, IPropProgressMonitor iPropProgressMonitor, boolean bl) throws IOException {
        Comparable<StringBuilder> comparable;
        int n;
        block22: {
            Object object;
            Object object2;
            if (isWindows && ((File)(object2 = new File("C:/Windows/System32/WindowsPowerShell/v1.0").getAbsoluteFile())).isDirectory()) {
                this.a(new File[]{object2});
            }
            if (runtimeBuilderSettings != null && runtimeBuilderSettings.jdk_path != null) {
                object2 = runtimeBuilderSettings.jdk_path;
            } else {
                int n2 = SystemConfig.javaVer;
                if (n2 <= 21) {
                    object2 = System.getProperty("java.home");
                } else {
                    object = isMac ? "/Library/Java/JavaVirtualMachines/temurin-21.jdk/Contents/Home" : "/java/x64/jdk21";
                    object2 = new File((String)object).getCanonicalPath();
                    ILog.WARNING(this.getClass(), (String)("No Java SDK specified in environment variable JAVA_HOME, and current version " + n2 + " is not supported, using Java JDK in path \"" + (String)object2 + "\" instead"));
                }
            }
            this.b = new File((String)object2).getCanonicalFile();
            File file = new File(this.b, "bin");
            if (!file.isDirectory()) {
                return new BuildReply(BuildRC.Java_NotJDK, "Java found in \"" + file.getPath() + "\" is not a JRE, not Java Development Kit (JDK)");
            }
            object = new File(file, "java" + EXE_EXT);
            if (!((File)object).canExecute()) {
                return new BuildReply(BuildRC.Java_NotFound, "Java program \"" + ((File)object).getPath() + "\" is not executable");
            }
            this.c = file.getCanonicalFile();
            this.c = ((File)object).getCanonicalPath();
            ((HashMap)((Object)this.a)).put("JAVA_HOME", this.b.getPath());
            this.a(this.b, this.c);
            n = 0;
            try {
                block24: {
                    String string;
                    block23: {
                        int n3;
                        comparable = new StringBuilder();
                        int n4 = new CommonJobs(IPropProgressMonitor.NULL, null, bl).exec(false, this.b, (Map<String, String>)((Object)this.a), (StringBuilder)comparable, this.c, "-version");
                        if (n4 != 0) {
                            return new BuildReply(BuildRC.JDK_VersionError, "Failed getting Java version, return code " + n4);
                        }
                        string = ((StringBuilder)comparable).toString();
                        int n5 = string.indexOf(34, (n3 = string.indexOf(34)) + 1);
                        if (n5 < 0) {
                            return new BuildReply(BuildRC.JDK_VersionError, "Failed parsing Java version, quoted delimited missing: " + string);
                        }
                        this.d = string.substring(n3 + 1, n5);
                        if (this.d.startsWith("1.")) {
                            try {
                                int n6 = this.d.indexOf(46, 2);
                                n = Integer.parseInt(n6 > 0 ? string.substring(2, n6) : string.substring(2));
                            }
                            catch (Exception exception) {
                                return new BuildReply(BuildRC.JDK_VersionError, "failed parsing Java version, expected version to as '1.nn[.mm]': " + string);
                            }
                            if (n != 8) {
                                return new BuildReply(BuildRC.JDK_VersionError, "Only Java version 1.8 is supported for Java versions 1.x: " + this.d);
                            }
                            break block22;
                        }
                        try {
                            int n7 = this.d.indexOf(46);
                            if (n7 <= 0) break block23;
                            n = Integer.parseInt(this.d.substring(0, n7));
                            break block24;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    return new BuildReply(BuildRC.JDK_VersionError, "failed parsing Java version, expected version to start with 'nn.': " + string);
                }
                if (n > 21 || n < 11) {
                    return new BuildReply(BuildRC.JDK_VersionError, "Java version " + n + " is not supported for Android Gradle building, allowed Java version are 11 to 21");
                }
            }
            catch (Exception exception) {
                return new BuildReply(BuildRC.JDK_VersionError, "Failed to execute Java found in \"" + this.c.getPath() + "\": " + exception.getMessage());
            }
        }
        comparable = Utilities.getCanonicalFile((File)new File(this.b, "bin"));
        if (!((File)comparable).isDirectory()) {
            return new BuildReply(BuildRC.Java_NotJDK, "Java tools directory \"" + ((File)comparable).getPath() + "\" is not found");
        }
        this.d = new File((File)comparable, "jar" + EXE_EXT);
        if (!this.d.canExecute()) {
            return new BuildReply(BuildRC.Java_NotJDK, "Java found in \"" + this.c.getPath() + "\" is not a Java Development Kit (JDK): expected to find executable \"" + this.d.getPath() + "\"");
        }
        this.e = new File((File)comparable, "keytool" + EXE_EXT);
        if (!this.e.canExecute()) {
            return new BuildReply(BuildRC.Java_NotJDK, "Java found in \"" + this.c.getPath() + "\" is not a Java Development Kit (JDK): expected to find executable \"" + this.e.getPath() + "\"");
        }
        if (CommonBuilder.DEBUG) {
            System.out.println("Using Java version " + n + " (" + this.d + ")");
        }
        return BuildReply.OK;
    }

    public BuildReply initialize(boolean bl) throws IOException {
        String string = this.tempDir.getPath();
        ((HashMap)((Object)this.a)).put("TEMP", string);
        ((HashMap)((Object)this.a)).put("TMPDIR", string);
        String string2 = this.h.getPath();
        ((HashMap)((Object)this.a)).put("NODE_PATH", string2);
        ((HashMap)((Object)this.a)).put("NPM_CONFIG_GLOBALCONFIG", string2);
        if (this.j != null && this.i != null) {
            String string3 = this.j.getPath();
            ((HashMap)((Object)this.a)).put("ANDROID_HOME", string3);
            ((HashMap)((Object)this.a)).put("ANDROID_SDK_ROOT", string3);
            ((HashMap)((Object)this.a)).put("ANDROID_AAPT_IGNORE", "!.svn:!.git:!.ds_store:!*.scc:.*:!CVS:!thumbs.db:!picasa.ini:!*~");
            String string4 = this.i.getPath();
            ((HashMap)((Object)this.a)).put("GRADLE_HOME", string4);
            ((HashMap)((Object)this.a)).put("GRADLE_USER_HOME", string4);
            ((HashMap)((Object)this.a)).put("GRADLE_OPTS", "-Dgradle.user.home=" + string4 + " -Dorg.gradle.daemon=false");
            this.a(new File(this.i, "bin"));
        }
        a = new File(this.g, i).getPath();
        b = new File(this.g, j).getAbsolutePath();
        k = new File(this.g, isWindows ? "cordova.cmd" : "cordova").getAbsolutePath();
        ILog.WARNING(this.getClass(), (String)("Using cordova from executable: " + k + ", node modules directory = " + String.valueOf(this.h)));
        this.a(this.g, this.h);
        if (this.i != null) {
            this.a(new File(this.i, "bin"));
        }
        if (this.j != null) {
            this.a(new File(this.j, "cmdline-tools" + sep + "latest"), new File(this.j, "cmdline-tools" + sep + "latest" + sep + "bin"), new File(this.j, "tools"), new File(this.j, "tools" + sep + "bin"), new File(this.j, "platform-tools"));
        }
        this.a = null;
        return this.getExternalProcessEnvironment(null, true);
    }

    private BuildReply a(IPropProgressMonitor iPropProgressMonitor, IPrintAdapter iPrintAdapter, boolean bl) {
        Comparable<File> comparable;
        Object object;
        CharSequence charSequence;
        try {
            charSequence = isWindows ? "https://nodejs.org/dist/v22.20.0/node-v22.20.0-win-x64.zip" : (isMac ? (isARM64 ? "https://nodejs.org/dist/v22.20.0/node-v22.20.0-darwin-arm64.tar.gz" : "https://nodejs.org/dist/v22.20.0/node-v22.20.0-darwin-x64.tar.gz") : (isARM64 ? "https://nodejs.org/dist/v22.20.0/node-v22.20.0-linux-arm64.tar.xz" : "https://nodejs.org/dist/v22.20.0/node-v22.20.0-linux-x64.tar.xz"));
            ILog.INFO(this.getClass(), (String)("Downloading Node.js from " + charSequence + " to " + String.valueOf(this.f)));
            this.a.createNewJob(iPropProgressMonitor, iPrintAdapter, false).downloadExtractArchive(this.d, this.tempDir, (String)charSequence, this.f);
            object = this.f.listFiles();
            if (object == null) {
                throw new IOException("Failed reading directory " + String.valueOf(this.f));
            }
            if (((File[])object).length != 1) {
                throw new IOException("The extracted Node.js directory was expected to contain a single subdirectory: " + String.valueOf(this.f));
            }
            comparable = object[0];
            if ((object = comparable.listFiles()) == null) {
                throw new IOException("Failed reading directory " + String.valueOf(comparable));
            }
            File[] fileArray = object;
            int n = ((File[])object).length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                Files.move(file.toPath(), new File(this.f, file.getName()).toPath(), StandardCopyOption.REPLACE_EXISTING);
                ++n2;
            }
            Files.delete(comparable.toPath());
        }
        catch (IOException | InterruptedException | InvalidPathException exception) {
            ILog.SEVERE(this.getClass(), (String)"Failed downloading and installing Node.js", (Throwable)exception);
            return new BuildReply(BuildRC.NodeJS_DownloadInstallError, "Failed downloading and installing Node.js: " + String.valueOf(exception));
        }
        try {
            charSequence = new StringBuilder();
            object = new StringBuilder();
            comparable = new StringBuilder();
            this.a.createNewJob(iPropProgressMonitor, iPrintAdapter, bl).execNPM(true, this.f, (Map<String, String>)((Object)this.a), (StringBuilder)charSequence, b, "root");
            this.a.createNewJob(iPropProgressMonitor, iPrintAdapter, bl).execNPM(true, this.f, (Map<String, String>)((Object)this.a), (StringBuilder)object, b, "config", "get", "prefix");
            this.a.createNewJob(iPropProgressMonitor, iPrintAdapter, bl).execNPM(true, this.f, (Map<String, String>)((Object)this.a), (StringBuilder)comparable, b, "config", "get", "cache");
            iPrintAdapter.println("Node and NPM setup:\n\nnpm root              = " + String.valueOf(charSequence) + "\nnpm config get prefix = " + String.valueOf(object) + "\nnpm config get cache  = " + String.valueOf(comparable) + "\n\nNODE_HOME             = " + (String)((LinkedHashMap)((Object)this.a)).get("NODE_HOME") + "\nNODE_PATH             = " + (String)((LinkedHashMap)((Object)this.a)).get("NODE_PATH") + "\nNPM_CONFIG_PREFIX     = " + (String)((LinkedHashMap)((Object)this.a)).get("NPM_CONFIG_PREFIX") + "\nNPM_CONFIG_USERCONFIG = " + (String)((LinkedHashMap)((Object)this.a)).get("NPM_CONFIG_USERCONFIG") + "\n\nPATH                  = " + (String)((LinkedHashMap)((Object)this.a)).get("PATH") + "\n\n");
        }
        catch (Throwable throwable) {
            throwable.printStackTrace(System.err);
            throw new RuntimeException("ERROR", throwable);
        }
        return BuildReply.OK;
    }

    private BuildReply b(IPropProgressMonitor iPropProgressMonitor, IPrintAdapter iPrintAdapter, boolean bl) {
        if (this.i == null) {
            return BuildReply.OK;
        }
        try {
            ILog.INFO(this.getClass(), (String)"Downloading Gradle from https://services.gradle.org/distributions/gradle-9.1.0-bin.zip");
            this.a.createNewJob(iPropProgressMonitor, iPrintAdapter, bl).downloadExtractArchive(this.d, this.tempDir, "https://services.gradle.org/distributions/gradle-9.1.0-bin.zip", this.i);
            File[] fileArray = this.i.listFiles();
            if (fileArray == null) {
                throw new IOException("Failed reading directory " + this.i.getPath());
            }
            if (fileArray.length != 1) {
                throw new IOException("The extracted Gradle directory was expected to contain a single subdirectory: " + this.i.getPath());
            }
            File file = fileArray[0];
            if ((fileArray = file.listFiles()) == null) {
                throw new IOException("Failed reading directory " + file.getPath());
            }
            File[] fileArray2 = fileArray;
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file2 = fileArray2[n2];
                Files.move(file2.toPath(), new File(this.i, file2.getName()).toPath(), StandardCopyOption.REPLACE_EXISTING);
                ++n2;
            }
            Files.delete(file.toPath());
        }
        catch (IOException | InterruptedException | InvalidPathException exception) {
            ILog.SEVERE(this.getClass(), (String)"Failed downloading and installing Gradle", (Throwable)exception);
            return new BuildReply(BuildRC.Gradle_DownloadInstallError, "Failed downloading and installing Gradle: " + String.valueOf(exception));
        }
        return BuildReply.OK;
    }

    /*
     * Unable to fully structure code
     */
    public BuildReply getVersions(IPropProgressMonitor var1_1, IPrintAdapter var2_2, boolean var3_3) {
        var4_4 = "Cannot check Node version";
        var5_5 = BuildRC.NodeJS_NotFound;
        var6_6 = new StringBuilder();
        try {
            block37: {
                if (!new File(BuildEnvironment.a).canExecute()) {
                    var7_7 = this.a(var1_1.newSubMonitor(1), var2_2, var3_3);
                    if (!var7_7.equals(BuildReply.OK)) {
                        var25_9 = var7_7;
                        return var25_9;
                    }
                } else {
                    var1_1.setWorked(1);
                }
                if (var3_3) {
                    ILog.INFO(CommonBuilder.class, (String)"Checking Node.js presence");
                }
                if (!(var7_7 = new File(this.g, BuildEnvironment.i).getCanonicalFile()).canExecute() && !(var8_13 = this.a(var1_1, var2_2, var3_3)).equals(BuildReply.OK)) {
                    var25_10 = var8_13;
                    return var25_10;
                }
                if (var3_3) {
                    ILog.INFO(CommonBuilder.class, (String)"Checking Node.js version");
                }
                if ((var8_14 = this.a.createNewJob(var1_1.newSubMonitor(1), var2_2, var3_3).exec(false, this.g, (Map<String, String>)this.a, var6_6, new String[]{BuildEnvironment.a, "--version"})) != 0) {
                    throw new Exception("return code = " + var8_14);
                }
                this.e = BuildEnvironment.getVersionFromCommand(var6_6.toString());
                if (!"22.20.0".equals(this.e)) {
                    throw new Exception("expected Node version 22.20.0 but got " + this.e);
                }
                if (var3_3) {
                    ILog.INFO(CommonBuilder.class, (String)"Checking NPM version");
                }
                var4_4 = "Cannot check NPM version";
                var5_5 = BuildRC.NPM_NotFound;
                var6_6.setLength(0);
                var8_14 = this.a.createNewJob(var1_1.newSubMonitor(1), var2_2, var3_3).execNPM(false, this.g, (Map<String, String>)this.a, var6_6, new String[]{BuildEnvironment.b, "--version"});
                if (var8_14 != 0) {
                    throw new Exception("return code = " + var8_14);
                }
                this.f = BuildEnvironment.getVersionFromCommand(var6_6.toString());
                if ("11.6.2".compareTo(this.f) > 0) {
                    ILog.WARNING(this.getClass(), (String)("Using NPM version " + this.f + " instead of ideally 11.6.2"));
                }
                if (this.i != null) break block37;
                var1_1.worked(1);
                ** GOTO lbl81
            }
            var9_15 = new File(this.i, "bin");
            var10_16 = "gradle" + BuildEnvironment.BAT_EXT;
            var11_18 = new File((File)var9_15, var10_16);
            if (!(var9_15.isDirectory() && var11_18.canExecute() || (var12_20 = this.b(var1_1, var2_2, var3_3)).equals(BuildReply.OK))) {
                var25_11 = var12_20;
                return var25_11;
            }
            try {
                if (var3_3) {
                    ILog.INFO(CommonBuilder.class, (String)"Checking Gradle version");
                }
                var4_4 = "Cannot check Gradle version";
                var5_5 = BuildRC.Gradle_NotFound;
                var6_6.setLength(0);
                var12_20 = this.a.createNewJob(var1_1.newSubMonitor(1), var2_2, var3_3);
                v0 = var8_14 = BuildEnvironment.isWindows != false ? var12_20.exec(false, this.i, (Map<String, String>)this.a, var6_6, new String[]{"cmd.exe", "/c", "bin\\gradle.bat", "-version"}) : var12_20.exec(false, this.i, (Map<String, String>)this.a, var6_6, new String[]{"bin/gradle", "-version"});
                if (var8_14 != 0) {
                    throw new Exception("return code = " + var8_14);
                }
                this.h = null;
                var16_21 = var6_6.toString().replace("\r\n", "\n").split("\n");
                var15_22 = var16_21.length;
                var14_23 = 0;
                while (var14_23 < var15_22) {
                    var13_24 = var16_21[var14_23];
                    if (var13_24.startsWith("Gradle ") && !(var17_25 = var13_24.substring(7).trim()).isEmpty() && (var18_26 = var17_25.charAt(0)) >= '0' && var18_26 <= '9') {
                        var19_27 = new StringBuilder();
                        var23_28 = var17_25.toCharArray();
                        var22_29 = var23_28.length;
                        var21_30 = 0;
                        while (var21_30 < var22_29) {
                            var20_31 = var23_28[var21_30];
                            if (var20_31 == '.' || var20_31 >= '0' && var20_31 <= '9') {
                                var19_27.append(var20_31);
                            }
                            ++var21_30;
                        }
                        this.h = var19_27.toString();
                        break;
                    }
                    ++var14_23;
                }
                if (this.h == null) {
                    throw new Exception("cannot find Gradle version: " + String.valueOf(var6_6));
                }
                if (!"9.1.0".equals(this.h)) {
                    throw new Exception("expected Gradle version 9.1.0 but got " + this.h);
                }
lbl81:
                // 3 sources

                if (var3_3) {
                    ILog.INFO(CommonBuilder.class, (String)"Checking for Cordova presence");
                }
                if (!new File(BuildEnvironment.k).isFile()) {
                    ILog.INFO(this.getClass(), (String)"Installing required Cordova modules for building");
                    ILog.WARNING(this.getClass(), (String)("Node executable = " + BuildEnvironment.a));
                    ILog.WARNING(this.getClass(), (String)("Path = " + (String)this.a.get("PATH")));
                    var12_20 = BuildEnvironment.a;
                    var11_19 = BuildEnvironment.a.length;
                    var10_17 = 0;
                    while (var10_17 < var11_19) {
                        var9_15 = var12_20[var10_17];
                        var13_24 = new String[]{BuildEnvironment.b, "install", "-g", var9_15};
                        if (var3_3) {
                            ILog.INFO(CommonBuilder.class, (String)("Installing NPM module " + (String)var9_15), (Object[])var13_24);
                        }
                        var4_4 = "Failed installing NPM module: " + (String)var9_15;
                        var5_5 = BuildRC.Cordova_InstallError;
                        var6_6.setLength(0);
                        var8_14 = this.a.createNewJob(var1_1.newSubMonitor(1), var2_2, var3_3).execNPM(false, this.g, (Map<String, String>)this.a, var6_6, (String[])var13_24);
                        if (var8_14 != 0) {
                            throw new Exception("return code = " + var8_14);
                        }
                        ++var10_17;
                    }
                }
                if (var3_3) {
                    ILog.INFO(CommonBuilder.class, (String)"Checking Cordova version");
                }
                var4_4 = "Cannot check Cordova version";
                var5_5 = BuildRC.Cordova_VersionError;
                var6_6.setLength(0);
                var8_14 = this.a.createNewJob(var1_1.newSubMonitor(1), var2_2, var3_3).exec(false, this.g, (Map<String, String>)this.a, var6_6, BuildEnvironment.a(new String[]{"--version"}));
                this.g = BuildEnvironment.getVersionFromCommand(var6_6.toString());
                if (this.g == null || !this.g.startsWith("12.0.0")) {
                    throw new Exception("expected Cordova version 12.0.0 but got " + this.g);
                }
                var4_4 = "Cannot turn off Cordova auto-save";
                var6_6.setLength(0);
                var8_14 = this.a.createNewJob(var1_1.newSubMonitor(1), var2_2, var3_3).exec(false, this.g, (Map<String, String>)this.a, var6_6, BuildEnvironment.a(new String[]{"config", "set", "autosave", "false"}));
                if (var8_14 != 0) {
                    throw new Exception("return code = " + var8_14);
                }
            }
            catch (Exception var7_8) {
                var8_13 = var6_6.length() > 0 ? "\n" + String.valueOf(var6_6) : "";
                var25_12 = new BuildReply(var5_5, "Failed checking program version, " + (String)var4_4 + ": " + var7_8.getMessage() + (String)var8_13);
                return var25_12;
            }
        }
        finally {
            var1_1.done();
        }
        ILog.INFO(CommonBuilder.class, (String)("Build program versions: Java = " + this.d + ", Node = " + this.e + ", NPM = " + this.f + ", Gradle = " + this.h + ", Cordova = " + this.g));
        return BuildReply.OK;
    }

    public BuildReply checkAndroidEnvironment(IPropProgressMonitor iPropProgressMonitor, IPrintAdapter iPrintAdapter, boolean bl) {
        block59: {
            boolean bl2 = CommonBuilder.DEBUG;
            if (bl2) {
                bl = true;
            }
            String string = null;
            ArrayList<String> arrayList = new ArrayList<String>();
            if (isWindows) {
                arrayList.add("cmd.exe");
                arrayList.add("/c");
            }
            String string2 = new File(this.j, "cmdline-tools" + sep + "latest" + sep + "bin" + sep + "sdkmanager" + BAT_EXT).getPath();
            arrayList.add(string2);
            StringBuilder stringBuilder = new StringBuilder();
            Object object = "Checking Android environment";
            try {
                try {
                    File file;
                    ArrayList<String> arrayList2;
                    File file2 = new File(this.homeDir, ".android");
                    object = "Failed creating Android configuration directory " + file2.getPath();
                    if (!file2.exists()) {
                        Files.createDirectories(file2.toPath(), new FileAttribute[0]);
                    }
                    File file3 = new File(file2, "repositories.cfg");
                    object = "Failed creating Android repository configuration  " + file3.getPath();
                    if (!file3.isFile()) {
                        Files.createFile(file3.toPath(), new FileAttribute[0]);
                    }
                    file2 = new File((String)(isWindows ? System.getenv("USERPROFILE") + "\\.android" : "~/.android"));
                    object = "Failed creating Android configuration directory " + file2.getPath();
                    if (!file2.exists()) {
                        Files.createDirectories(file2.toPath(), new FileAttribute[0]);
                    }
                    file3 = new File(file2, "repositories.cfg");
                    object = "Failed creating Android repository configuration  " + file3.getPath();
                    if (!file3.isFile()) {
                        Files.createFile(file3.toPath(), new FileAttribute[0]);
                    }
                    object = "Checking Android environment";
                    File file4 = new File(this.j, "cmdline-tools" + sep + "latest");
                    if (!file4.isDirectory()) {
                        arrayList2 = isWindows ? "https://dl.google.com/android/repository/commandlinetools-win-13114758_latest.zip" : (isMac ? "https://dl.google.com/android/repository/commandlinetools-mac-13114758_latest.zip" : "https://dl.google.com/android/repository/commandlinetools-linux-13114758_latest.zip");
                        object = "Failed downloading and extracting Android command-line tools from " + (String)((Object)arrayList2);
                        ILog.INFO(this.getClass(), (String)("Downloading and extracting Android command-line tools from " + (String)((Object)arrayList2)));
                        File file5 = new File(this.j, "cmdline-tools");
                        this.a.createNewJob(iPropProgressMonitor.newSubMonitor(1), iPrintAdapter, bl).downloadExtractArchive(this.d, this.tempDir, (String)((Object)arrayList2), file5);
                        file = new File(file5, "cmdline-tools");
                        ILog.INFO(this.getClass(), (String)("Moving Android command-line tools from \"" + String.valueOf(file) + "\" to \"" + String.valueOf(file4) + "\""));
                        Files.move(file.toPath(), file4.toPath(), new CopyOption[0]);
                    } else {
                        iPropProgressMonitor.worked(1);
                    }
                    ILog.INFO(this.getClass(), (String)"Updating Android command-line SDK Manager");
                    object = "Failed updating Android command-line SDK Manager";
                    arrayList2 = new ArrayList(arrayList);
                    arrayList2.add("--update");
                    int n = this.a.createNewJob(iPropProgressMonitor.newSubMonitor(1), iPrintAdapter, bl).exec(bl2, this.j, (Map<String, String>)((Object)this.a), stringBuilder, (List<String>)arrayList2);
                    if (n != 0) {
                        throw new Exception("return code = " + n);
                    }
                    if (!(new File(this.j, "build-tools").isDirectory() && new File(this.j, "extras").isDirectory() && new File(this.j, "licenses").isDirectory() && new File(this.j, "patcher").isDirectory() && new File(this.j, "platform-tools").isDirectory() && new File(this.j, "platforms").isDirectory())) {
                        file = null;
                        File file6 = null;
                        try {
                            PrintWriter printWriter;
                            ILog.INFO(this.getClass(), (String)"Downloading Android command-line SDK packages (this is a lengthy process)");
                            object = "Failed SDK Manager license batch script file";
                            file = new File(this.tempDir, "yes-answer-64.txt");
                            Throwable throwable = null;
                            Object var18_24 = null;
                            try {
                                printWriter = new PrintWriter(new FileWriter(file));
                                try {
                                    int n2 = 64;
                                    while (--n2 >= 0) {
                                        printWriter.println("Yes");
                                    }
                                }
                                finally {
                                    if (printWriter != null) {
                                        printWriter.close();
                                    }
                                }
                            }
                            catch (Throwable throwable2) {
                                if (throwable == null) {
                                    throwable = throwable2;
                                } else if (throwable != throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                throw throwable;
                            }
                            file6 = File.createTempFile("iizi-android-sdk", BAT_EXT, this.tempDir);
                            throwable = null;
                            var18_24 = null;
                            try {
                                printWriter = new PrintWriter(new FileWriter(file6));
                                try {
                                    if (!isWindows) {
                                        printWriter.println("#!/bin/sh");
                                    }
                                    printWriter.println(string2 + " \"platform-tools\" \"platforms;android-24\" \"platforms;android-35\" \"build-tools;35.0.0\" \"extras;google;m2repository\" \"extras;android;m2repository\" < " + file.getPath());
                                }
                                finally {
                                    if (printWriter != null) {
                                        printWriter.close();
                                    }
                                }
                            }
                            catch (Throwable throwable3) {
                                if (throwable == null) {
                                    throwable = throwable3;
                                } else if (throwable != throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                throw throwable;
                            }
                            if (!isWindows) {
                                Files.setPosixFilePermissions(file6.toPath(), (Set<PosixFilePermission>)((Object)a));
                            }
                            object = "Failed downloading Android SDK packages";
                            stringBuilder.setLength(0);
                            arrayList2 = new ArrayList<String>();
                            if (isWindows) {
                                arrayList2.add("cmd.exe");
                                arrayList2.add("/c");
                            }
                            arrayList2.add(file6.getPath());
                            n = this.a.createNewJob(iPropProgressMonitor.newSubMonitor(1), iPrintAdapter, bl).exec(bl2, this.j, (Map<String, String>)((Object)this.a), stringBuilder, arrayList2);
                            if (n != 0) {
                                throw new Exception("return code = " + n);
                            }
                            if (stringBuilder.length() > 0) {
                                stringBuilder.append('\n');
                            }
                            string = stringBuilder.toString();
                            System.err.println("\n\n#########################\n   LICENSES  1\n#########################\n");
                            System.err.println(string);
                            System.err.println("\n#########################\n\n\n");
                            ILog.INFO(this.getClass(), (String)"Retrieving Android licenses");
                            throwable = null;
                            var18_24 = null;
                            try {
                                printWriter = new PrintWriter(new FileWriter(file6));
                                try {
                                    if (!isWindows) {
                                        printWriter.println("#!/bin/sh");
                                    }
                                    printWriter.println(string2 + " --licenses < " + file.getPath());
                                }
                                finally {
                                    if (printWriter != null) {
                                        printWriter.close();
                                    }
                                }
                            }
                            catch (Throwable throwable4) {
                                if (throwable == null) {
                                    throwable = throwable4;
                                } else if (throwable != throwable4) {
                                    throwable.addSuppressed(throwable4);
                                }
                                throw throwable;
                            }
                            if (!isWindows) {
                                Files.setPosixFilePermissions(file6.toPath(), (Set<PosixFilePermission>)((Object)a));
                            }
                            object = "Failed retrieving Android licenses";
                            stringBuilder.setLength(0);
                            n = this.a.createNewJob(iPropProgressMonitor.newSubMonitor(1), iPrintAdapter, bl).exec(bl2, this.j, (Map<String, String>)((Object)this.a), stringBuilder, arrayList2);
                            if (n != 0) {
                                throw new Exception("return code = " + n);
                            }
                            string = stringBuilder.toString();
                            System.err.println("\n\n#########################\n   LICENSES  2\n#########################\n");
                            System.err.println(string);
                            System.err.println("\n#########################\n\n\n");
                            break block59;
                        }
                        finally {
                            if (file != null) {
                                file.delete();
                            }
                            if (file6 != null) {
                                file6.delete();
                            }
                        }
                    }
                    iPropProgressMonitor.setWorked(2);
                }
                catch (Exception exception) {
                    String string3 = stringBuilder.length() > 0 ? "\n" + String.valueOf(stringBuilder) : "";
                    BuildReply buildReply = new BuildReply(BuildRC.Android_Error, (String)object + ": " + exception.getMessage() + string3);
                    iPropProgressMonitor.done();
                    return buildReply;
                }
            }
            finally {
                iPropProgressMonitor.done();
            }
        }
        ILog.INFO(CommonBuilder.class, (String)"Android environment has been verified");
        return BuildReply.OK;
    }

    public static BuildEnvironment getInstance(String string, ICommonJobCreator iCommonJobCreator, IPropProgressMonitor iPropProgressMonitor2, IPrintAdapter iPrintAdapter2, boolean bl2, boolean bl3, boolean bl4) throws IOException {
        BuildReply buildReply;
        File file;
        if (iPropProgressMonitor2 == null) {
            iPropProgressMonitor2 = IPropProgressMonitor.NULL;
        }
        if (string == null) {
            String string2 = string = isWindows ? "/iiziBuildInstall" : System.getProperty("user.home") + "/iiziBuildInstall";
        }
        if (!(file = Utilities.getCanonicalFile((File)new File(string))).isDirectory()) {
            iPropProgressMonitor2.setTaskName("Creating build and installation directory " + file.getPath());
            try {
                Files.createDirectories(file.toPath(), new FileAttribute[0]);
            }
            catch (InvalidPathException invalidPathException) {
                throw new IOException("Invalid path: " + String.valueOf(file));
            }
        }
        if (iCommonJobCreator == null) {
            iCommonJobCreator = (iPropProgressMonitor, iPrintAdapter, bl) -> new CommonJobs(iPropProgressMonitor, iPrintAdapter, bl);
        }
        BuildEnvironment buildEnvironment = new BuildEnvironment(file, bl2, bl3, iCommonJobCreator, iPrintAdapter2);
        BuildReply buildReply2 = buildReply = bl2 ? buildEnvironment.getJavaEnvironment(null, iCommonJobCreator, iPropProgressMonitor2, bl4) : BuildReply.OK;
        if (buildReply.isOK()) {
            buildReply = buildEnvironment.initialize(true);
        }
        if (buildReply.isOK()) {
            buildReply = buildEnvironment.getVersions(iPropProgressMonitor2.newSubMonitor(5), iPrintAdapter2, true);
        }
        if (bl2 && buildReply.isOK() && buildEnvironment.j != null) {
            buildReply = buildEnvironment.checkAndroidEnvironment(iPropProgressMonitor2.newSubMonitor(4), iPrintAdapter2, bl4);
        }
        if (!buildReply.isOK()) {
            throw new IOException("Failed initializing build environment: " + String.valueOf(buildReply));
        }
        return buildEnvironment;
    }

    public static void main(String[] stringArray) {
        PropProgressMonitor propProgressMonitor = new PropProgressMonitor();
        propProgressMonitor.beginTask("Build environment", 5);
        a a2 = new a(propProgressMonitor);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        ICommonJobCreator iCommonJobCreator = (iPropProgressMonitor, iPrintAdapter, bl) -> new CommonJobs(iPropProgressMonitor, iPrintAdapter, bl);
        try {
            BuildEnvironment buildEnvironment = BuildEnvironment.getInstance(null, iCommonJobCreator, (IPropProgressMonitor)propProgressMonitor, a2, true, true, true);
            BuildReply buildReply = buildEnvironment.getExternalProcessEnvironment(hashMap, true);
            if (buildReply.isOK()) {
                ILog.INFO(BuildEnvironment.class, (String)"Environment is successfully setup");
                System.out.println("\n\n***** BuildEnvironment setup completed successfully *****");
            } else {
                ILog.SEVERE(BuildEnvironment.class, (String)("Environment failed setup: " + String.valueOf(buildReply)));
                System.out.println("\n\n***** BuildEnvironment setup completed with failure *****");
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace(System.err);
        }
    }
}

