/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.jetty;

import com.iizix.ILog;
import com.iizix.Utilities;
import com.iizix.comm.State;
import com.iizix.jetty.WSHelper;
import com.iizix.nio.IWebSocketComm;
import com.iizix.nio.WebSocketCommListener;
import java.io.EOFException;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import org.eclipse.jetty.util.NanoTime;
import org.eclipse.jetty.websocket.api.Callback;
import org.eclipse.jetty.websocket.api.Session;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class InternalWebSocket
implements IWebSocketComm,
Session.Listener,
Session.Listener.AutoDemanding {
    private static final boolean b = "true".equals(System.getProperty("iizi.InternalWebSocket-debug"));
    private static final Duration a = Duration.ofSeconds(60L);
    private WebSocketCommListener a;
    private final String a;
    private boolean c;
    private Session a;
    private boolean d;
    private boolean e;
    private boolean f;
    private final String b;
    private final String c;
    private final String d;
    private final int a;
    private final boolean g;
    private Object a;
    private final Callback a = Callback.from(() -> ILog.INFO(this.getClass(), (String)("sendHeartBeat @" + Utilities.formatCurrentDate() + " --> ASYNC SUCCESS")), throwable -> {
        if (WSHelper.a(throwable)) {
            ILog.WARNING(this.getClass(), (String)("Failed websocket send Heartbeat PING: " + String.valueOf(throwable)));
        } else {
            ILog.SEVERE(this.getClass(), (String)"Failed websocket send Heartbeat PING", (Throwable)throwable);
        }
        this.onWebSocketError((Throwable)throwable);
    });

    InternalWebSocket(String string, String string2, String string3, String string4, int n, boolean bl) {
        this.a = string;
        this.b = string2;
        this.c = string3;
        this.d = string4;
        this.a = n;
        this.g = bl;
    }

    public void open() throws IOException {
        this.f = true;
    }

    public State getState() {
        if (this.d) {
            return State.CLOSED;
        }
        if (this.e) {
            return State.CLOSING;
        }
        Session session = this.a;
        if (session == null) {
            return this.f ? State.CONNECTING : State.UNINITIALIZED;
        }
        if (session.isOpen()) {
            return State.OPEN;
        }
        return State.CONNECTED;
    }

    public String getDomain() {
        return this.d;
    }

    public int getPort() {
        return this.a;
    }

    public boolean isSecure() {
        return this.g;
    }

    public void setListener(WebSocketCommListener webSocketCommListener) {
        this.a = webSocketCommListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onWebSocketOpen(Session session) {
        if (this.d) {
            throw new InternalError("WebSocket already closed upon onWebSocketOpen call");
        }
        Object object = this;
        synchronized (object) {
            assert (this.a == null) : "Session alread set";
            this.a = session;
        }
        object = this.getSubProtocol();
        this.c = ((String)object).equals("iizic");
        session.setIdleTimeout(a);
        if (b) {
            ILog.INFO(this.getClass(), (String)("onWebSocketOpen @" + Utilities.formatCurrentDate() + " --> ProtocolVersion = " + session.getProtocolVersion() + ", SubProtocol = " + (String)object + ", Extensions = " + String.valueOf(session.getUpgradeRequest().getExtensions()) + ", IdleTimeout = " + String.valueOf(session.getIdleTimeout()) + ", MaxBinaryMessageSize = " + session.getMaxBinaryMessageSize() + ", MaxFrameSize = " + session.getMaxFrameSize() + ", MaxOutgoingFrames = " + session.getMaxOutgoingFrames() + ", MaxTextMessageSize = " + session.getMaxTextMessageSize() + ", OutputBufferSize = " + session.getOutputBufferSize() + ", InputBufferSize = " + session.getInputBufferSize() + ", isAutoFragment = " + session.isAutoFragment() + ", RemoteSocketAddress = " + String.valueOf(session.getRemoteSocketAddress()) + ", LocalSocketAddress = " + String.valueOf(session.getLocalSocketAddress()) + ", isIIZICompressionProtocolSupported = " + this.c));
        }
        this.a.onCommConnected((IWebSocketComm)this);
    }

    public void onWebSocketBinary(ByteBuffer byteBuffer, Callback callback) {
        try {
            assert (this.a != null) : "Session not set";
            byte[] byArray = Utilities.asByteArray((ByteBuffer)byteBuffer);
            int n = byArray.length;
            if (!this.d) {
                if (b) {
                    ILog.INFO(this.getClass(), (String)("onWebSocketBinary @" + Utilities.formatCurrentDate() + " --> DataSize = " + n));
                }
                this.a.onCommData((IWebSocketComm)this, byArray, 0, n);
            } else if (b) {
                ILog.WARNING(this.getClass(), (String)("onWebSocketBinary @" + Utilities.formatCurrentDate() + " --> DataSize = " + n + " --> Ignored because WebSocket is closed"));
            }
        }
        catch (Throwable throwable) {
            callback.fail(throwable);
            return;
        }
        callback.succeed();
    }

    public void onWebSocketText(String string) {
        assert (this.a != null) : "Session not set";
        if (!this.d) {
            if (b) {
                ILog.INFO(this.getClass(), (String)("onWebSocketText @" + Utilities.formatCurrentDate() + " --> TextLength = " + string.length()));
            }
            this.a.onCommData((IWebSocketComm)this, string);
        } else {
            ILog.WARNING(this.getClass(), (String)("onWebSocketText @" + Utilities.formatCurrentDate() + " --> TextLength = " + string.length() + " --> Ignored because WebSocket is closed"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onWebSocketClose(int n, String string) {
        if (b) {
            ILog.INFO(this.getClass(), (String)("onWebSocketClose @" + Utilities.formatCurrentDate() + " --> Code = " + n + ", Reason = " + string));
        }
        assert (this.a != null) : "Session not set";
        InternalWebSocket internalWebSocket = this;
        synchronized (internalWebSocket) {
            if (this.d) {
                return;
            }
            this.d = true;
        }
        this.a.onCommClosed((IWebSocketComm)this, n, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onWebSocketError(Throwable throwable) {
        InternalWebSocket internalWebSocket;
        block6: {
            if (b) {
                ILog.INFO(this.getClass(), (String)("onWebSocketError @" + Utilities.formatCurrentDate() + " --> Error = " + String.valueOf(throwable)), (Throwable)throwable);
            }
            internalWebSocket = this;
            synchronized (internalWebSocket) {
                if (this.d) {
                    break block6;
                }
            }
            this.a.onCommError((IWebSocketComm)this, throwable);
            this.close();
            return;
        }
        internalWebSocket = this.a;
        if (internalWebSocket != null) {
            internalWebSocket.disconnect();
        }
    }

    public void onWebSocketPing(ByteBuffer byteBuffer) {
        int n = byteBuffer.remaining();
        Session session = this.a;
        if (session == null) {
            ILog.WARNING(this.getClass(), (String)("onWebSocketFrame: PING message length = " + n + ": cannot send PONG, session is (closed) null"));
        } else if (this.e) {
            ILog.WARNING(this.getClass(), (String)("onWebSocketFrame: PING message length = " + n + ": cannot send PONG, session is closing"));
        } else if (this.d) {
            ILog.WARNING(this.getClass(), (String)("onWebSocketFrame: PING message length = " + n + ": cannot send PONG, session is closed"));
        } else {
            if (b) {
                ILog.INFO(this.getClass(), (String)("onWebSocketPing @" + Utilities.formatCurrentDate() + " --> ASYNC"));
            }
            session.sendPong(byteBuffer, Callback.from(() -> {
                if (b) {
                    ILog.INFO(this.getClass(), (String)("onWebSocketPing @" + Utilities.formatCurrentDate() + " <-- COMPLETED ASYNC"));
                }
            }, throwable -> {
                ILog.SEVERE(this.getClass(), (String)"Failed websocket send PONG frame", (Throwable)throwable);
                this.onWebSocketError((Throwable)throwable);
            }));
        }
    }

    public void onWebSocketPong(ByteBuffer byteBuffer) {
        int n = byteBuffer.remaining();
        if (n > 0 && n < 32) {
            byte[] byArray = new byte[n];
            byteBuffer.get(byArray);
            try {
                long l = NanoTime.since((long)Long.parseLong(new String(byArray, StandardCharsets.ISO_8859_1), 16)) / 1000000L;
                if (b) {
                    ILog.INFO(this.getClass(), (String)("onWebSocketFrame @" + Utilities.formatCurrentDate() + " --> PONG, HeartBeatTime = " + l + " ms"));
                }
                this.a.onCommHeartBeat((IWebSocketComm)this, l);
                return;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (b) {
            ILog.WARNING(this.getClass(), (String)("onWebSocketFrame @" + Utilities.formatCurrentDate() + " --> PONG frame received with invalid data: length = " + n));
        }
    }

    public synchronized boolean isConnecting() {
        Session session = this.a;
        return session == null && !this.d && !this.e;
    }

    public synchronized boolean isConnected() {
        Session session = this.a;
        return session != null && !this.d && !this.e && session.isOpen();
    }

    public synchronized boolean isClosing() {
        return this.e;
    }

    public synchronized boolean isClosed() {
        Session session = this.a;
        return this.d || session != null && !session.isOpen();
    }

    public void close() {
        this.close(0, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(int n, String string) {
        if (b) {
            ILog.INFO(this.getClass(), (String)("close @" + Utilities.formatCurrentDate() + " --> Reason = " + string + ", Thread = " + String.valueOf(Thread.currentThread())));
        }
        Session session = this.a;
        InternalWebSocket internalWebSocket = this;
        synchronized (internalWebSocket) {
            if (this.d) {
                return;
            }
            if (session == null) {
                this.d = true;
                return;
            }
            if (this.e) {
                return;
            }
            this.e = true;
        }
        this.a.onCommClosing((IWebSocketComm)this);
        try {
            if (n == 0) {
                session.close();
            } else {
                if (string == null) {
                    string = "Close";
                } else {
                    int n2 = string.length();
                    if (n2 > 120) {
                        ILog.WARNING(this.getClass(), (String)("close(" + n + ",reason=" + string + "): Close msg len = " + n2 + ", long message truncated to 120 characters"));
                        string = string.substring(0, 120);
                    }
                }
                String string2 = string;
                session.close(n, string, Callback.from(() -> {}, throwable -> {
                    if (WSHelper.a(throwable)) {
                        ILog.WARNING(this.getClass(), (String)("Failed websocket send CLOSE, reason = " + string2 + ": " + String.valueOf(throwable)));
                    } else {
                        ILog.SEVERE(this.getClass(), (String)("Failed websocket send CLOSE, reason = " + string2 + ": " + String.valueOf(throwable)));
                    }
                    this.onWebSocketError((Throwable)throwable);
                }));
            }
        }
        catch (Exception exception) {
            this.d = true;
            ILog.SEVERE(this.getClass(), (String)"Failed session close, disconnecting", (Throwable)exception);
            session.disconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean close(boolean bl) {
        if (b) {
            ILog.INFO(this.getClass(), (String)("close @" + Utilities.formatCurrentDate() + " --> RightNow = " + bl));
        }
        InternalWebSocket internalWebSocket = this;
        synchronized (internalWebSocket) {
            block8: {
                if (!this.d) break block8;
                return false;
            }
            if (bl) {
                this.d = true;
            }
        }
        if (!bl) {
            this.close();
            return true;
        }
        internalWebSocket = this.a;
        if (internalWebSocket != null) {
            internalWebSocket.close();
            internalWebSocket.disconnect();
        }
        return true;
    }

    public void setSubProtocol(String string) throws IllegalStateException {
        throw new IllegalStateException("Already set!");
    }

    public String getSubProtocol() {
        return this.a;
    }

    public boolean areBinaryDataFramesSupported() {
        return true;
    }

    public void send(byte[] byArray) throws IOException {
        Session session = this.a;
        if (session == null) {
            throw new IOException("Not connected");
        }
        if (b) {
            ILog.INFO(this.getClass(), (String)("send BINARY @" + Utilities.formatCurrentDate() + " --> DataSize = " + byArray.length + " --> ASYNC BEGIN"));
        }
        if (this.isConnected()) {
            try {
                session.sendBinary(ByteBuffer.wrap(byArray), Callback.from(() -> {
                    if (b) {
                        ILog.INFO(this.getClass(), (String)("send BINARY @" + Utilities.formatCurrentDate() + " --> DataSize = " + byArray.length + " --> ASYNC SUCESSS"));
                    }
                }, throwable -> {
                    if (WSHelper.a(throwable)) {
                        ILog.WARNING(this.getClass(), (String)("Failed websocket send Binary data, size = " + byArray.length + ": " + String.valueOf(throwable)));
                    } else {
                        ILog.SEVERE(this.getClass(), (String)("Failed websocket send Binary data, size = " + byArray.length), (Throwable)throwable);
                    }
                    this.onWebSocketError((Throwable)throwable);
                }));
            }
            catch (IllegalStateException illegalStateException) {
                if (this.d || this.e) {
                    return;
                }
                this.close(true);
                EOFException eOFException = new EOFException("Send failure: " + illegalStateException.getMessage());
                eOFException.initCause(illegalStateException);
                throw eOFException;
            }
        } else {
            throw new EOFException("Session is closed");
        }
    }

    public void send(String string) throws IOException {
        Session session = this.a;
        if (session == null) {
            throw new IOException("Not connected");
        }
        if (b) {
            ILog.INFO(this.getClass(), (String)("send TEXT @" + Utilities.formatCurrentDate() + " --> Text length = " + string.length() + " --> ASYNC BEGIN"));
        }
        if (this.isConnected()) {
            try {
                session.sendText(string, Callback.from(() -> {
                    if (b) {
                        ILog.INFO(this.getClass(), (String)("send TEXT @" + Utilities.formatCurrentDate() + " --> Text length = " + string.length() + " --> ASYNC SUCCESS"));
                    }
                }, throwable -> {
                    if (WSHelper.a(throwable)) {
                        ILog.WARNING(this.getClass(), (String)("Failed websocket send Text data, size = " + string.length() + ": " + String.valueOf(throwable)));
                    } else {
                        ILog.SEVERE(this.getClass(), (String)("Failed websocket send Text data, size = " + string.length()), (Throwable)throwable);
                    }
                    this.onWebSocketError((Throwable)throwable);
                }));
            }
            catch (IllegalStateException illegalStateException) {
                if (this.d || this.e) {
                    return;
                }
                this.close(true);
                throw new EOFException("Send failure: " + illegalStateException.getMessage());
            }
        } else {
            throw new EOFException("Session is closed");
        }
    }

    public boolean sendHeartBeat() throws IOException {
        Session session = this.a;
        if (session == null) {
            return false;
        }
        if (!this.isConnected()) {
            return false;
        }
        if (b) {
            ILog.INFO(this.getClass(), (String)("sendHeartBeat @" + Utilities.formatCurrentDate() + " --> ASYNC BEGIN"));
        }
        try {
            session.sendPing(ByteBuffer.wrap(Long.toHexString(System.nanoTime()).getBytes(StandardCharsets.ISO_8859_1)), this.a);
        }
        catch (IllegalStateException illegalStateException) {
            throw new IOException("Send failure", illegalStateException);
        }
        return true;
    }

    public String getRemoteAddr() {
        return this.b;
    }

    public String getRemoteHost() {
        return this.c;
    }

    public SocketAddress getSocketAddress() {
        Session session = this.a;
        return session != null ? session.getRemoteSocketAddress() : null;
    }

    public Object getAttachment() {
        return this.a;
    }

    public void setAttachment(Object object) {
        this.a = object;
    }

    public boolean isCompressionSupported() {
        return this.c;
    }
}

