/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.security;

import com.iizix.NotFoundException;
import com.iizix.OutputReader;
import com.iizix.SystemConfig;
import com.iizix.Utilities;
import com.iizix.util.XFile;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.List;

public class JarSigner {
    private static String a;

    private JarSigner() {
    }

    public static String getJarsigner() throws NotFoundException {
        if (a != null) {
            return a;
        }
        String string = "jarsigner" + SystemConfig.EXE_EXT;
        a = XFile.findFileInPath(string, true);
        if (a == null) {
            throw new NotFoundException("The JDK Jar signer executable \"" + string + "\" was not found in the Path or JVM Path: make sure to use the JDK and not the JRE to execute IIZI");
        }
        return a;
    }

    public static void signJar(File file, KeyStore keyStore, File file2, String string, String string2, String string3, String string4, String string5) throws IOException {
        String string6 = Utilities.getCanonicalFile(file).getPath();
        if (!file.isFile()) {
            throw new FileNotFoundException(string6);
        }
        String string7 = JarSigner.getJarsigner();
        File file3 = null;
        try {
            Object object;
            Process process;
            Object object2;
            Iterable<Path> iterable;
            if (keyStore != null) {
                try {
                    iterable = Files.createTempFile(null, null, new FileAttribute[0]);
                    file3 = iterable.toFile();
                    object2 = null;
                    process = null;
                    try {
                        object = new FileOutputStream(file3);
                        try {
                            keyStore.store((OutputStream)object, string2.toCharArray());
                            ((FileOutputStream)object).close();
                        }
                        finally {
                            if (object != null) {
                                ((FileOutputStream)object).close();
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        if (object2 == null) {
                            object2 = throwable;
                        } else if (object2 != throwable) {
                            ((Throwable)object2).addSuppressed(throwable);
                        }
                        throw object2;
                    }
                    file2 = file3;
                }
                catch (Exception exception) {
                    throw new IOException("Failed getting system keystore: " + exception.getMessage(), exception);
                }
            }
            if (!file2.isFile()) {
                throw new IOException("Keystore file " + file2.getAbsolutePath() + " is not found");
            }
            iterable = new ArrayList();
            ((ArrayList)iterable).add((String)string7);
            ((ArrayList)iterable).add((String)"-keystore");
            ((ArrayList)iterable).add((String)Utilities.getCanonicalFile(file2).getPath());
            ((ArrayList)iterable).add((String)"-storetype");
            ((ArrayList)iterable).add((String)string);
            if (string3 != null) {
                ((ArrayList)iterable).add((String)"-keypass");
                ((ArrayList)iterable).add((String)string3);
            }
            if (string5 != null) {
                ((ArrayList)iterable).add((String)"-tsa");
                ((ArrayList)iterable).add((String)string5);
            }
            ((ArrayList)iterable).add((String)string6);
            ((ArrayList)iterable).add((String)string4);
            object2 = new ProcessBuilder((List<String>)iterable);
            ((ProcessBuilder)object2).redirectInput(ProcessBuilder.Redirect.PIPE);
            ((ProcessBuilder)object2).redirectErrorStream(true);
            process = ((ProcessBuilder)object2).start();
            object = new OutputReader(process.getInputStream());
            try {
                process.waitFor();
            }
            catch (InterruptedException interruptedException) {
                throw new IOException("JarSigner process interrupted", interruptedException);
            }
            int n2 = process.exitValue();
            if (n2 != 0) {
                StringBuilder stringBuilder = new StringBuilder(":\n");
                ((OutputReader)object).getOutput(stringBuilder);
                String string8 = stringBuilder.length() > 2 ? stringBuilder.toString().replace("\n", "\n  [jarsigner]  ") : "";
                throw new IOException("JarSigner failed with return code = " + n2 + string8);
            }
        }
        finally {
            if (file3 != null && file3.isFile()) {
                boolean bl = false;
                try {
                    Files.delete(file3.toPath());
                    bl = true;
                }
                finally {
                    if (!bl) {
                        file3.deleteOnExit();
                    }
                }
            }
        }
    }
}

