/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.prop;

import com.iizix.prop.Atom;
import com.iizix.prop.GProp;
import com.iizix.prop.IPropReference;
import com.iizix.prop.ImageReference;
import com.iizix.prop.PropVerification;
import com.iizix.prop.PropVerificationError;
import com.iizix.prop.image.IImageTarget;
import com.iizix.prop.image.ImageDefinition;

public class BackgroundImageReference
extends ImageReference {
    public BackgroundImageReference() {
    }

    public BackgroundImageReference(Atom atom) {
        super(atom);
    }

    public BackgroundImageReference(Atom atom, String string) {
        super(atom, string);
    }

    @Override
    public IPropReference.IRefType getReferenceType() {
        return IPropReference.RefType.BackgroundImage;
    }

    @Override
    public boolean isReferenceValid(GProp<?> gProp) {
        return gProp instanceof ImageDefinition && ((ImageDefinition)gProp).isImageTargetValid();
    }

    @Override
    public boolean verify(PropVerification propVerification) {
        if (!super.verify(propVerification)) {
            return false;
        }
        IImageTarget iImageTarget = (IImageTarget)this.getTargetReference();
        if (iImageTarget != null && !(iImageTarget instanceof ImageDefinition)) {
            propVerification.add(new PropVerificationError("bg", PropVerificationError.Severity.ERROR, "Background image", this, "Image reference must be of single image type", new String[0]));
        }
        return true;
    }
}

