/*
 * Decompiled with CFR 0.152.
 */
package com.iizigo.prop.editor;

import com.iizigo.Activator;
import com.iizigo.ImageRegistry;
import com.iizigo.editor.PropHelper;
import com.iizigo.editor.UndoTransaction;
import com.iizigo.editor.complex.ComplexOperation;
import com.iizigo.jface.PartAction;
import com.iizigo.prop.editor.IVSActionActorParticipantProvider;
import com.iizigo.prop.editor.VSRelativeReferencePropEditor;
import com.iizigo.prop.editor.dialog.SelectPropDialog;
import com.iizigo.prop.editor.dialog.SelectPropViewerFilter;
import com.iizigo.prop.editor.q;
import com.iizigo.swt.IzToolTip;
import com.iizigo.swt.WizardDialog;
import com.iizigo.vs.NewVSComponentWizard;
import com.iizigo.vs.prop.EditorVSAction;
import com.iizigo.vs.prop.EditorVirtualSpace;
import com.iizix.IDisposedPart;
import com.iizix.ILog;
import com.iizix.prop.GProp;
import com.iizix.prop.IPropCnr;
import com.iizix.prop.PropCnr;
import com.iizix.prop.vs.VSAction;
import com.iizix.prop.vs.VSComponent;
import com.iizix.prop.vs.VSReference;
import com.iizix.prop.vs.VirtualSpace;
import com.iizix.swt.IzMenu;
import com.iizix.swt.SWTHelper;
import com.iizix.swt.widget.IZ_Button;
import com.iizix.swt.widget.IZ_Label;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class VSActionActorParticipantEditor
extends VSRelativeReferencePropEditor {
    private static final Class<?>[] a = new Class[]{VSAction.class};
    private IZ_Label a;
    private IzMenu a;
    private PartAction a;
    private PartAction b;
    private PartAction c;
    private PartAction d;
    private PartAction e;
    private PartAction f;

    @Override
    protected void setup() {
        this.title = "Select a VirtualSpace Action";
        this.moreText = "Selects a VirtualSpace Action";
        this.tooltipText = "Double-click to open the VirtualSpace Action selection dialog as this field is not editable";
        this.itemDefined = "VS Action";
        this.image = this.appUI.imageVSAction;
        this.classes = a;
    }

    @Override
    protected void setEditable(boolean bl) {
        this.more.setEnabled(bl);
    }

    @Override
    protected void setFocus() {
        this.more.setFocus();
    }

    @Override
    protected void create() {
        this.setup();
        this.createGridLayout(2, 0);
        this.createMoreButton(this.moreText);
        this.editor.addFocusInfo((Control)this.more);
        this.a = new IZ_Label(this.parent, 0);
        this.control = this.a;
        this.a.setBackground(this.appUI.propEditorBackground);
        this.a.setLayoutData(new GridData(4, 4, true, true));
        this.a.addMouseListener((MouseListener)new q(this));
        this.tip = new IzToolTip((Control)this.a);
        this.a();
        this.a = this.createMoreIzMenu();
        this.a.omitDisabled().add((IAction)this.b).add((IAction)this.a).addSeparator().add((IAction)this.c).add((IAction)this.d).add((IAction)this.e).addSeparator().add((IAction)this.f);
    }

    private void a() {
        ImageRegistry imageRegistry = ImageRegistry.getInstance();
        this.b = new PartAction((IDisposedPart)this, "Connect to &VirtualSpace...", imageRegistry.get("virtualspace.gif")).with(() -> this.c());
        this.a = new PartAction((IDisposedPart)this, "Create VirtualSpace and connect it...", this.appUI.getNewImageDescriptor(this.appUI.imageVirtualSpace)).with(() -> this.b());
        this.c = new PartAction((IDisposedPart)this, "&Create VS Action...", this.appUI.getNewImageDescriptor(this.appUI.imageVSAction)).with(() -> this.d());
        this.d = new PartAction((IDisposedPart)this, "&Select VS Action...", imageRegistry.get("vs_action.png")).with(() -> this.e());
        this.e = new PartAction((IDisposedPart)this, "&Fix Action Actor back-references", imageRegistry.get("wizard.png")).with(() -> {
            boolean bl = this.a(true);
        });
        this.f = new PartAction((IDisposedPart)this, "Sho&w in Editor", imageRegistry.get("show_in_editor.gif")).with(() -> {
            boolean bl = this.b(true);
        });
    }

    private void b() {
        this.getVirtualSpace(1);
    }

    private void c() {
        this.getVirtualSpace(0);
    }

    private void d() {
        NewVSComponentWizard<EditorVSAction> newVSComponentWizard;
        WizardDialog wizardDialog;
        EditorVirtualSpace editorVirtualSpace = this.getVirtualSpace(-1);
        if (editorVirtualSpace != null && (wizardDialog = new WizardDialog(this.shell, newVSComponentWizard = NewVSComponentWizard.newVSActionWizard(editorVirtualSpace, this.controller.getUndoRedo()))).open() == 0) {
            EditorVSAction editorVSAction = newVSComponentWizard.getComponent();
            String string = editorVSAction.getRelativePropName(editorVirtualSpace);
            this.a(string, "Set VirtualSpace Action");
        }
        this.more.setFocus();
    }

    private void e() {
        EditorVirtualSpace editorVirtualSpace = this.getVirtualSpace(-1);
        if (editorVirtualSpace != null) {
            SelectPropViewerFilter selectPropViewerFilter = new SelectPropViewerFilter(this.classes);
            Object[] objectArray = new Object[]{editorVirtualSpace.getDesigner()};
            String string = new SelectPropDialog(this.shell, this.title, this.image, this.controller.getModuleModel(), objectArray, selectPropViewerFilter, this.classes, this.getCurrentInput(), -1).open();
            if (string != null) {
                String string2 = null;
                GProp gProp = editorVirtualSpace.getPropFromReference(string);
                if (gProp == null) {
                    string2 = "Property reference \"" + string + "\" could not be found!";
                } else {
                    string = gProp.getRelativePropName((IPropCnr)editorVirtualSpace);
                    if (string == null) {
                        string2 = "Property reference \"" + string + "\" is not relative the VirtualSpace \"" + editorVirtualSpace.getReferencePropName() + "\"!";
                    } else {
                        this.a(string, "Set VirtualSpace Action");
                    }
                }
                if (string2 != null) {
                    Activator.openError(this.shell, "Relative VirtualSpace Error", string2);
                }
            }
        }
        this.more.setFocus();
    }

    private void a(String string, String string2) {
        PropCnr propCnr = this.propController.getParents()[0];
        VSComponent vSComponent = this.getReferenceTarget(string);
        if (!(vSComponent instanceof VSAction)) {
            ILog.SEVERE(this.getClass(), (String)("New reference " + string + " is not a VirtualSpace Action: " + String.valueOf(vSComponent)));
        } else {
            VSAction vSAction = (VSAction)vSComponent;
            if (!(propCnr instanceof IVSActionActorParticipantProvider)) {
                ILog.SEVERE(this.getClass(), (String)"Parent property not instanceof IVSActionReferenceAsActorProvider", (Object)propCnr);
            } else {
                IVSActionActorParticipantProvider iVSActionActorParticipantProvider = (IVSActionActorParticipantProvider)propCnr;
                UndoTransaction undoTransaction = new UndoTransaction(string2, (IUndoContext)this.controller.getUndoContext());
                ComplexOperation complexOperation = new ComplexOperation(string2, null, this.controller.getUndoRedo());
                try {
                    iVSActionActorParticipantProvider.setActionActor(true, vSAction, complexOperation);
                    if (complexOperation.hasPerformedAnOperation()) {
                        PropHelper.executeOperation(this.shell, complexOperation);
                    }
                    this.propController.assignValue(string);
                    undoTransaction.commit();
                }
                finally {
                    undoTransaction.rollback(this.shell, true);
                }
                this.setInput(string);
            }
        }
    }

    private boolean a(boolean bl) {
        VSAction vSAction;
        PropCnr propCnr;
        String string;
        block6: {
            block5: {
                string = this.getCurrentInput();
                if (string == null || string.isEmpty()) {
                    return false;
                }
                propCnr = this.propController.getParents()[0];
                VSComponent vSComponent = this.getReferenceTarget(string);
                if (!(vSComponent instanceof VSAction)) break block5;
                vSAction = (VSAction)vSComponent;
                if (propCnr instanceof IVSActionActorParticipantProvider) break block6;
            }
            return false;
        }
        IVSActionActorParticipantProvider iVSActionActorParticipantProvider = (IVSActionActorParticipantProvider)propCnr;
        boolean bl2 = iVSActionActorParticipantProvider.setActionActor(false, vSAction, null);
        if (bl2 && bl) {
            this.a(string, "Fix VirtualSpace Action Actor back-references");
            this.setFocus();
        }
        return bl2;
    }

    @Override
    protected void onDoubleClick(Event event) {
        if (this.b(false)) {
            event.doit = false;
            this.b(true);
        }
    }

    private boolean b(boolean bl) {
        VSComponent vSComponent = this.getCurrentReferenceTarget();
        if (vSComponent == null) {
            return false;
        }
        return PropHelper.doOpenAndFocus(bl, vSComponent, -1);
    }

    @Override
    public void onMore() {
        boolean bl = false;
        PropCnr propCnr = this.propController.getParents()[0];
        VSReference vSReference = propCnr.getVSReference(this.info.atom);
        if (vSReference != null || propCnr.createVSReference(this.info.atom, new PropCnr[1]) != null) {
            VirtualSpace virtualSpace = vSReference != null ? (VirtualSpace)vSReference.getTargetReference() : null;
            bl = virtualSpace == null;
        }
        this.a.setEnabled(bl);
        this.b.setEnabled(bl);
        this.e.setEnabled(this.a(false));
        this.f.setEnabled(this.b(false));
        SWTHelper.showPopupMenu(this.a, (Control)this.more);
    }

    @Override
    protected boolean setInput(String string) {
        if (string != null) {
            this.a.setText(string.replace("&", "&&"));
        }
        return true;
    }

    @Override
    public String getCurrentInput() {
        return this.a.getText();
    }

    @Override
    public void onDefine(boolean bl) {
        if (bl) {
            super.onDefine(bl);
        } else {
            PropCnr propCnr = this.propController.getParents()[0];
            if (!(propCnr instanceof IVSActionActorParticipantProvider)) {
                ILog.SEVERE(this.getClass(), (String)"Parent property not instanceof IVSActionReferenceAsActorProvider", (Object)propCnr);
            } else {
                IVSActionActorParticipantProvider iVSActionActorParticipantProvider = (IVSActionActorParticipantProvider)propCnr;
                UndoTransaction undoTransaction = new UndoTransaction("Remove VirtualSpace Action Actor", (IUndoContext)this.controller.getUndoContext());
                try {
                    ComplexOperation complexOperation = new ComplexOperation("Remove VirtualSpace Action Actor", null, this.controller.getUndoRedo());
                    if (!iVSActionActorParticipantProvider.removeActionActor(this.shell, complexOperation)) {
                        return;
                    }
                    if (!complexOperation.hasPerformedAnOperation()) {
                        undoTransaction.rollback(this.shell, false);
                        undoTransaction = null;
                        super.onDefine(bl);
                    } else {
                        PropHelper.executeOperation(this.shell, complexOperation);
                        super.onDefine(bl);
                        undoTransaction.commit();
                        undoTransaction = null;
                    }
                }
                finally {
                    if (undoTransaction != null) {
                        undoTransaction.rollback(this.shell, true);
                    }
                }
            }
        }
    }

    static /* synthetic */ IZ_Button a(VSActionActorParticipantEditor vSActionActorParticipantEditor) {
        return vSActionActorParticipantEditor.more;
    }
}

