/*
 * Decompiled with CFR 0.152.
 */
package com.iizigo.prop.editor;

import com.iizigo.prop.BaseEditor;
import com.iizigo.swt.UpDownArrowSpinner;
import com.iizix.prop.IntProp;

public class IntPropEditor
extends BaseEditor<IntProp, Integer> {
    @Override
    protected void create() {
        this.createGridLayout(1, 0);
        this.createText();
        UpDownArrowSpinner.enable(this.text, true);
    }

    @Override
    protected String getToolTipText() {
        return "Enter an integer value";
    }

    @Override
    public Integer getDefaultValue() {
        try {
            return Integer.valueOf(this.info.defaultPropertyValue);
        }
        catch (Exception exception) {
            return 0;
        }
    }

    @Override
    protected Integer getValue(String string) throws Exception {
        if (string.isEmpty()) {
            throw new Exception("Number must be specified");
        }
        String string2 = null;
        try {
            int n2 = Integer.parseInt(string);
            if (n2 >= -536870911 && n2 <= 0x1FFFFFFF) {
                return n2;
            }
            string2 = "Invalid number range (-536870911 to 536870911, hex 1FFF FFFF): " + string;
        }
        catch (NumberFormatException numberFormatException) {
            string2 = "Invalid number: " + string;
        }
        throw new Exception(string2);
    }

    @Override
    public String formatValue(Integer n2) {
        return n2.toString();
    }
}

