/*
 * Decompiled with CFR 0.152.
 */
package com.iizigo.prop.editor;

import com.iizigo.prop.BaseEditor;
import com.iizigo.prop.editor.BoxShadowValidator;
import com.iizigo.prop.editor.dialog.BoxShadowDialog;
import com.iizix.prop.StringProp;

public class BoxShadowPropEditor
extends BaseEditor<StringProp, String> {
    @Override
    protected void create() {
        this.createGridLayout(2, 0);
        this.createMoreButton("Display Box Shadow designer");
        this.createText();
    }

    @Override
    public void onMore() {
        String string = new BoxShadowDialog(this.parent.getShell(), this.getCurrentInput()).open();
        if (string != null) {
            this.setInput(string);
        }
    }

    @Override
    protected String getToolTipText() {
        return "Enter a string with parameters separated by spaces:\n - [inset]   (optional text)\n - horizontal-offset-unit\n - vertical-offset-unit\n - blur-radius-unit\n - spread-radius-unit\n - color (RGBA)";
    }

    @Override
    public String getDefaultValue() {
        return "";
    }

    @Override
    protected String getValue(String string) throws Exception {
        if (string.isEmpty()) {
            return null;
        }
        BoxShadowValidator boxShadowValidator = new BoxShadowValidator(string);
        String string2 = boxShadowValidator.error;
        if (string2 == null && boxShadowValidator.tooManyParams) {
            string2 = "Too many parameters entered, only 5 or 6 should be specified";
        } else if (string2 == null) {
            if (boxShadowValidator.horz == null) {
                string2 = "Horizontal offset not specified";
            } else if (boxShadowValidator.vert == null) {
                string2 = "Vertical offset not specified";
            }
        }
        if (string2 == null) {
            return boxShadowValidator.getCSSValue();
        }
        throw new Exception(string2);
    }

    @Override
    public String formatValue(String string) {
        try {
            return this.getValue(string.trim());
        }
        catch (Exception exception) {
            return string.trim();
        }
    }
}

