/*
 * Decompiled with CFR 0.152.
 */
package com.tabnine.eclipse.shared.api.binary.fetch;

import com.tabnine.eclipse.shared.api.binary.exceptions.FailedToDownloadException;
import com.tabnine.eclipse.shared.api.binary.fetch.DownloadValidator;
import com.tabnine.eclipse.shared.api.binary.fetch.GeneralDownloader$1;
import com.tabnine.eclipse.shared.api.preferences.SharedPreferences;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.security.SecureRandom;
import java.util.Base64;
import java.util.UUID;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.core.net.proxy.IProxyData;
import org.eclipse.core.net.proxy.IProxyService;
import org.eclipse.ui.PlatformUI;

public class GeneralDownloader {
    static Logger logger = LogManager.getLogger(GeneralDownloader.class);

    boolean download(String object, String string, DownloadValidator downloadValidator) {
        Path path;
        block6: {
            path = Paths.get(String.format("%s.download.%s", string, UUID.randomUUID()), new String[0]);
            if (path.getParent().toFile().exists() || path.getParent().toFile().mkdirs()) break block6;
            logger.warn(String.format("Could not create the required directories for %s", path));
            return false;
        }
        try {
            object = GeneralDownloader.openConnection(new URL((String)object));
            ((URLConnection)object).setConnectTimeout(5000);
            ((URLConnection)object).setReadTimeout(300000);
            Files.copy(((URLConnection)object).getInputStream(), path, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException iOException) {
            logger.warn((Object)iOException);
            return false;
        }
        catch (URISyntaxException uRISyntaxException) {
            logger.warn((Object)uRISyntaxException);
            return false;
        }
        try {
            downloadValidator.validateAndRename(path, Paths.get(string, new String[0]));
        }
        catch (FailedToDownloadException failedToDownloadException) {
            logger.warn((Object)failedToDownloadException);
            path.toFile().delete();
            return false;
        }
        return true;
    }

    public static URLConnection openConnection(URL object) {
        Object object2;
        Object object3;
        Object object4 = PlatformUI.getWorkbench();
        object4 = (IProxyService)object4.getService(IProxyService.class);
        object4 = object4.select(((URL)object).toURI());
        String string2 = SharedPreferences.getIgnoreSSLErrors();
        if (object4 != null && ((IProxyData[])object4).length > 0) {
            object4 = object4[0];
            object3 = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(object4.getHost(), object4.getPort()));
            object = ((URL)object).openConnection((Proxy)object3);
            if (object4.isRequiresAuthentication()) {
                object2 = new StringBuilder();
                ((StringBuilder)object2).append(object4.getUserId()).append(":").append(object4.getPassword());
                object4 = new String(Base64.getEncoder().encode(((StringBuilder)object2).toString().getBytes()));
                ((URLConnection)object).setRequestProperty("Proxy-Authorization", "Basic ".concat(String.valueOf(object4)));
            }
        } else {
            object = ((URL)object).openConnection();
        }
        if (string2.equals("true")) {
            object4 = new TrustManager[]{new GeneralDownloader$1()};
            try {
                object3 = SSLContext.getInstance("SSL");
                ((SSLContext)object3).init(null, (TrustManager[])object4, new SecureRandom());
                object2 = (string, sSLSession) -> true;
                if (object instanceof HttpsURLConnection) {
                    object4 = (HttpsURLConnection)object;
                    ((HttpsURLConnection)object4).setSSLSocketFactory(((SSLContext)object3).getSocketFactory());
                    ((HttpsURLConnection)object4).setHostnameVerifier((HostnameVerifier)object2);
                }
            }
            catch (Exception exception) {
                object2 = exception;
                exception.printStackTrace();
            }
        }
        return object;
    }
}

