/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.jetty;

import com.iizix.ILog;
import com.iizix.IWebServerCompression;
import com.iizix.RunMode;
import com.iizix.SystemConfig;
import com.iizix.comm.IServerSettings;
import com.iizix.comm.PortConfig;
import com.iizix.jetty.IExternalBrowserPages;
import com.iizix.jetty.IWSFileProviderServer;
import com.iizix.jetty.IWSUploaderService;
import com.iizix.jetty.UploadServlet;
import com.iizix.jetty.WSHelper;
import com.iizix.jetty.f;
import com.iizix.jetty.h;
import com.iizix.jetty.j;
import com.iizix.nio.WebSocketAcceptor;
import com.iizix.text.KString;
import com.iizix.web.ICommonServletInterface;
import jakarta.servlet.MultipartConfigElement;
import jakarta.servlet.Servlet;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.jetty.ee11.servlet.ServletContextHandler;
import org.eclipse.jetty.ee11.servlet.ServletHolder;
import org.eclipse.jetty.server.CustomRequestLog;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.RequestLog;
import org.eclipse.jetty.server.RequestLogWriter;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.DefaultHandler;
import org.eclipse.jetty.server.handler.SecuredRedirectHandler;
import org.eclipse.jetty.server.handler.StatisticsHandler;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class RunConfigurationWebServer
implements IWebServerCompression {
    private static final String[] a = new String[]{"release.dojo.root", "release.jquery.file"};
    static final int a = "/$iiziRunCustom.root$/".length();
    static final int b = "/$iiziRunCustomized.root$/".length();
    private static final String[] b = new String[]{"dojo.root", "release.dojo.root", "jquery.file", "release.jquery.file", "iiziRunDevel.root", "iiziRunCustom.root", "iiziRunCustomized.root"};
    public Server server;
    private Thread a;
    private final String a;
    private final Map<String, File> a;
    private final Map<File, File> b;
    private final IWSFileProviderServer a;
    private final IWSUploaderService a;
    private StatisticsHandler a;
    private PortConfig[] a = new ConcurrentHashMap();

    private static File a(File file, File file2) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file2), StandardCharsets.UTF_8));){
            Object object;
            String string;
            do {
                if ((string = bufferedReader.readLine()) != null) continue;
                throw new IOException("\"" + file2.getPath() + "\" file does not contain a file or directory name");
            } while (string.startsWith(";"));
            if (File.separatorChar == '/' && (object = bufferedReader.readLine()) != null) {
                string = object;
            }
            Object object2 = object = string.startsWith("/") ? new File(string) : new File(file, string);
            if (!((File)object).exists()) {
                throw new IOException("\"" + file2.getPath() + "\" file specified the file or directory \"" + string + "\" that does not exist");
            }
            return object;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public PortConfig[] getPortConfigurations() {
        return this.a;
    }

    public RunConfigurationWebServer(String string, IWSFileProviderServer iWSFileProviderServer, IWSUploaderService iWSUploaderService) {
        this.b = (int)new ConcurrentHashMap();
        this.a = string;
        this.a = iWSFileProviderServer;
        this.a = iWSUploaderService;
    }

    public File getWebServerMapping(String string) {
        return (File)this.a.get(string);
    }

    public synchronized PortConfig[] startWebServer(IExternalBrowserPages iExternalBrowserPages, WebSocketAcceptor webSocketAcceptor, IServerSettings iServerSettings, Callable<Void> callable, ICommonServletInterface ... iCommonServletInterfaceArray) throws IOException {
        String string;
        Handler.Sequence sequence;
        String[] stringArray;
        File file;
        String[] stringArray2;
        if (this.a != null) {
            this.a.interrupt();
        }
        int[] nArray = new int[1];
        ArrayList<PortConfig> arrayList = new ArrayList<PortConfig>();
        Server server = WSHelper.a(iServerSettings, arrayList, nArray);
        this.a = arrayList.toArray(new PortConfig[arrayList.size()]);
        File file2 = new File(this.a).getAbsoluteFile();
        this.a.clear();
        Object object = SystemConfig.isDevelopmentMode ? b : a;
        boolean bl = ((String[])object).length;
        boolean bl2 = false;
        while (bl2 < bl) {
            stringArray2 = object[bl2];
            file = new File(file2, (String)stringArray2);
            try {
                file = RunConfigurationWebServer.a(file2, file);
                this.a.put(stringArray2, file);
            }
            catch (IOException iOException) {
                if (stringArray2.equals("iiziRunDevel.root")) {
                    ILog.WARNING(this.getClass(), (String)("Failed loading iiziRun Developer root redirection file '" + file.getPath() + "', ignoring it: " + iOException.getMessage()));
                }
                if (stringArray2.equals("iiziRunCustom.root")) {
                    ILog.WARNING(this.getClass(), (String)("Failed loading iiziRun Custom root redirection file '" + file.getPath() + "', ignoring it: " + iOException.getMessage()));
                }
                ILog.SEVERE(this.getClass(), (String)("Failed loading root redirection file '" + file.getPath() + "', ignoring it: " + iOException.getMessage()));
            }
            bl2 += 1;
        }
        try {
            callable.call();
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            throw new IOException(exception.getMessage(), exception);
        }
        if (new File(file2, "index.html").isFile()) {
            String[] stringArray3 = new String[1];
            stringArray = stringArray3;
            stringArray3[0] = "index.html";
        } else {
            String[] stringArray4 = new String[2];
            stringArray4[0] = RunMode.isServerRunDevelopmentMode() ? "index-devel-server.html" : "index-prod-server.html";
            stringArray = stringArray4;
            stringArray4[1] = "index.html";
        }
        stringArray2 = stringArray;
        bl2 = iServerSettings.isDirectoryListingAllowed();
        bl = iServerSettings.useGzip();
        object = new f(stringArray2, file2);
        object.setInitParameter("dirAllowed", Boolean.toString(bl2));
        object.setInitParameter("etags", "true");
        object.setInitParameter("stylesheet", "/iz/css/dir.css");
        if (bl) {
            object.setInitParameter("gzip", "true");
            object.setInitParameter("precompressed", "gzip=.gz");
        }
        file = WSHelper.a(this.a, bl2, bl, iExternalBrowserPages, iCommonServletInterfaceArray);
        object.addServlet((ServletHolder)file, "/");
        h.a((ServletContextHandler)object, webSocketAcceptor);
        Handler.Sequence sequence2 = new Handler.Sequence(false, List.of());
        j j2 = new j(this.a, bl2, (Map<String, File>)this.a, (Map<File, File>)this.b, this.a, iExternalBrowserPages);
        sequence2.addHandler((Handler)j2);
        ServletContextHandler servletContextHandler = null;
        if (this.a != null && this.a.isFileUploadEnabled()) {
            sequence = new ServletHolder((Servlet)new UploadServlet(this.a));
            servletContextHandler = new ServletContextHandler("/|izupload", false, false);
            String string2 = this.a.getFileUploadStagingDirectory();
            long l = 1000000L * (long)this.a.getMaximumUploadFileSize();
            long l2 = 16L * l;
            int n = 0;
            sequence.getRegistration().setMultipartConfig(new MultipartConfigElement(string2, l, l2, n));
            servletContextHandler.addServlet((ServletHolder)sequence, "/");
            sequence2.addHandler((Handler)servletContextHandler);
        }
        sequence2.addHandler((Handler)object);
        sequence2.addHandler((Handler)new DefaultHandler());
        sequence = bl ? WSHelper.a((Handler)sequence2) : sequence2;
        int n = nArray[0];
        if (n > 0) {
            SecuredRedirectHandler securedRedirectHandler = new SecuredRedirectHandler(n);
            securedRedirectHandler.setHandler((Handler)sequence);
            sequence = securedRedirectHandler;
        }
        this.a = new StatisticsHandler((Handler)sequence);
        server.setHandler((Handler)this.a);
        int n2 = iServerSettings.getWSLogsRetainDays();
        if (n2 > 0 && (string = iServerSettings.getWSLogDirectory()) != null) {
            RequestLogWriter requestLogWriter = new RequestLogWriter(new File(string, "http-yyyy_MM_dd.request.log").toString());
            requestLogWriter.setRetainDays(n2);
            requestLogWriter.setTimeZone("GMT");
            server.setRequestLog((RequestLog)new CustomRequestLog((RequestLog.Writer)requestLogWriter, "%{client}a - %u %t \"%r\" %s %O \"%{Referer}i\" \"%{User-Agent}i\""));
        }
        this.a = WSHelper.a(server, () -> {
            this.server = null;
        });
        if (this.a == null) {
            throw new IOException("Failed starting web server thread");
        }
        ILog.INFO(this.getClass(), (String)("Web server ready, root \"" + this.a + "\""));
        this.server = server;
        return this.a;
    }

    public boolean stopWebServer(long l) {
        return WSHelper.a(this.server, this.a, l);
    }

    public void addFileRedirection(String string, File file) {
        this.a.put(string, file);
    }

    public void addFileRedirection(File file, File file2) {
        this.b.put(file, file2);
    }

    public KString getStatistics() {
        StringBuilder stringBuilder = new StringBuilder("Statistics:");
        try {
            StatisticsHandler statisticsHandler = this.a;
            if (statisticsHandler != null) {
                statisticsHandler.dump((Appendable)stringBuilder, "\n - ");
            } else {
                stringBuilder.append("\n\n*** Web server is not started ***");
            }
        }
        catch (IOException iOException) {
            ILog.WARNING(this.getClass(), (String)"Failed getting web server statistics", (Throwable)iOException);
            stringBuilder.append("\n\n*** Failed getting web server statistics: " + String.valueOf(iOException));
        }
        return KString.newPlainKString((String)stringBuilder.toString());
    }
}

