/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.junit.util;

import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.internal.junit.Messages;
import org.eclipse.jdt.internal.junit.launcher.ITestKind;
import org.eclipse.jdt.internal.junit.launcher.TestKind;
import org.eclipse.jdt.internal.junit.ui.JUnitMessages;
import org.eclipse.jdt.internal.junit.util.CoreTestSearchEngine;
import org.eclipse.jdt.internal.junit.util.JUnitStubUtility;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;

public class TestSearchEngine
extends CoreTestSearchEngine {
    public static Set<IType> findTests(IRunnableContext context, IJavaElement element, ITestKind testKind) throws InvocationTargetException, InterruptedException {
        HashSet<IType> result = new HashSet<IType>();
        IRunnableWithProgress runnable = progressMonitor -> {
            try {
                testKind.getFinder().findTestsInContainer(element, result, progressMonitor);
            }
            catch (CoreException e) {
                throw new InvocationTargetException(e);
            }
        };
        context.run(true, true, runnable);
        return result;
    }

    public static Set<String> findTestMethods(IRunnableContext context, IJavaProject javaProject, IType type, TestKind testKind) throws InvocationTargetException, InterruptedException {
        HashSet<String> result = new HashSet<String>();
        IRunnableWithProgress runnable = progressMonitor -> {
            try {
                String message = Messages.format((String)JUnitMessages.TestSearchEngine_search_message_progress_monitor, (Object)type.getElementName());
                SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)progressMonitor, (String)message, (int)1);
                TestSearchEngine.collectMethodNames(type, javaProject, testKind.getId(), result, (IProgressMonitor)subMonitor.split(1));
            }
            catch (CoreException e) {
                throw new InvocationTargetException(e);
            }
        };
        context.run(true, true, runnable);
        return result;
    }

    private static void collectMethodNames(IType type, IJavaProject javaProject, String testKindId, Set<String> methodNames, IProgressMonitor monitor) throws JavaModelException {
        if (type == null) {
            return;
        }
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)3);
        TestSearchEngine.collectDeclaredMethodNames(type, javaProject, testKindId, methodNames);
        subMonitor.split(1);
        String superclassName = type.getSuperclassName();
        IType superType = TestSearchEngine.getResolvedType(superclassName, type, javaProject);
        TestSearchEngine.collectMethodNames(superType, javaProject, testKindId, methodNames, (IProgressMonitor)subMonitor.split(1));
        String[] superInterfaceNames = type.getSuperInterfaceNames();
        subMonitor.setWorkRemaining(superInterfaceNames.length);
        String[] stringArray = superInterfaceNames;
        int n = superInterfaceNames.length;
        int n2 = 0;
        while (n2 < n) {
            String interfaceName = stringArray[n2];
            superType = TestSearchEngine.getResolvedType(interfaceName, type, javaProject);
            TestSearchEngine.collectMethodNames(superType, javaProject, testKindId, methodNames, (IProgressMonitor)subMonitor.split(1));
            ++n2;
        }
    }

    private static IType getResolvedType(String typeName, IType type, IJavaProject javaProject) throws JavaModelException {
        IType resolvedType = null;
        if (typeName != null) {
            String[][] resolvedTypeNames;
            int pos = typeName.indexOf(60);
            if (pos != -1) {
                typeName = typeName.substring(0, pos);
            }
            if ((resolvedTypeNames = type.resolveType(typeName)) != null && resolvedTypeNames.length > 0) {
                String[] resolvedTypeName = resolvedTypeNames[0];
                resolvedType = javaProject.findType(resolvedTypeName[0], resolvedTypeName[1]);
            }
        }
        return resolvedType;
    }

    private static void collectDeclaredMethodNames(IType type, IJavaProject javaProject, String testKindId, Set<String> methodNames) throws JavaModelException {
        IMethod[] methods;
        IMethod[] iMethodArray = methods = type.getMethods();
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            IMethod method = iMethodArray[n2];
            String methodName = method.getElementName();
            int flags = method.getFlags();
            if (Modifier.isPublic((int)flags) && !Modifier.isStatic((int)flags) && method.getNumberOfParameters() == 0 && "V".equals(method.getReturnType()) && methodName.startsWith("test")) {
                methodNames.add(methodName);
            }
            boolean isJUnit3 = "org.eclipse.jdt.junit.loader.junit3".equals(testKindId);
            boolean isJUnit5 = "org.eclipse.jdt.junit.loader.junit5".equals(testKindId);
            if (!(isJUnit3 || Modifier.isPrivate((int)flags) || Modifier.isStatic((int)flags))) {
                IAnnotation annotation = method.getAnnotation("Test");
                if (annotation.exists()) {
                    methodNames.add(methodName + JUnitStubUtility.getParameterTypes(method, false));
                } else if (isJUnit5) {
                    boolean hasAnyTestAnnotation;
                    boolean bl = hasAnyTestAnnotation = method.getAnnotation("TestFactory").exists() || method.getAnnotation("Testable").exists() || method.getAnnotation("TestTemplate").exists() || method.getAnnotation("ParameterizedTest").exists() || method.getAnnotation("RepeatedTest").exists();
                    if (hasAnyTestAnnotation || TestSearchEngine.isAnnotatedWithTestable(method, type, javaProject)) {
                        methodNames.add(methodName + JUnitStubUtility.getParameterTypes(method, false));
                    }
                }
            }
            ++n2;
        }
    }

    private static boolean isAnnotatedWithTestable(IMethod method, IType declaringType, IJavaProject javaProject) throws JavaModelException {
        IAnnotation[] iAnnotationArray = method.getAnnotations();
        int n = iAnnotationArray.length;
        int n2 = 0;
        while (n2 < n) {
            IAnnotation annotation = iAnnotationArray[n2];
            IType annotationType = TestSearchEngine.getResolvedType(annotation.getElementName(), declaringType, javaProject);
            if (annotationType != null) {
                if (TestSearchEngine.matchesTestable(annotationType)) {
                    return true;
                }
                HashSet<IType> hierarchy = new HashSet<IType>();
                if (TestSearchEngine.matchesTestableInAnnotationHierarchy(annotationType, javaProject, hierarchy)) {
                    return true;
                }
            }
            ++n2;
        }
        return false;
    }

    private static boolean matchesTestable(IType annotationType) {
        return annotationType != null && "org.junit.platform.commons.annotation.Testable".equals(annotationType.getFullyQualifiedName());
    }

    private static boolean matchesTestableInAnnotationHierarchy(IType annotationType, IJavaProject javaProject, Set<IType> hierarchy) throws JavaModelException {
        if (annotationType != null) {
            IAnnotation[] iAnnotationArray = annotationType.getAnnotations();
            int n = iAnnotationArray.length;
            int n2 = 0;
            while (n2 < n) {
                IAnnotation annotation = iAnnotationArray[n2];
                IType annType = TestSearchEngine.getResolvedType(annotation.getElementName(), annotationType, javaProject);
                if (annType != null && hierarchy.add(annType) && (TestSearchEngine.matchesTestable(annType) || TestSearchEngine.matchesTestableInAnnotationHierarchy(annType, javaProject, hierarchy))) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }
}

