/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.parts;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.text.StringMatcher;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.dialogs.FilteredList;

public class ConditionalListSelectionDialog
extends ElementListSelectionDialog {
    private final String fButtonText;
    private Object[] fElements;
    private Object[] fConditionalElements;

    public ConditionalListSelectionDialog(Shell parent, ILabelProvider renderer, String buttonText) {
        super(parent, renderer);
        this.fButtonText = buttonText;
    }

    protected Control createDialogArea(Composite parent) {
        Composite comp = (Composite)super.createDialogArea(parent);
        int size = (this.fElements != null ? this.fElements.length : 0) + (this.fConditionalElements != null ? this.fConditionalElements.length : 0);
        Object[] allElements = new Object[size];
        int conditionalStart = 0;
        if (this.fElements != null) {
            System.arraycopy(this.fElements, 0, allElements, 0, this.fElements.length);
            conditionalStart = this.fElements.length;
        }
        if (this.fConditionalElements != null) {
            System.arraycopy(this.fConditionalElements, 0, allElements, conditionalStart, this.fConditionalElements.length);
        }
        Button button = new Button(comp, 32);
        Assert.isNotNull((Object)this.fButtonText);
        button.setText(this.fButtonText);
        button.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            if (button.getSelection()) {
                this.setListElements(allElements);
            } else {
                this.setListElements(this.fElements);
            }
        }));
        return comp;
    }

    public void setElements(Object[] elements) {
        super.setElements(elements);
        this.fElements = elements;
    }

    protected void updateOkState() {
        super.updateOkState();
        Button ok = this.getOkButton();
        if (ok != null && !ok.isEnabled() && this.fElements != null) {
            ok.setEnabled(this.fElements.length != 0);
        }
    }

    public void setConditionalElements(Object[] elements) {
        this.fConditionalElements = elements;
    }

    protected FilteredList createFilteredList(Composite parent) {
        final FilteredList list = super.createFilteredList(parent);
        list.setFilterMatcher(new FilteredList.FilterMatcher(){
            private StringMatcher fMatcher;

            public void setFilter(String pattern, boolean ignoreCase, boolean ignoreWildCards) {
                this.fMatcher = new StringMatcher("*" + pattern + "*", ignoreCase, ignoreWildCards);
            }

            public boolean match(Object element) {
                return this.fMatcher.match(list.getLabelProvider().getText(element));
            }
        });
        return list;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, PDEUIMessages.ManifestEditor_addActionText, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }
}

