/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.prop;

import com.iizix.ReadTransaction;
import com.iizix.SendTransaction;
import com.iizix.prop.Atom;
import com.iizix.prop.DoubleProp;
import com.iizix.prop.PropException;
import com.iizix.prop.PropMgr;
import com.iizix.prop.PropValidateException;

public class NumberProp
extends DoubleProp {
    protected NumberProp() {
    }

    public NumberProp(Atom atom) {
        super(atom);
    }

    public NumberProp(Atom atom, double d2) throws PropValidateException {
        super(atom, d2);
    }

    @Override
    protected void appendPropValue(PropMgr propMgr, SendTransaction sendTransaction, Object object) {
        String string;
        Double d2 = (Double)this.getPropValue();
        if (d2 == null) {
            string = "";
        } else {
            long l2 = d2.longValue();
            string = d2 == (double)l2 ? Long.toString(l2) : d2.toString();
        }
        sendTransaction.appendString(string);
    }

    @Override
    public boolean initializeValue(PropMgr propMgr, ReadTransaction readTransaction) throws PropException {
        String string = readTransaction.readString();
        try {
            Double d2 = string.isEmpty() ? null : Double.valueOf(string);
            return this.setPropValue((Object)d2, propMgr);
        }
        catch (NumberFormatException numberFormatException) {
            throw new PropException(this, "Failed conversion of String for NumberProp '" + string + "'", numberFormatException);
        }
    }
}

