/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.prop;

import com.iizix.ReadTransaction;
import com.iizix.SendTransaction;
import com.iizix.prop.Atom;
import com.iizix.prop.GProp;
import com.iizix.prop.PropException;
import com.iizix.prop.PropMgr;
import com.iizix.prop.PropTypeException;
import com.iizix.prop.PropValidateException;

public class DoubleProp
extends GProp<Double> {
    private static final Class<?>[] a = new Class[]{Double.class, Float.class, Long.class, Integer.class, Short.class, Byte.class, String.class, Character.class};

    protected DoubleProp() {
    }

    public DoubleProp(Atom atom) {
        super(atom);
    }

    public DoubleProp(Atom atom, double d2) throws PropValidateException {
        super(atom);
        this.setPropValue(d2);
    }

    @Override
    public Class<?>[] getValueClasses() {
        return a;
    }

    public boolean setPropValue(double d2) throws PropValidateException {
        try {
            return super.setPropValue(d2);
        }
        catch (PropException propException) {
            if (propException instanceof PropValidateException) {
                throw (PropValidateException)propException;
            }
            throw new InternalError(propException.getMessage(), propException);
        }
    }

    @Override
    public void validatePropType(Object object) throws PropTypeException {
        if (!(object instanceof Double)) {
            throw new PropTypeException(this, "newValue not Double");
        }
    }

    public double getDouble() {
        return this.getDouble(-1.0);
    }

    public double getDouble(double d2) {
        Double d3 = (Double)this.getPropValue();
        return d3 == null ? d2 : d3;
    }

    @Override
    protected void appendPropValue(PropMgr propMgr, SendTransaction sendTransaction, Object object) {
        Double d2 = (Double)this.getPropValue();
        sendTransaction.appendDouble(d2 == null ? -1.0 : d2);
    }

    @Override
    public boolean initializeValue(PropMgr propMgr, ReadTransaction readTransaction) throws PropException {
        return this.setPropValue((Object)readTransaction.readDouble(), propMgr);
    }

    @Override
    public Object fromElementString(String string) throws PropException {
        try {
            return Double.valueOf(string);
        }
        catch (Exception exception) {
            return this.convertPropError(string, exception);
        }
    }

    @Override
    protected Object getPropValue0(Object object, int n2) throws Exception {
        Double d2 = (double)((Double)object);
        switch (n2) {
            case 1: {
                return Float.valueOf(d2.floatValue());
            }
            case 2: {
                return d2.longValue();
            }
            case 3: {
                if (d2 < 2.147483647E9 || d2 > 2.147483647E9) {
                    throw new IllegalArgumentException("Range error for Integer value:" + String.valueOf(d2));
                }
                return d2.intValue();
            }
            case 4: {
                if (d2 < 32767.0 || d2 > 32767.0) {
                    throw new IllegalArgumentException("Range error for Short value:" + String.valueOf(d2));
                }
                return d2.shortValue();
            }
            case 5: {
                if (d2 < 127.0 || d2 > 127.0) {
                    throw new IllegalArgumentException("Range error for Byte value:" + String.valueOf(d2));
                }
                return d2.byteValue();
            }
            case 6: {
                return object.toString();
            }
            case 7: {
                if (d2 < 0.0 || d2 > 65535.0) {
                    throw new IllegalArgumentException("Range error for Character value:" + String.valueOf(d2));
                }
                return Character.valueOf((char)d2.intValue());
            }
        }
        throw new IllegalArgumentException("invalid index: " + n2);
    }

    @Override
    protected Object toNativeValue0(Object object, int n2) throws Exception {
        double d2;
        switch (n2) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                d2 = ((Number)object).doubleValue();
                break;
            }
            case 6: {
                return Double.valueOf((String)object);
            }
            case 7: {
                d2 = ((Character)object).charValue();
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid index: " + n2);
            }
        }
        return d2;
    }
}

