/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.bnd.ui.autocomplete;

import aQute.bnd.help.Syntax;
import java.util.ArrayList;
import java.util.Collections;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ContextInformation;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.swt.custom.StyledText;

public class BndCompletionProcessor
implements IContentAssistProcessor {
    private static final Pattern PREFIX_PATTERN = Pattern.compile("(\\S+)$");

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        try {
            String pre;
            Matcher matcher;
            IDocument document = viewer.getDocument();
            IRegion lineInfo = document.getLineInformationOfOffset(offset);
            if (this.isCommentLine(document, lineInfo) || this.isInstructionLine(document, lineInfo) || this.isContinuationLine(document, lineInfo, false)) {
                return new ICompletionProposal[0];
            }
            if (lineInfo.getOffset() != offset && (matcher = PREFIX_PATTERN.matcher(pre = document.get(0, offset))).find()) {
                StyledText widget;
                String prefix = matcher.group(1);
                ICompletionProposal[] found = BndCompletionProcessor.proposals(prefix, offset);
                if (found.length == 1 && (widget = viewer.getTextWidget()) != null) {
                    widget.getDisplay().execute(() -> {
                        if (widget.isDisposed()) {
                            return;
                        }
                        found[0].apply(document);
                        viewer.setSelectedRange(offset + (found[0].getDisplayString().length() - prefix.length() + 2), 0);
                    });
                    return new ICompletionProposal[0];
                }
                return found;
            }
            return BndCompletionProcessor.proposals(null, offset);
        }
        catch (BadLocationException e) {
            return BndCompletionProcessor.proposals(null, offset);
        }
    }

    private boolean isContinuationLine(IDocument document, IRegion lineInfo, boolean onlyCurrent) {
        int o;
        block5: {
            block4: {
                o = lineInfo.getOffset();
                int l = lineInfo.getLength();
                try {
                    String line = document.get(o, l);
                    if (!line.trim().endsWith("\\")) break block4;
                    return true;
                }
                catch (BadLocationException e) {
                    return false;
                }
            }
            if (!onlyCurrent) break block5;
            return false;
        }
        return this.isContinuationLine(document, document.getLineInformationOfOffset(o - 1), true);
    }

    private boolean isInstructionLine(IDocument document, IRegion lineInfo) {
        int o = lineInfo.getOffset();
        int l = lineInfo.getLength();
        try {
            String line = document.get(o, l);
            return line.indexOf(58) > -1 || line.indexOf(61) > -1;
        }
        catch (BadLocationException e) {
            return false;
        }
    }

    protected boolean isCommentLine(IDocument document, IRegion lineInfo) {
        int o = lineInfo.getOffset();
        int l = lineInfo.getLength();
        try {
            return document.get(o, l).startsWith("#");
        }
        catch (BadLocationException e) {
            return false;
        }
    }

    private static ICompletionProposal[] proposals(String prefix, int offset) {
        ArrayList<CompletionProposal> results = new ArrayList<CompletionProposal>(Syntax.HELP.size());
        for (Syntax s : Syntax.HELP.values()) {
            if (prefix != null && !s.getHeader().startsWith(prefix)) continue;
            ContextInformation info = new ContextInformation(s.getHeader(), s.getHeader());
            String text = prefix == null ? s.getHeader() : s.getHeader().substring(prefix.length());
            results.add(new CompletionProposal(text + ": ", offset, 0, text.length() + 2, null, s.getHeader(), (IContextInformation)info, s.getLead()));
        }
        Collections.sort(results, (p1, p2) -> p1.getDisplayString().compareTo(p2.getDisplayString()));
        return results.toArray(new ICompletionProposal[0]);
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        return null;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return new char[]{'-'};
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return new char[]{'-'};
    }

    public IContextInformationValidator getContextInformationValidator() {
        return null;
    }

    public String getErrorMessage() {
        return null;
    }
}

