/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.prop.font;

import com.iizix.ILog;
import com.iizix.SendTransaction;
import com.iizix.event.PropValueEvent;
import com.iizix.prop.AssetReference;
import com.iizix.prop.Atom;
import com.iizix.prop.FileURIPropCnr;
import com.iizix.prop.IAssetReferenceListener;
import com.iizix.prop.PreloadClientCacheResource;
import com.iizix.prop.PropCnr;
import com.iizix.prop.font.FontFilePreloadClientCacheResource;
import com.iizix.prop.font.FontFiles;
import com.iizix.prop.font.FontFormat;

public class FontFile
extends PropCnr
implements IAssetReferenceListener {
    public static final String FORMAT = "format";
    public static final String QUERY = "query";
    private PreloadClientCacheResource[] a;

    public FontFile() {
    }

    public FontFile(Atom atom) {
        super(atom);
    }

    public AssetReference getAssetReference() {
        return this.getProp(Atom.FILENAME, AssetReference.class);
    }

    @Override
    public void onAssetReferenceChanged(AssetReference assetReference) {
        PropCnr propCnr = this;
        while ((propCnr = propCnr.getParent()) != null) {
            if (!(propCnr instanceof FileURIPropCnr)) continue;
            Object VALUE = assetReference.getPropValue();
            propCnr.onEvent(new PropValueEvent(assetReference, VALUE, VALUE));
            break;
        }
    }

    public FontFormat getFormat() {
        int n2 = this.getInt(FORMAT);
        if (n2 <= 0) {
            return FontFormat.UNDEFINED;
        }
        FontFormat[] fontFormatArray = FontFormat.values();
        return n2 < fontFormatArray.length ? fontFormatArray[n2] : FontFormat.UNDEFINED;
    }

    public String getQuertPart() {
        return this.getString(QUERY);
    }

    public String getClientResourceString() {
        AssetReference assetReference = this.getAssetReference();
        return assetReference != null ? assetReference.getClientResourceString() : null;
    }

    public String getFontFamily() {
        PropCnr propCnr = this.getParent();
        return propCnr instanceof FontFiles ? ((FontFiles)propCnr).getFontFamily() : "undefined";
    }

    public void appendFontData(SendTransaction sendTransaction) {
        Object object;
        boolean bl = this.getParent(FontFiles.class).a(sendTransaction);
        Object object2 = null;
        String string = "";
        String string2 = "";
        String string3 = "";
        AssetReference assetReference = this.getAssetReference();
        if (assetReference != null) {
            object = (FileURIPropCnr)assetReference.getTargetReference();
            if (object != null) {
                string = ((FileURIPropCnr)object).getClientResourceString();
                long l2 = ((FileURIPropCnr)object).getModificationTime();
                if (l2 > 0L) {
                    string3 = Long.toString(l2 / 1000L);
                    long l3 = ((FileURIPropCnr)object).getSize();
                    if (l3 >= 0L) {
                        string2 = Long.toString(l3);
                    } else {
                        object2 = "resource not found (file size): " + String.valueOf(((FileURIPropCnr)object).getURL());
                    }
                } else {
                    object2 = "resource not found (last modification time): " + String.valueOf(((FileURIPropCnr)object).getURL());
                }
            } else {
                object2 = "asset reference not found: " + assetReference.getReference();
            }
        } else {
            object2 = "asset reference undefined";
        }
        sendTransaction.appendString(string);
        object = this.getFormat();
        sendTransaction.appendString(object != FontFormat.UNDEFINED ? ((FontFormat)((Object)object)).type : "");
        if (bl) {
            sendTransaction.appendString(string2);
            sendTransaction.appendString(string3);
        }
        if (object2 != null) {
            ILog.WARNING(this.getClass(), "Font '" + this.getFontFamily() + "' in " + this.getReferencePropName() + " file resource: " + (String)object2);
        } else {
            ILog.INFO(this.getClass(), "Font '" + this.getFontFamily() + "' in " + this.getReferencePropName() + " file resource installed: url = " + string + ", size = " + string2 + ", time = " + string3);
        }
    }

    public PreloadClientCacheResource[] getPreloadClientCacheResources() {
        FileURIPropCnr fileURIPropCnr;
        AssetReference assetReference;
        PreloadClientCacheResource[] preloadClientCacheResourceArray = this.a;
        if (preloadClientCacheResourceArray == null && (assetReference = this.getAssetReference()) != null && (fileURIPropCnr = (FileURIPropCnr)assetReference.getTargetReference()) != null && fileURIPropCnr.getSize() >= 0L && fileURIPropCnr.getModificationTime() > 0L) {
            this.a = new PreloadClientCacheResource[]{new FontFilePreloadClientCacheResource(assetReference, fileURIPropCnr)};
            preloadClientCacheResourceArray = this.a;
        }
        return preloadClientCacheResourceArray;
    }
}

