--------------------------------------------------------------------------------------------------------------


-- DEVICE

-- The device represents a device configuration at a particular time and is always associated with a user ID.

CREATE TABLE IZS.DEVICE (
 dev_id      BIGINT       NOT NULL PRIMARY KEY GENERATED BY DEFAULT AS IDENTITY, -- Device ID
 uid         BIGINT       NOT NULL  ,  -- User ID
 device_uuid CHAR(20)     NOT NULL  ,  -- Device UUID (version 4)
 created     BIGINT       NOT NULL  ,  -- Date in epoch (GMT) milliseconds when device entry was first created.
 ip_address  VARCHAR(41)  NOT NULL  ,  -- Max: IPv6 address [1234:5678:0123:4567:1234:5678:0123:4567]
 longitude   DOUBLE                 ,  -- If non-NULL, the longitude of the IP address or the user's location when accepted
 latitude    DOUBLE                 ,  -- If non-NULL, the latitude of the IP address or the user's location when accepted
 json_gz     BLOB(16M)    NOT NULL  ,  -- Max 16 MB data in packed GZIP JSON format
 FOREIGN KEY (uid) REFERENCES IZS.USERS(uid)     ON DELETE CASCADE
);

CREATE INDEX user_devices ON IZS.DEVICE(uid, device_uuid);


-- USER SESSION

-- The user session indicates when a user is signed in or out of an application, and device was used and where. 

CREATE TABLE IZS.USER_SESSION (
 uid        BIGINT         NOT NULL,  -- User ID
 active     BOOLEAN        NOT NULL DEFAULT TRUE,  -- The active state of session: TRUE means signed in, FALSE means signed out.
 anid       BIGINT         NOT NULL,  -- App numeric ID, -1 for system
 act_ts     BIGINT         NOT NULL,  -- Activity timestamp, milliseconds since epoch in GMT
 act_group  VARCHAR(64)    NOT NULL,  -- Activity group string
 act_descr  VARCHAR(1024)          ,  -- Activity description string, NULL for none.
 FOREIGN KEY (uid)  REFERENCES IZS.USERS       (uid)  ON DELETE CASCADE,
 FOREIGN KEY (anid) REFERENCES IZS.APP_INSTANCE(anid) ON DELETE CASCADE
);

CREATE INDEX user_sessions ON IZS.IZS.USER_SESSION(uid, active, act_ts, act_group);


-- USER ACTIVITY

-- The user activity done with an application, where the 
-- The 'anid' App numeric unique ID can be set to -1 in case it is not application related, but rather with the system. 

CREATE TABLE IZS.USER_ACT (
 uid     BIGINT         NOT NULL,  -- User ID
 anid    BIGINT         NOT NULL,  -- App numeric ID, -1 for system
 act_ts  BIGINT         NOT NULL,  -- Activity timestamp, milliseconds since epoch in GMT
 act_group  VARCHAR(64) NOT NULL,  -- Activity group string
 act_descr  VARCHAR(1024)       ,  -- Activity description string, NULL for none.
 FOREIGN KEY (uid)  REFERENCES IZS.USERS       (uid)  ON DELETE CASCADE,
 FOREIGN KEY (anid) REFERENCES IZS.APP_INSTANCE(anid) ON DELETE CASCADE
);

CREATE INDEX user_activities ON IZS.USER_ACT(uid, anid, act_ts, act_group);