/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.server.wsfile;

import com.iizix.ILog;
import com.iizix.gyro.IAppSessionGyro;
import com.iizix.image.ImageType;
import com.iizix.server.ServerShell;
import com.iizix.server.wsfile.b;
import com.iizix.virtual.VirtualThreads;
import com.iizix.wsfile.IWSFileDownload;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.StandardCopyOption;
import java.util.Locale;
import java.util.Objects;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public final class WSFileDownload
implements IWSFileDownload {
    private final URL a;
    private final Object a;
    private final String a;
    private Throwable a;
    private File a;
    private boolean a;

    WSFileDownload(URL uRL, Object object, String string) {
        this.a = Objects.requireNonNull(uRL);
        this.a = object;
        if (string.length() > 128) {
            throw new IllegalArgumentException("description length > 128");
        }
        this.a = string;
    }

    public URL getURL() {
        return this.a;
    }

    public Object getID() {
        return this.a;
    }

    public String getDescription() {
        return this.a;
    }

    void a(IAppSessionGyro iAppSessionGyro, File file, b b2, Runnable runnable) {
        if (iAppSessionGyro == null) {
            VirtualThreads.getVirtualThreads().startThread(() -> this.a(file, b2, runnable), "WSFileDownload", 4);
        } else {
            iAppSessionGyro.getAppThreadGroup().startThread(() -> this.a(file, b2, runnable), "WSFileDownload", 4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a(File file, b b2, Runnable runnable) {
        block29: {
            File file2 = null;
            try {
                try {
                    ImageType imageType;
                    Object object;
                    String string;
                    int n;
                    URLConnection uRLConnection = this.a.openConnection();
                    if (uRLConnection instanceof HttpURLConnection) {
                        ServerShell.getInstance().configureProxy((HttpURLConnection)uRLConnection);
                    }
                    if ((n = (string = this.a.getPath()).lastIndexOf(47)) >= 0) {
                        string = string.substring(n + 1);
                    }
                    String string2 = "";
                    n = string.lastIndexOf(46);
                    if (n >= 3) {
                        string2 = string.substring(n);
                        string = string.substring(0, n);
                    } else {
                        object = uRLConnection.getHeaderField("Content-Type");
                        if (object != null) {
                            imageType = ImageType.fromMediaType((String)((String)object).toLowerCase(Locale.ENGLISH));
                            if (imageType == null || imageType == ImageType.ALL_IMAGES) {
                                throw new IOException("Unknown image type '" + (String)object + "' downloaded from " + String.valueOf(this.a));
                            }
                            string2 = imageType.firstExtension;
                        }
                    }
                    file2 = b2 != null ? b2.a(this.a, "download" + string2) : File.createTempFile(string, string2, file);
                    object = null;
                    imageType = null;
                    try (InputStream inputStream = uRLConnection.getInputStream();){
                        Files.copy(inputStream, file2.toPath(), StandardCopyOption.REPLACE_EXISTING);
                        WSFileDownload wSFileDownload = this;
                        synchronized (wSFileDownload) {
                            if (this.a) {
                                throw new InterruptedIOException("File download has been disposed of");
                            }
                            this.a = file2;
                            file2 = null;
                        }
                    }
                    catch (Throwable throwable) {
                        if (object == null) {
                            object = throwable;
                        } else if (object != throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                        throw object;
                    }
                    if (b2 != null) {
                        b2.a(this.a, file2, this.a, true);
                    }
                }
                catch (Throwable throwable) {
                    this.a = throwable;
                    ILog.WARNING(this.getClass(), (String)"File download failed", (Object[])new Object[]{"URL = " + String.valueOf(this.a), "Root directory = " + file.getPath(), "Error = " + throwable.getMessage()});
                    if (file2 != null) {
                        try {
                            Files.delete(file2.toPath());
                        }
                        catch (IOException | InvalidPathException exception) {
                            ILog.WARNING(this.getClass(), (String)("Failed cleaning up temporary file " + file2.getAbsolutePath() + ": " + exception.getMessage()));
                        }
                    }
                    runnable.run();
                    break block29;
                }
            }
            catch (Throwable throwable) {
                runnable.run();
                throw throwable;
            }
            runnable.run();
        }
        ILog.FINE(this.getClass(), (String)("Downloaded file " + String.valueOf(this.a) + ", size = " + this.a.length() + " bytes"));
    }

    public synchronized void dispose() {
        this.a = true;
    }

    public synchronized boolean isDisposed() {
        return this.a;
    }

    public File getFile() {
        return this.a;
    }

    public Throwable getException() {
        return this.a;
    }

    public String toString() {
        String string = this.getClass().getName() + "[url=" + String.valueOf(this.a) + ",description=" + this.a;
        if (this.a != null) {
            string = string + ",id=" + String.valueOf(this.a);
        }
        if (this.a != null) {
            string = string + ",file=" + String.valueOf(this.a);
        }
        if (this.a != null) {
            string = string + ",exception=" + String.valueOf(this.a);
        }
        if (this.a) {
            string = string + ",disposed";
        }
        return string + "]";
    }
}

