/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.run.common;

import com.iizix.ILog;
import com.iizix.IPrintAdapter;
import com.iizix.IPropProgressMonitor;
import com.iizix.Loggers;
import com.iizix.PropProgressMonitor;
import com.iizix.RunMode;
import com.iizix.Utilities;
import com.iizix.run.common.BuildEnvironment;
import com.iizix.run.common.CommonBuilder;
import com.iizix.run.common.ICommonJobs;
import com.iizix.run.common.c;
import com.iizix.virtual.IVirtualThreads;
import com.iizix.virtual.VirtualThreads;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.concurrent.ThreadFactory;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteStreamHandler;
import org.apache.commons.exec.ExecuteWatchdog;
import org.apache.commons.exec.ProcessDestroyer;
import org.apache.commons.exec.ShutdownHookProcessDestroyer;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class CommonJobs
implements ICommonJobs {
    private static final ShutdownHookProcessDestroyer a = new ShutdownHookProcessDestroyer();
    private boolean a;
    private boolean b;
    private boolean c;
    final IPropProgressMonitor a;
    private ExecuteWatchdog a;
    private final IPrintAdapter a;
    private boolean d;

    CommonJobs() {
        this(null, null, false);
    }

    public CommonJobs(IPropProgressMonitor iPropProgressMonitor, boolean bl) {
        this(null, IPrintAdapter.DEFAULT, bl);
    }

    public CommonJobs(IPropProgressMonitor iPropProgressMonitor, IPrintAdapter iPrintAdapter, boolean bl) {
        this.a = iPropProgressMonitor;
        this.a = iPrintAdapter;
        this.a = this.b = bl;
        if (iPropProgressMonitor instanceof PropProgressMonitor) {
            ((PropProgressMonitor)iPropProgressMonitor).setListener(() -> this.destroyProcess());
        }
    }

    @Override
    public void destroyProcess() {
        ExecuteWatchdog executeWatchdog = this.a;
        this.a = null;
        this.d = true;
        if (executeWatchdog != null) {
            executeWatchdog.destroyProcess();
        }
    }

    @Override
    public void downloadFile(String string, File file) throws IOException, InterruptedException {
        this.a(this.a, string, file);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void a(IPropProgressMonitor iPropProgressMonitor, String string, File file) throws IOException, InterruptedException {
        URL uRL;
        file = file.getCanonicalFile();
        String string2 = "Downloading " + string + " to " + String.valueOf(file);
        ILog.INFO(CommonBuilder.class, (String)string2);
        iPropProgressMonitor.beginTask(string2, 1000);
        boolean bl = true;
        try {
            uRL = new URI(string).toURL();
        }
        catch (Exception exception) {
            throw new IOException("File " + string + " is not in correct URI format", exception);
        }
        try {
            try {
                HttpURLConnection httpURLConnection = null;
                URLConnection uRLConnection = uRL.openConnection();
                if (uRLConnection instanceof HttpURLConnection) {
                    httpURLConnection = (HttpURLConnection)uRLConnection;
                    RunMode.getWebServiceConfigurator().configureProxy(httpURLConnection);
                }
                byte[] byArray = new byte[16384];
                Throwable throwable = null;
                Object var11_15 = null;
                try {
                    BufferedInputStream bufferedInputStream = new BufferedInputStream(uRLConnection.getInputStream());
                    try {
                        try (BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));){
                            long l = httpURLConnection != null ? httpURLConnection.getContentLengthLong() : -1L;
                            long l2 = 0L;
                            long l3 = 0L;
                            int n = 0;
                            while (true) {
                                int n2;
                                long l4;
                                if (iPropProgressMonitor.isCanceled()) {
                                    throw new InterruptedException("Download canceled: " + string);
                                }
                                int n3 = bufferedInputStream.read(byArray);
                                if (n3 < 0) break;
                                if (n3 <= 0) continue;
                                bufferedOutputStream.write(byArray, 0, n3);
                                if (l < 0L || (l4 = 1000L * (l2 += (long)n3) / l) == l3) continue;
                                l3 = l4;
                                iPropProgressMonitor.setWorked((int)l3);
                                if (!this.b || n == (n2 = (int)l3 / 10)) continue;
                                n = n2;
                            }
                            ILog.FINE(this.getClass(), (String)("Downloaded file " + String.valueOf(uRL) + ", size = " + Utilities.getEnglishSize((long)l2)));
                            bl = false;
                        }
                        if (bufferedInputStream == null) return;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        if (bufferedInputStream == null) throw throwable;
                        bufferedInputStream.close();
                        throw throwable;
                    }
                    bufferedInputStream.close();
                    return;
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                        throw throwable;
                    } else {
                        if (throwable == throwable3) throw throwable;
                        throwable.addSuppressed(throwable3);
                    }
                    throw throwable;
                }
            }
            catch (Throwable throwable) {
                String string3 = "File download failed, URL = " + String.valueOf(uRL) + ", Destination file = " + file.getAbsolutePath();
                ILog.WARNING(this.getClass(), (String)string3, (Throwable)throwable);
                throw new IOException(string3, throwable);
            }
        }
        finally {
            if (bl && file.exists()) {
                try {
                    Files.delete(file.toPath());
                }
                catch (IOException iOException) {
                    ILog.WARNING(this.getClass(), (String)("Failed cleaning up partially downloaded file " + file.getAbsolutePath() + ": " + iOException.getMessage()));
                }
            }
            iPropProgressMonitor.done();
        }
    }

    @Override
    public void extractArchive(File file, File file2, File file3, boolean bl) throws IOException, InterruptedException {
        this.a(this.a, file, file2, file3, bl);
    }

    private void a(IPropProgressMonitor iPropProgressMonitor, File file, File file2, File file3, boolean bl) throws IOException, InterruptedException {
        ILog.INFO(CommonBuilder.class, (String)("Extracting archive " + file2.getPath()));
        StringBuilder stringBuilder = new StringBuilder();
        String string = file2.getPath();
        String string2 = file2.getName().toLowerCase();
        boolean bl2 = string2.endsWith(".zip");
        boolean bl3 = string2.endsWith(".jar");
        if (bl3 || bl2 && BuildEnvironment.isWindows) {
            var11_11 = this.exec(false, file3, null, stringBuilder, file.getPath(), this.a ? "xvfM" : "xfM", string);
            if (var11_11 != 0) {
                String string3 = stringBuilder.length() > 0 ? ", output = " + String.valueOf(stringBuilder) : "";
                throw new IOException("Failed extracting archive \"" + string + "\" to \"" + file3.getPath() + "\": return code = " + var11_11 + string3);
            }
        } else if (bl2) {
            var11_11 = this.exec(false, file3, null, stringBuilder, "unzip", this.a ? "-o" : "-oq", string);
            if (var11_11 != 0) {
                String string4 = stringBuilder.length() > 0 ? ", output = " + String.valueOf(stringBuilder) : "";
                throw new IOException("Failed extracting archive \"" + string + "\" to \"" + file3.getPath() + "\": return code = " + var11_11 + string4);
            }
        } else {
            var11_11 = string2.endsWith(".tar");
            boolean bl4 = string2.endsWith(".tar.gz");
            if (BuildEnvironment.isWindows) {
                throw new IOException("Cannot uncompress file '" + string + "' under Windows");
            }
            if (var11_11 == 0 && !bl4) {
                throw new IOException("Unknown file archive compression for file: " + string);
            }
            int n = this.exec(false, file3, null, stringBuilder, "tar", this.a ? "xvf" : "xf", string);
            if (n != 0) {
                String string5 = stringBuilder.length() > 0 ? ", output = " + String.valueOf(stringBuilder) : "";
                throw new IOException("Failed extracting archive \"" + string + "\" to \"" + file3.getPath() + "\": return code = " + n + string5);
            }
        }
        if (this.a && stringBuilder.length() > 0) {
            ILog.INFO(CommonBuilder.class, (String)("Archive verbose output:" + ("\n" + String.valueOf(stringBuilder)).replace("\n", "\n    ")));
        }
        if (bl) {
            ILog.INFO(CommonBuilder.class, (String)("Deleting archive " + file2.getPath()));
            try {
                Files.delete(file2.toPath());
            }
            catch (InvalidPathException invalidPathException) {
                throw new IOException("Invalid path:" + String.valueOf(file2), invalidPathException);
            }
        }
    }

    @Override
    public void downloadExtractArchive(File file, File file2, String string, File file3) throws IOException, InterruptedException {
        Object object;
        Path path;
        this.a.beginTask("Download and extract " + string, 100);
        File file4 = new File(file2, "dl");
        try {
            path = file4.toPath();
            if (file4.exists()) {
                Utilities.deleteDirectoryRecursive((Path)path, null);
            }
            if (!file4.isDirectory()) {
                Files.createDirectories(path, new FileAttribute[0]);
            }
            if (!file4.isDirectory()) {
                throw new IOException("Target is a not a directory: " + String.valueOf(file4));
            }
        }
        catch (InvalidPathException invalidPathException) {
            throw new IOException("Invalid path:" + String.valueOf(file4), invalidPathException);
        }
        try {
            object = file3.toPath();
            if (file3.exists()) {
                Utilities.deleteDirectoryRecursive((Path)object, null);
            }
            if (!file3.isDirectory()) {
                Files.createDirectories((Path)object, new FileAttribute[0]);
            }
            if (!file3.isDirectory()) {
                throw new IOException("Target is a not a directory: " + String.valueOf(file3));
            }
        }
        catch (InvalidPathException invalidPathException) {
            throw new IOException("Invalid path:" + String.valueOf(file3), invalidPathException);
        }
        this.a.worked(1);
        if (this.d) {
            throw new InterruptedException("Build process canceled");
        }
        object = "downloading \"" + string + "\"";
        File file5 = new File(file4, string.substring(string.lastIndexOf(47) + 1));
        try {
            try {
                this.a(this.a.newSubMonitor(80), string, file5);
                if (this.a.isCanceled()) {
                    throw new InterruptedException("Extraction job canceled: " + string);
                }
                if (this.d) {
                    throw new InterruptedException("Build process canceled");
                }
                object = "extracting archive \"" + String.valueOf(file5) + "\"";
                this.a(this.a.newSubMonitor(17), file, file5, file3, true);
                File[] fileArray = file3.listFiles();
                if (fileArray == null || fileArray.length != 1 || !fileArray[0].isDirectory()) {
                    throw new IOException("Expected download archive \"" + String.valueOf(file5) + "\" to contain ONE subdirectory only");
                }
                this.a.worked(1);
            }
            catch (IOException iOException) {
                throw new IOException("Failed " + (String)object + ": " + iOException.getMessage(), iOException);
            }
        }
        finally {
            try {
                if (file4.isDirectory()) {
                    Utilities.deleteDirectoryRecursive((Path)path, null);
                }
            }
            catch (IOException iOException) {
                throw new IOException("Failed deleting temporary download directory " + String.valueOf(file4), iOException);
            }
            this.a.done();
        }
    }

    @Override
    public int exec(boolean bl, String string, File file, Map<String, String> map, StringBuilder stringBuilder, String ... stringArray) throws IOException {
        boolean[] blArray = new boolean[]{true};
        String string2 = stringArray[0];
        boolean bl2 = CommonBuilder.VERBOSE;
        if ("bitsadmin".equals(string2) || "wget".equals(string2)) {
            bl2 = false;
            stringBuilder = null;
        }
        String string3 = "Executing: " + String.join((CharSequence)" ", stringArray) + (String)(string != null ? ", with response = " + string : "") + " in directory " + String.valueOf(file);
        this.a.beginTask(string3, 100);
        if (bl2 || CommonBuilder.DEBUG) {
            ILog.INFO(CommonBuilder.class, (String)string3);
        }
        StringBuilder stringBuilder2 = new StringBuilder();
        StringBuilder stringBuilder3 = stringBuilder != null ? stringBuilder : stringBuilder2;
        try {
            DefaultExecutor.Builder builder = DefaultExecutor.builder();
            IVirtualThreads iVirtualThreads = VirtualThreads.getVirtualThreads();
            ThreadFactory threadFactory = null;
            if (iVirtualThreads.areSupported()) {
                threadFactory = iVirtualThreads.createThreadFactory(null, Loggers.getDefault(), "IIZI-CommonJobs");
                builder = builder.setThreadFactory(threadFactory);
            }
            if (file != null) {
                if (!file.isDirectory()) {
                    try {
                        Files.createDirectories(file.toPath(), new FileAttribute[0]);
                    }
                    catch (InvalidPathException invalidPathException) {
                        throw new IOException("Invalid path: " + String.valueOf(file));
                    }
                }
                builder = builder.setWorkingDirectory(file);
            }
            IPrintAdapter iPrintAdapter = bl || this.c ? this.a : null;
            builder = builder.setExecuteStreamHandler((ExecuteStreamHandler)new c(this, iVirtualThreads, stringBuilder2, iPrintAdapter, string, blArray));
            CommandLine commandLine = new CommandLine(string2);
            int n = 1;
            while (n < stringArray.length) {
                commandLine.addArgument(stringArray[n]);
                ++n;
            }
            DefaultExecutor defaultExecutor = builder.get();
            defaultExecutor.setExitValues(null);
            defaultExecutor.setProcessDestroyer((ProcessDestroyer)a);
            ExecuteWatchdog.Builder builder2 = ExecuteWatchdog.builder().setTimeout(ExecuteWatchdog.INFINITE_TIMEOUT_DURATION);
            if (threadFactory != null) {
                builder2.setThreadFactory(threadFactory);
            }
            this.a = builder2.get();
            defaultExecutor.setWatchdog(this.a);
            boolean bl3 = this.a.isCanceled();
            if (!bl3) {
                iVirtualThreads.startThread(() -> {
                    while (blArray[0]) {
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        if (!this.a.isCanceled()) continue;
                        ExecuteWatchdog executeWatchdog = this.a;
                        if (executeWatchdog != null) {
                            executeWatchdog.killedProcess();
                        }
                        return;
                    }
                }, "monitor-process-killer");
            }
            int n2 = bl3 ? -1 : defaultExecutor.execute(commandLine, map);
            ExecuteWatchdog executeWatchdog = this.a;
            if (executeWatchdog != null && executeWatchdog.killedProcess()) {
                n2 = -1;
                ILog.WARNING(CommonBuilder.class, (String)"Process was killed by watchdog: setting return code = -1");
                if (!stringBuilder2.isEmpty()) {
                    stringBuilder2.append("\n\n");
                }
                stringBuilder2.append("Process was killed by watchdog: setting return code = -1");
            }
            blArray[0] = false;
            if (stringBuilder != null) {
                stringBuilder.append((CharSequence)stringBuilder2);
            }
            if ((bl2 || n2 < 0 || n2 >= 127) && !stringBuilder3.isEmpty()) {
                String string4 = "Execution verbose output:" + ("\n" + String.valueOf(stringBuilder3)).replace("\n", "\n    ");
                if (n2 < 0 || n2 >= 127) {
                    ILog.WARNING(CommonBuilder.class, (String)string4);
                } else {
                    ILog.INFO(CommonBuilder.class, (String)string4);
                }
            }
            int n3 = n2;
            return n3;
        }
        catch (IOException iOException) {
            if (stringBuilder != null) {
                stringBuilder.append((CharSequence)stringBuilder2);
            }
            if (!stringBuilder3.isEmpty()) {
                String string5 = "Execution verbose output:" + ("\n" + String.valueOf(stringBuilder3)).replace("\n", "\n    ");
                ILog.SEVERE(CommonBuilder.class, (String)string5, (Throwable)iOException);
            }
            throw iOException;
        }
        finally {
            blArray[0] = false;
            ExecuteWatchdog executeWatchdog = this.a;
            if (executeWatchdog != null) {
                executeWatchdog.stop();
            }
            this.a = null;
            this.a.done();
        }
    }
}

