/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.jdbc;

import com.iizix.GenericListener;
import com.iizix.ILog;
import com.iizix.IWebServiceEngine;
import com.iizix.SystemConfig;
import com.iizix.Utilities;
import com.iizix.jdbc.DBServerState;
import com.iizix.jdbc.JDBCHelper;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.Socket;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.TimeUnit;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class DerbyImpl {
    public static final int DERBY_DEFAULT_PORT = 1527;
    public static final String DERBY_CLIENT_DRIVER_CLASS = "org.apache.derby.jdbc.ClientDriver";
    private static final GenericListener<Runnable> a = new GenericListener(Runnable.class);
    private static DBServerState a = DBServerState.UNKNOWN;
    private static File a;
    private static Process a;
    private static int a;
    private static String a;
    private static String b;
    private final File b;
    private final Thread a;
    private final String[] a;
    private static volatile /* synthetic */ int[] a;

    public DerbyImpl(File file, File file2, boolean bl, String string, int n, String string2, boolean bl2, String string3, String string4) {
        this.b = file = Utilities.getCanonicalFile((File)file);
        if (!file.isDirectory()) {
            throw new IllegalArgumentException("jdbcDriversDir is not a directory: " + String.valueOf(file));
        }
        if (string == null || string.equalsIgnoreCase("localhost") || string.startsWith("127.0.0.1")) {
            string = "localhost";
        }
        if (n <= 0) {
            n = 1527;
        }
        String string5 = "jdbc:derby://" + string + ":" + n + "/" + string2;
        if (bl2) {
            string5 = string5 + ";create=true";
        }
        this.a = new String[]{"description", "IIZI Derby Network database server on \"" + string + ":" + n + "\" using database directory \"" + file2.getPath() + "\"", "url", string5, "username", string3, "password", string4, "classpath", "derby/derbyclient.jar,derby/derbyshared.jar,derby/derbytools.jar", "driverClassName", DERBY_CLIENT_DRIVER_CLASS};
        Process process = a;
        Thread thread = null;
        if (bl && string.equals("localhost") && (process == null || !process.isAlive())) {
            ILog.INFO(this.getClass(), (String)("Derby Server: " + (switch (DerbyImpl.a()[DerbyImpl.startServer(file, Utilities.getCanonicalFile((File)file2), n).ordinal()]) {
                case 6 -> "connectable";
                case 7 -> "connection failed";
                case 8 -> "not running, configured for invalid host";
                case 1 -> "started";
                case 3 -> "starting";
                case 5 -> "failed to start";
                case 2 -> "stopped";
                case 4 -> "stopping";
                default -> "unknown operational state";
            })));
            process = a;
            if (process != null) {
                thread = new Thread(() -> {
                    DBServerState dBServerState = DerbyImpl.stopServer(this.b);
                }, "DerbyAutoShutdown");
                Runtime.getRuntime().addShutdownHook(thread);
            }
        }
        this.a = thread;
    }

    Properties a() {
        Properties properties = new Properties();
        int n = 0;
        while (n < this.a.length) {
            properties.put(this.a[n++], this.a[n++]);
        }
        return properties;
    }

    void a(boolean bl) {
        if (bl) {
            DerbyImpl.stopServer(this.b);
            if (this.a != null) {
                Runtime.getRuntime().removeShutdownHook(this.a);
            }
        }
    }

    public static DBServerState getServerState() {
        return a;
    }

    public static boolean addServerStateListener(Runnable runnable) {
        return a.addListener((Object)runnable);
    }

    public static boolean removeServerStateListener(Runnable runnable) {
        return a.removeListener((Object)runnable);
    }

    public static boolean canStopServer() {
        Process process = a;
        int n = a;
        return process != null && n > 0 && process.isAlive();
    }

    private static DBServerState a(DBServerState dBServerState) {
        if (dBServerState != a) {
            a = dBServerState;
            a.forEach(runnable -> runnable.run());
        }
        return dBServerState;
    }

    public static int getServerPort() {
        return a;
    }

    public static DBServerState isSocketConnectable(String string, int n, int n2, IWebServiceEngine iWebServiceEngine) {
        List<Proxy> list;
        Serializable serializable;
        Proxy proxy = Proxy.NO_PROXY;
        if (iWebServiceEngine != null) {
            serializable = URI.create("socket://" + string + ":" + n);
            list = ProxySelector.getDefault().select((URI)serializable);
            if (list.size() > 0) {
                proxy = list.get(0);
            }
        }
        try {
            serializable = null;
            list = null;
            try (Socket socket = new Socket(proxy);){
                socket.connect(new InetSocketAddress(InetAddress.getByName(string), n), n2);
                socket.getInputStream().close();
                return DerbyImpl.a(DBServerState.CONNECTABLE);
            }
            catch (Throwable throwable) {
                if (serializable == null) {
                    serializable = throwable;
                } else if (serializable != throwable) {
                    ((Throwable)serializable).addSuppressed(throwable);
                }
                throw serializable;
            }
        }
        catch (UnknownHostException unknownHostException) {
            return DerbyImpl.a(DBServerState.INVALID_HOST);
        }
        catch (IOException iOException) {
            return DerbyImpl.a(DBServerState.CONNECTION_FAILED);
        }
    }

    private static ArrayList<String> a(File file, String ... stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        char c2 = File.separatorChar;
        if (a == null) {
            a = System.getProperty("java.home") + c2 + "bin" + c2 + "java" + SystemConfig.EXE_EXT;
        }
        String string = JDBCHelper.a.getPath() + c2 + "derby" + c2;
        if (b == null) {
            b = string + "*";
        }
        arrayList.add(a);
        arrayList.add("-cp");
        arrayList.add(b);
        arrayList.add("-jar");
        arrayList.add(string + "derbyrun.jar");
        String[] stringArray2 = stringArray;
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string2 = stringArray2[n2];
            arrayList.add(string2);
            ++n2;
        }
        return arrayList;
    }

    /*
     * Exception decompiling
     */
    public static DBServerState startServer(File var0, File var1_1, int var2_2) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static DBServerState stopServer(File file) {
        Serializable serializable;
        DBServerState dBServerState = a;
        Process process = a;
        int n = a;
        a = null;
        a = 0;
        if (process == null || n == 0 || file == null || !file.isDirectory()) {
            return dBServerState;
        }
        if (!process.isAlive()) {
            File file2 = a;
            if (file2 != null) {
                a = null;
                file2.delete();
            }
            return DerbyImpl.a(DBServerState.STOPPED);
        }
        boolean bl = false;
        try {
            serializable = DerbyImpl.a(file, "server", "shutdown", "-p", Integer.toString(n));
            ILog.log((int)(SystemConfig.isDevelopmentMode ? 3 : 5), (String)"DerbyServer", (String)("Executing " + String.valueOf(serializable)));
            ProcessBuilder processBuilder = new ProcessBuilder((List<String>)((Object)serializable)).directory(file);
            processBuilder.environment().clear();
            Process process2 = processBuilder.start();
            dBServerState = DerbyImpl.a(DBServerState.STOPPING);
            process2.waitFor();
        }
        catch (InterruptedException interruptedException) {
            bl = true;
            ILog.log((int)2, (String)"DerbyServer", (String)"Thread interrupted while waiting for Derby Network Server to shutdown");
        }
        catch (IOException iOException) {
            ILog.log((int)1, (String)"DerbyServer", (String)("Failed stopping the Derby network database server (" + iOException.getMessage() + "), killing the process instead"));
            try {
                if (process.isAlive()) {
                    ILog.log((int)2, (String)"DerbyServer", (String)("Killing Derby Network Server process ID " + process.pid()));
                    process = process.destroyForcibly();
                }
            }
            catch (Throwable throwable) {
                ILog.log((int)1, (String)"DerbyServer", (String)("Failed killing the Derby network database server process: " + throwable.getMessage()));
            }
        }
        if (!bl && process.isAlive()) {
            try {
                if (process.waitFor(10000L, TimeUnit.MILLISECONDS)) {
                    dBServerState = DerbyImpl.a(DBServerState.STOPPED);
                    serializable = a;
                    if (serializable != null) {
                        a = null;
                        ((File)serializable).delete();
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                bl = true;
                ILog.log((int)2, (String)"DerbyServer", (String)"Thread interrupted while waiting for Derby network database server to shutdown");
            }
            if (process.isAlive()) {
                ILog.log((int)1, (String)"DerbyServer", (String)("Failed stopping the Derby network database server process within " + Utilities.formatEnglishDuration((long)10000L)));
            }
        }
        if (bl) {
            Thread.currentThread().interrupt();
        }
        return dBServerState;
    }

    static /* synthetic */ int[] a() {
        if (a != null) {
            return a;
        }
        int[] nArray = new int[DBServerState.values().length];
        try {
            nArray[DBServerState.CONNECTABLE.ordinal()] = 6;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DBServerState.CONNECTION_FAILED.ordinal()] = 7;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DBServerState.INVALID_HOST.ordinal()] = 8;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DBServerState.STARTED.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DBServerState.STARTING.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DBServerState.START_FAILED.ordinal()] = 5;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DBServerState.STOPPED.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DBServerState.STOPPING.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DBServerState.UNKNOWN.ordinal()] = 9;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        a = nArray;
        return nArray;
    }
}

