/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.user;

import com.iizix.ILog;
import com.iizix.NotFoundException;
import com.iizix.text.IEnumLocaleString;

public enum UserLocaleString implements IEnumLocaleString
{
    UserNameNotFound("User name not found"),
    EmailNotFound("Email not found"),
    FixedPassword("You cannot change your password, it is set to fixed password by administrator's action"),
    SpecifyPassword("Password must be specified"),
    SpecifyNewPassword("New password must be specified"),
    PasswordChangeRequired("Password change is required to sign in"),
    PassordPolicyMismatch("Password does not meet minimum requirements"),
    HashedPasswordMismatch("Your old password does not match"),
    DatabaseError("A database error occurred"),
    SystemError("A system error occurred");

    public static final String PREFIX = "ci.user_";
    public final String id = "ci.user_" + this.name();
    public final String english;

    private UserLocaleString(String string2) {
        this.english = string2;
    }

    @Override
    public String getID() {
        return this.id;
    }

    @Override
    public String getFallback() {
        return this.english;
    }

    public String asID(String string) {
        return this.id + ":" + string;
    }

    public static UserLocaleString from(String string) throws NotFoundException {
        int n2 = string.indexOf(58);
        String string2 = n2 < 0 ? string : string.substring(0, n2);
        UserLocaleString[] userLocaleStringArray = UserLocaleString.values();
        int n3 = userLocaleStringArray.length;
        int n4 = 0;
        while (n4 < n3) {
            UserLocaleString userLocaleString = userLocaleStringArray[n4];
            if (userLocaleString.id.equals(string2)) {
                return userLocaleString;
            }
            ++n4;
        }
        throw new NotFoundException("String ID \"" + string + "\" not found");
    }

    public static UserLocaleString fromNonNull(String string) {
        try {
            return UserLocaleString.from(string);
        }
        catch (NotFoundException notFoundException) {
            ILog.SEVERE(UserLocaleString.class, "Failed looking up the String ID \"{}\"", string, notFoundException);
            return SystemError;
        }
    }
}

