/*
 * Decompiled with CFR 0.152.
 */
package com.iizigo.prop.editor;

import com.iizigo.prop.BaseEditor;
import com.iizigo.swt.UpDownArrowSpinner;
import com.iizix.prop.LongProp;

public class LongPropEditor
extends BaseEditor<LongProp, Long> {
    @Override
    protected void create() {
        this.createGridLayout(1, 0);
        this.createText();
        UpDownArrowSpinner.enable(this.text, true);
    }

    @Override
    protected String getToolTipText() {
        return "Enter a Long integer value";
    }

    @Override
    public Long getDefaultValue() {
        try {
            return Long.valueOf(this.info.defaultPropertyValue);
        }
        catch (Exception exception) {
            return 0L;
        }
    }

    @Override
    protected Long getValue(String string) throws Exception {
        if (string.isEmpty()) {
            throw new Exception("Number must be specified");
        }
        String string2 = null;
        try {
            return Long.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            string2 = "Invalid number: " + string;
            throw new Exception(string2);
        }
    }

    @Override
    public String formatValue(Long l2) {
        return l2.toString();
    }
}

