/*
 * Decompiled with CFR 0.152.
 */
package com.tabnine.eclipse.shared.api.chat;

import com.google.gson.JsonElement;
import com.tabnine.eclipse.shared.a.a.c.a;
import com.tabnine.eclipse.shared.a.l;
import com.tabnine.eclipse.shared.api.chat.EnrichingContextType;
import com.tabnine.eclipse.shared.api.chat.IEnrichingContext;
import com.tabnine.eclipse.shared.b.b;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.ui.IURIEditorInput;
import org.eclipse.ui.editors.text.ILocationProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public class EditorContext
implements IEnrichingContext {
    private static Logger logger = LogManager.getLogger(a.class);
    private final String fileCode;
    private final String selectedCode;
    private final Integer currentLineIndex;
    private final List<JsonElement> selectedCodeUsages = new ArrayList<JsonElement>();
    private final String lineTextAtCursor;
    private final EnrichingContextType type = EnrichingContextType.Editor;
    private final String path;

    public EditorContext(String string, String string2, Integer n2, String string3, String string4) {
        this.fileCode = string;
        this.selectedCode = string2;
        this.currentLineIndex = n2;
        this.lineTextAtCursor = string3;
        this.path = string4;
    }

    public static EditorContext from(ITextEditor iTextEditor) {
        return l.a(iTextEditor).flatMap(iDocument -> l.b(iTextEditor).map(textSelection -> {
            String string;
            Integer n2;
            try {
                n2 = EditorContext.getCurrentLineIndex(iDocument, textSelection);
                string = b.a(n2, iDocument);
            }
            catch (BadLocationException badLocationException) {
                logger.warn("Failed to get line text at cursor", (Throwable)badLocationException);
                string = "";
                n2 = null;
            }
            return new EditorContext(EditorContext.getDocumentText(iDocument), EditorContext.getSelectionText(textSelection), n2, string, EditorContext.getPath(iTextEditor));
        })).orElse(new EditorContext("", "", null, "", ""));
    }

    private static String getSelectionText(TextSelection textSelection) {
        return Optional.ofNullable(textSelection.getText()).orElse("");
    }

    private static String getDocumentText(IDocument iDocument) {
        return Optional.ofNullable(iDocument.get()).orElse("");
    }

    private static String getPath(ITextEditor iTextEditor) {
        iTextEditor = iTextEditor.getEditorInput();
        Path path = null;
        if (iTextEditor instanceof IURIEditorInput) {
            path = Paths.get(((IURIEditorInput)iTextEditor).getURI());
        } else if (iTextEditor instanceof ILocationProvider) {
            path = (ILocationProvider)iTextEditor;
            path = Paths.get(path.getPath(iTextEditor).toOSString(), new String[0]);
        }
        if (path != null) {
            return path.toString();
        }
        return "";
    }

    private static Integer getCurrentLineIndex(IDocument iDocument, TextSelection textSelection) {
        return iDocument.getLineOfOffset(textSelection.getOffset());
    }

    @Override
    public EnrichingContextType getContextType() {
        return this.type;
    }
}

