/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.plugin;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.pde.core.IBaseModel;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.ibundle.IBundleModel;
import org.eclipse.pde.internal.core.text.bundle.ExportPackageObject;
import org.eclipse.pde.internal.core.text.bundle.PackageFriend;
import org.eclipse.pde.internal.core.text.bundle.PackageObject;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.dialogs.PluginSelectionDialog;
import org.eclipse.pde.internal.ui.editor.FormLayoutFactory;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.editor.TableSection;
import org.eclipse.pde.internal.ui.editor.context.InputContextManager;
import org.eclipse.pde.internal.ui.editor.plugin.BundleInputContext;
import org.eclipse.pde.internal.ui.parts.EditableTablePart;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IPartSelectionListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class ExportPackageVisibilitySection
extends TableSection
implements IPartSelectionListener {
    private static int ADD_INDEX = 0;
    private static int REMOVE_INDEX = 1;
    private TableViewer fFriendViewer;
    private Action fAddAction;
    private Action fRemoveAction;
    private Button fInternalButton;
    private boolean fBlockChanges;
    private ExportPackageObject[] fSelectedObjects;
    private Image fImage;
    private Button fVisibleButton;

    public ExportPackageVisibilitySection(PDEFormPage formPage, Composite parent) {
        super(formPage, parent, 128, new String[]{PDEUIMessages.ManifestEditor_ExportSection_add, PDEUIMessages.ManifestEditor_ExportSection_remove});
        this.fHandleDefaultButton = false;
    }

    @Override
    public void createClient(Section section, FormToolkit toolkit) {
        section.setText(PDEUIMessages.ExportPackageVisibilitySection_title);
        section.setDescription(PDEUIMessages.ExportPackageVisibilitySection_default);
        Composite comp = toolkit.createComposite((Composite)section);
        comp.setLayout((Layout)FormLayoutFactory.createSectionClientGridLayout(false, 1));
        this.fVisibleButton = toolkit.createButton(comp, PDEUIMessages.ExportPackageVisibilitySection_unconditional, 16);
        this.fInternalButton = toolkit.createButton(comp, PDEUIMessages.ExportPackageVisibilitySection_hideAll, 16);
        this.fInternalButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            if (!this.fBlockChanges) {
                ExportPackageObject[] exportPackageObjectArray = this.fSelectedObjects;
                int n = this.fSelectedObjects.length;
                int n2 = 0;
                while (n2 < n) {
                    ExportPackageObject selectedObject = exportPackageObjectArray[n2];
                    selectedObject.setInternal(this.fInternalButton.getSelection());
                    ++n2;
                }
                this.getTablePart().setButtonEnabled(ADD_INDEX, this.fInternalButton.getSelection());
                this.getTablePart().setButtonEnabled(REMOVE_INDEX, this.fInternalButton.getSelection());
                this.fFriendViewer.refresh();
            }
        }));
        Composite container = toolkit.createComposite(comp);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 1;
        layout.marginHeight = 1;
        layout.numColumns = 2;
        container.setLayout((Layout)layout);
        container.setLayoutData((Object)new GridData(1808));
        EditableTablePart tablePart = this.getTablePart();
        IBaseModel model = this.getPage().getModel();
        tablePart.setEditable(model != null && model.isEditable());
        this.createViewerPartControl(container, 2, 2, toolkit);
        this.fFriendViewer = tablePart.getTableViewer();
        this.fFriendViewer.setContentProvider((IContentProvider)new TableContentProvider());
        this.fFriendViewer.setLabelProvider((IBaseLabelProvider)new TableLabelProvider());
        toolkit.paintBordersFor(container);
        this.makeActions();
        this.fImage = PDEPluginImages.DESC_PLUGIN_OBJ.createImage();
        this.update(null);
        this.getBundleModel().addModelChangedListener((IModelChangedListener)this);
        section.setLayout((Layout)FormLayoutFactory.createClearGridLayout(false, 1));
        section.setLayoutData((Object)new GridData(1808));
        section.setClient((Control)comp);
    }

    private void makeActions() {
        this.fAddAction = new Action(PDEUIMessages.ManifestEditor_ExportSection_add){

            public void run() {
                ExportPackageVisibilitySection.this.handleAdd();
            }
        };
        this.fAddAction.setEnabled(this.isEditable());
        this.fRemoveAction = new Action(PDEUIMessages.ManifestEditor_ExportSection_remove){

            public void run() {
                ExportPackageVisibilitySection.this.handleRemove();
            }
        };
        this.fRemoveAction.setEnabled(this.isEditable());
    }

    @Override
    protected void selectionChanged(IStructuredSelection selection) {
        this.getPage().getPDEEditor().setSelection((ISelection)selection);
        Object item = selection.getFirstElement();
        this.getTablePart().setButtonEnabled(1, item != null);
    }

    @Override
    protected void buttonSelected(int index) {
        if (index == ADD_INDEX) {
            this.handleAdd();
        } else if (index == REMOVE_INDEX) {
            this.handleRemove();
        }
    }

    @Override
    public boolean doGlobalAction(String actionId) {
        if (!this.isEditable()) {
            return false;
        }
        if (actionId.equals(ActionFactory.DELETE.getId())) {
            this.handleRemove();
            return true;
        }
        if (actionId.equals(ActionFactory.CUT.getId())) {
            this.handleRemove();
            return false;
        }
        if (actionId.equals(ActionFactory.PASTE.getId())) {
            this.doPaste();
            return true;
        }
        return super.doGlobalAction(actionId);
    }

    @Override
    protected boolean canPaste(Object targetObject, Object[] sourceObjects) {
        if (!this.isOneObjectSelected()) {
            return false;
        }
        Object[] objectArray = sourceObjects;
        int n = sourceObjects.length;
        int n2 = 0;
        while (n2 < n) {
            Object sourceObject = objectArray[n2];
            if (!(sourceObject instanceof PackageFriend)) {
                return false;
            }
            PackageFriend friend = (PackageFriend)sourceObject;
            if (this.fSelectedObjects[0].hasFriend(friend.getName())) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private boolean isOneObjectSelected() {
        return this.fSelectedObjects != null && this.fSelectedObjects.length == 1;
    }

    @Override
    protected void doPaste(Object targetObject, Object[] sourceObjects) {
        Object[] objectArray = sourceObjects;
        int n = sourceObjects.length;
        int n2 = 0;
        while (n2 < n) {
            Object sourceObject = objectArray[n2];
            if (sourceObject instanceof PackageFriend) {
                PackageFriend friend = (PackageFriend)sourceObject;
                if (this.isOneObjectSelected()) {
                    friend.reconnect((PackageObject)this.fSelectedObjects[0]);
                    this.fSelectedObjects[0].addFriend(friend);
                }
            }
            ++n2;
        }
    }

    public void dispose() {
        IBundleModel model = this.getBundleModel();
        if (model != null) {
            model.removeModelChangedListener((IModelChangedListener)this);
        }
        if (this.fImage != null) {
            this.fImage.dispose();
        }
        super.dispose();
    }

    @Override
    protected void fillContextMenu(IMenuManager manager) {
        this.getPage().getPDEEditor().getContributor().contextMenuAboutToShow(manager);
    }

    private void handleAdd() {
        PluginSelectionDialog dialog = new PluginSelectionDialog(PDEPlugin.getActiveWorkbenchShell(), this.getModels(), true);
        dialog.create();
        if (dialog.open() == 0) {
            Object[] selected;
            Object[] objectArray = selected = dialog.getResult();
            int n = selected.length;
            int n2 = 0;
            while (n2 < n) {
                Object selectedObject = objectArray[n2];
                IPluginModelBase model = (IPluginModelBase)selectedObject;
                ExportPackageObject[] exportPackageObjectArray = this.fSelectedObjects;
                int n3 = this.fSelectedObjects.length;
                int n4 = 0;
                while (n4 < n3) {
                    ExportPackageObject fSelectedObject = exportPackageObjectArray[n4];
                    fSelectedObject.addFriend(new PackageFriend((PackageObject)fSelectedObject, model.getPluginBase().getId()));
                    ++n4;
                }
                ++n2;
            }
        }
    }

    private IPluginModelBase[] getModels() {
        IPluginModelBase[] models;
        ArrayList<IPluginModelBase> list = new ArrayList<IPluginModelBase>();
        IPluginModelBase[] iPluginModelBaseArray = models = PluginRegistry.getActiveModels((boolean)true);
        int n = models.length;
        int n2 = 0;
        while (n2 < n) {
            IPluginModelBase model = iPluginModelBaseArray[n2];
            String id = model.getPluginBase().getId();
            if (!this.fSelectedObjects[0].hasFriend(id)) {
                list.add(model);
            }
            ++n2;
        }
        return list.toArray(new IPluginModelBase[list.size()]);
    }

    private void handleRemove() {
        Object[] removed;
        Object[] objectArray = removed = this.fFriendViewer.getStructuredSelection().toArray();
        int n = removed.length;
        int n2 = 0;
        while (n2 < n) {
            Object removedObject = objectArray[n2];
            ExportPackageObject[] exportPackageObjectArray = this.fSelectedObjects;
            int n3 = this.fSelectedObjects.length;
            int n4 = 0;
            while (n4 < n3) {
                ExportPackageObject fSelectedObject = exportPackageObjectArray[n4];
                fSelectedObject.removeFriend((PackageFriend)removedObject);
                ++n4;
            }
            ++n2;
        }
    }

    @Override
    public void modelChanged(IModelChangedEvent event) {
        if (event.getChangeType() == 99) {
            this.markStale();
            return;
        }
        if ("Export-Package".equals(event.getChangedProperty())) {
            this.refresh();
            return;
        }
        if (event.getChangeType() == 1 && event.getChangedObjects()[0] instanceof PackageFriend) {
            this.fFriendViewer.refresh();
            this.fFriendViewer.setSelection((ISelection)new StructuredSelection(event.getChangedObjects()[0]), true);
            this.fFriendViewer.getControl().setFocus();
            return;
        }
        int index = this.fFriendViewer.getTable().getSelectionIndex();
        this.fFriendViewer.refresh();
        this.fFriendViewer.getTable().setSelection(Math.min(index, this.fFriendViewer.getTable().getItemCount() - 1));
    }

    public void refresh() {
        this.update(null);
        super.refresh();
    }

    public void selectionChanged(IFormPart source, ISelection selection) {
        List list = ((IStructuredSelection)selection).toList();
        if (!list.isEmpty()) {
            Object[] objects = list.toArray();
            ExportPackageObject first = null;
            int i = 0;
            while (i < objects.length) {
                if (!(objects[i] instanceof ExportPackageObject)) {
                    this.update(null);
                    return;
                }
                if (first == null) {
                    first = (ExportPackageObject)objects[i];
                } else if (!first.hasSameVisibility((ExportPackageObject)objects[i])) {
                    this.update(null);
                    return;
                }
                ++i;
            }
            this.update(list.toArray(new ExportPackageObject[list.size()]));
        } else {
            this.update(null);
        }
    }

    private void update(ExportPackageObject[] objects) {
        this.fBlockChanges = true;
        this.fSelectedObjects = objects;
        ExportPackageObject object = objects == null ? null : objects[0];
        this.fVisibleButton.setEnabled(object != null && this.isEditable());
        this.fVisibleButton.setSelection(objects != null && !object.isInternal());
        this.fInternalButton.setEnabled(object != null && this.isEditable());
        this.fInternalButton.setSelection(objects != null && object.isInternal());
        this.getTablePart().setButtonEnabled(0, this.fInternalButton.getSelection() && this.isEditable());
        this.getTablePart().setButtonEnabled(1, this.fInternalButton.getSelection() && this.isEditable());
        this.fFriendViewer.setInput((Object)object);
        this.fBlockChanges = false;
    }

    private BundleInputContext getBundleContext() {
        InputContextManager manager = this.getPage().getPDEEditor().getContextManager();
        return (BundleInputContext)manager.findContext("bundle-context");
    }

    private IBundleModel getBundleModel() {
        BundleInputContext context = this.getBundleContext();
        return context != null ? context.getModel() : null;
    }

    static class TableContentProvider
    implements IStructuredContentProvider {
        TableContentProvider() {
        }

        public Object[] getElements(Object parent) {
            ExportPackageObject object = (ExportPackageObject)parent;
            if (object == null || !object.isInternal()) {
                return new Object[0];
            }
            return object.getFriends();
        }
    }

    class TableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        TableLabelProvider() {
        }

        public String getColumnText(Object obj, int index) {
            return obj.toString();
        }

        public Image getColumnImage(Object obj, int index) {
            return ExportPackageVisibilitySection.this.fImage;
        }
    }
}

