/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.tools.emf.ui.internal.common.component;

import jakarta.inject.Inject;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.tools.emf.ui.common.Util;
import org.eclipse.e4.tools.emf.ui.common.component.AbstractComponentEditor;
import org.eclipse.e4.tools.emf.ui.internal.E4Properties;
import org.eclipse.e4.tools.emf.ui.internal.common.component.ControlFactory;
import org.eclipse.e4.tools.emf.ui.internal.common.component.dialogs.ParameterIdSelectionDialog;
import org.eclipse.e4.ui.model.application.commands.MParameter;
import org.eclipse.e4.ui.model.application.impl.ApplicationPackageImpl;
import org.eclipse.emf.databinding.EMFDataBindingContext;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.databinding.swt.IWidgetValueProperty;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class ParameterEditor
extends AbstractComponentEditor<MParameter> {
    private Composite composite;
    private EMFDataBindingContext context;
    private StackLayout stackLayout;
    @Inject
    private IEclipseContext eclipseContext;

    @Inject
    public ParameterEditor() {
    }

    @Override
    public Image getImage(Object element) {
        return this.getImage(element, "IMG_org.eclipse.e4.tools.emf.ui.modelelements.Parameter");
    }

    @Override
    public String getLabel(Object element) {
        return this.Messages.ParameterEditor_TreeLabel;
    }

    @Override
    public String getDetailLabel(Object element) {
        MParameter param = (MParameter)element;
        if (param.getName() != null && param.getName().trim().length() > 0) {
            return param.getName().trim();
        }
        if (param.getElementId() != null && param.getElementId().trim().length() > 0) {
            return param.getElementId().trim();
        }
        return null;
    }

    @Override
    public String getDescription(Object element) {
        return this.Messages.ParameterEditor_TreeLabelDescription;
    }

    @Override
    public Composite doGetEditor(Composite parent, Object object) {
        Control topControl;
        if (this.composite == null) {
            this.context = new EMFDataBindingContext();
            if (this.getEditor().isModelFragment()) {
                this.composite = new Composite(parent, 0);
                this.stackLayout = new StackLayout();
                this.composite.setLayout((Layout)this.stackLayout);
                this.createForm(this.composite, this.context, this.getMaster(), false);
                this.createForm(this.composite, this.context, this.getMaster(), true);
            } else {
                this.composite = this.createForm(parent, this.context, this.getMaster(), false);
            }
        }
        if (this.getEditor().isModelFragment() && this.stackLayout.topControl != (topControl = Util.isImport((EObject)object) ? this.composite.getChildren()[1] : this.composite.getChildren()[0])) {
            this.stackLayout.topControl = topControl;
            this.composite.requestLayout();
        }
        this.getMaster().setValue((Object)((MParameter)object));
        return this.composite;
    }

    private Composite createForm(Composite parent, EMFDataBindingContext context, WritableValue<MParameter> master, boolean isImport) {
        CTabFolder folder = new CTabFolder(parent, 1024);
        CTabItem item = new CTabItem(folder, 0);
        item.setText(this.Messages.ModelTooling_Common_TabDefault);
        parent = this.createScrollableContainer((Composite)folder);
        item.setControl((Control)parent.getParent());
        if (this.getEditor().isShowXMIId() || this.getEditor().isLiveModel()) {
            ControlFactory.createXMIId(parent, this);
        }
        IWidgetValueProperty textProp = WidgetProperties.text((int)24);
        if (isImport) {
            ControlFactory.createFindImport(parent, this.Messages, this, context);
            folder.setSelection(0);
            return folder;
        }
        ControlFactory.createTextField(parent, this.Messages.ModelTooling_Common_Id, master, context, (IWidgetValueProperty<Text, String>)textProp, E4Properties.elementId(this.getEditingDomain()));
        this.createParameterNameRow(parent, (IWidgetValueProperty<Text, String>)textProp);
        ControlFactory.createTextField(parent, this.Messages.ParameterEditor_Value, master, context, (IWidgetValueProperty<Text, String>)textProp, E4Properties.parameterValue(this.getEditingDomain()));
        item = new CTabItem(folder, 0);
        item.setText(this.Messages.ModelTooling_Common_TabSupplementary);
        parent = this.createScrollableContainer((Composite)folder);
        item.setControl((Control)parent.getParent());
        ControlFactory.createStringListWidget(parent, this.Messages, this, this.Messages.CategoryEditor_Tags, (EStructuralFeature)ApplicationPackageImpl.Literals.APPLICATION_ELEMENT__TAGS, 10);
        ControlFactory.createMapProperties(parent, this.Messages, this, this.Messages.ModelTooling_Contribution_PersistedState, (EStructuralFeature)ApplicationPackageImpl.Literals.APPLICATION_ELEMENT__PERSISTED_STATE, 10);
        this.createContributedEditorTabs(folder, context, this.getMaster(), MParameter.class);
        folder.setSelection(0);
        return folder;
    }

    @Override
    public IObservableList<?> getChildList(Object element) {
        return null;
    }

    private void createParameterNameRow(Composite parent, IWidgetValueProperty<Text, String> textProp) {
        Label commandParameterIdLabel = new Label(parent, 0);
        commandParameterIdLabel.setText(this.Messages.ParameterEditor_Command_Parameter_ID);
        commandParameterIdLabel.setLayoutData((Object)new GridData());
        Text commandParameterIdValue = new Text(parent, 2048);
        GridData gd = new GridData(768);
        commandParameterIdValue.setLayoutData((Object)gd);
        ControlFactory.TextPasteHandler.createFor(commandParameterIdValue);
        this.context.bindValue((IObservableValue)textProp.observeDelayed(200, (Widget)commandParameterIdValue), E4Properties.parameterName(this.getEditingDomain()).observeDetail(this.getMaster()));
        Button b = ControlFactory.createFindButton(parent, this.resourcePool);
        b.addSelectionListener((SelectionListener)new ChooseParameterButtonSelectionListener());
    }

    private final class ChooseParameterButtonSelectionListener
    extends SelectionAdapter {
        private ChooseParameterButtonSelectionListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            WritableValue master = ParameterEditor.this.getMaster();
            if (master == null || master.getValue() == null) {
                return;
            }
            IEclipseContext staticContext = EclipseContextFactory.create((String)"ParameterIdSelectionDialog static context");
            staticContext.set(MParameter.class, (Object)((MParameter)master.getValue()));
            ParameterIdSelectionDialog dialog = (ParameterIdSelectionDialog)((Object)ContextInjectionFactory.make(ParameterIdSelectionDialog.class, (IEclipseContext)ParameterEditor.this.eclipseContext, (IEclipseContext)staticContext));
            dialog.open();
        }
    }
}

