/*
 * Decompiled with CFR 0.152.
 */
package com.iizigo.prop.editor;

import com.iizigo.prop.IPropertyEditorController;
import com.iizigo.prop.PropertyEditorInfo;
import com.iizigo.prop.editor.IEntryValidator;
import com.iizix.prop.PropCnr;

public class LongRange
implements IEntryValidator {
    @Override
    public String validate(IPropertyEditorController iPropertyEditorController, PropertyEditorInfo propertyEditorInfo, PropCnr[] propCnrArray, String string, String[] stringArray) {
        long[] lArray;
        try {
            lArray = this.a(stringArray);
        }
        catch (Exception exception) {
            return "LongRange: " + String.valueOf(exception);
        }
        try {
            long l2 = Long.parseLong(string);
            if (l2 < lArray[0]) {
                return "Minimum value is " + lArray[0];
            }
            if (l2 > lArray[1]) {
                return "Maximum value is " + lArray[1];
            }
            return null;
        }
        catch (NumberFormatException numberFormatException) {
            return "Invalid number";
        }
    }

    private long[] a(String[] stringArray) {
        long[] lArray = new long[]{Long.MIN_VALUE, Long.MAX_VALUE};
        if (stringArray.length > 0) {
            String string = stringArray[0];
            int n2 = string.indexOf(58);
            if (n2 < 0) {
                throw new IllegalArgumentException("Invalid range (missing \":\"): " + string);
            }
            String string2 = string.substring(0, n2);
            String string3 = string.substring(n2 + 1);
            if (string2.isEmpty() && string3.isEmpty()) {
                throw new IllegalArgumentException("Invalid range, no arguments: " + string);
            }
            if (!string2.isEmpty()) {
                lArray[0] = Long.parseLong(string2);
            }
            if (!string3.isEmpty()) {
                lArray[1] = Long.parseLong(string3);
            }
        }
        return lArray;
    }

    @Override
    public String getDescription(IPropertyEditorController iPropertyEditorController, PropertyEditorInfo propertyEditorInfo, PropCnr[] propCnrArray, String[] stringArray) {
        String string;
        try {
            long[] lArray = this.a(stringArray);
            if (lArray[0] == Long.MIN_VALUE) {
                return "a number with a maximum of " + lArray[1];
            }
            if (lArray[1] == Long.MAX_VALUE) {
                return "a number with a minimum of " + lArray[0];
            }
            string = "a number between " + lArray[0] + " and " + lArray[1];
        }
        catch (Exception exception) {
            string = "Range error: " + String.valueOf(exception);
        }
        return string;
    }
}

