/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.value;

import com.iizix.LocaleInfo;
import com.iizix.Value;
import com.iizix.value.TermporalAccessorValue;
import java.sql.Timestamp;
import java.text.ParseException;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Date;
import java.util.GregorianCalendar;

public class ZonedDateTimeValue
extends TermporalAccessorValue<ZonedDateTime> {
    @Override
    public final Value.Type getValueType() {
        return Value.Type.Year;
    }

    @Override
    public Class<ZonedDateTime> getValueClass() {
        return ZonedDateTime.class;
    }

    @Override
    public String getDescription() {
        return "Date-time with a time-zone in the ISO-8601 calendar system, such as 2007-12-03T10:15:30+01:00 Europe/Paris";
    }

    @Override
    public ZonedDateTime createDefault() {
        return ZonedDateTime.of(1970, 1, 1, 0, 0, 0, 0, ZoneOffset.UTC);
    }

    @Override
    public ZonedDateTime parse(String string) throws ParseException, Exception {
        try {
            return ZonedDateTime.parse(string);
        }
        catch (DateTimeParseException dateTimeParseException) {
            throw new ParseException(dateTimeParseException.getMessage(), dateTimeParseException.getErrorIndex());
        }
    }

    @Override
    public ZonedDateTime parse(String string, DateTimeFormatter dateTimeFormatter) throws ParseException, Exception {
        try {
            return ZonedDateTime.parse(string, dateTimeFormatter);
        }
        catch (DateTimeParseException dateTimeParseException) {
            throw new ParseException(dateTimeParseException.getMessage(), dateTimeParseException.getErrorIndex());
        }
    }

    @Override
    public ZonedDateTime convert(Object object, Value.Type type, LocaleInfo localeInfo) throws Exception {
        long l2;
        if (object instanceof ZonedDateTime) {
            return (ZonedDateTime)object;
        }
        if (object instanceof Number) {
            Instant instant = Instant.ofEpochMilli(((Number)object).longValue());
            return ZonedDateTime.ofInstant(instant, LocaleInfo.getNonNull(localeInfo, false).getZoneId());
        }
        if (object instanceof LocalDateTime) {
            LocalDateTime localDateTime = (LocalDateTime)object;
            return ZonedDateTime.of(localDateTime, LocaleInfo.getNonNull(localeInfo, false).getZoneId());
        }
        if (object instanceof OffsetDateTime) {
            OffsetDateTime offsetDateTime = (OffsetDateTime)object;
            return offsetDateTime.toZonedDateTime();
        }
        if (object instanceof Timestamp) {
            Timestamp timestamp = (Timestamp)object;
            return ZonedDateTime.of(timestamp.toLocalDateTime(), LocaleInfo.getNonNull(localeInfo, false).getZoneId());
        }
        if (object instanceof Date) {
            Date date = (Date)object;
            Instant instant = Instant.ofEpochMilli(date.getTime());
            return ZonedDateTime.ofInstant(instant, LocaleInfo.getNonNull(localeInfo, false).getZoneId());
        }
        if (object instanceof GregorianCalendar) {
            return ((GregorianCalendar)object).toZonedDateTime();
        }
        if (type != null && (l2 = type.valueObject.asLongCast(object, localeInfo)) != Long.MIN_VALUE) {
            Instant instant = Instant.ofEpochMilli(l2);
            return ZonedDateTime.ofInstant(instant, LocaleInfo.getNonNull(localeInfo, false).getZoneId());
        }
        String string = type != null ? type.valueObject.toStringForced(object) : String.valueOf(object);
        try {
            return ZonedDateTime.parse(string);
        }
        catch (DateTimeParseException dateTimeParseException) {
            throw new ParseException(dateTimeParseException.getMessage(), dateTimeParseException.getErrorIndex());
        }
    }

    @Override
    public long asLong(ZonedDateTime zonedDateTime, LocaleInfo localeInfo) {
        return zonedDateTime.toInstant().toEpochMilli();
    }
}

