/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.value;

import com.iizix.LocaleInfo;
import com.iizix.Value;
import com.iizix.value.TermporalAccessorValue;
import java.sql.Timestamp;
import java.text.ParseException;
import java.time.Clock;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.xml.datatype.XMLGregorianCalendar;

public class OffsetTimeValue
extends TermporalAccessorValue<OffsetTime> {
    private static final OffsetTime a = OffsetTime.of(LocalTime.MIDNIGHT, ZoneOffset.UTC);

    @Override
    public final Value.Type getValueType() {
        return Value.Type.OffsetTime;
    }

    @Override
    public Class<OffsetTime> getValueClass() {
        return OffsetTime.class;
    }

    @Override
    public String getDescription() {
        return "Time with an offset from UTC/Greenwich in the ISO-8601 calendar system, such as 10:15:30+01:00";
    }

    @Override
    public OffsetTime createDefault() {
        return a;
    }

    @Override
    public OffsetTime parse(String string) throws ParseException, Exception {
        try {
            return OffsetTime.parse(string);
        }
        catch (DateTimeParseException dateTimeParseException) {
            throw new ParseException(dateTimeParseException.getMessage(), dateTimeParseException.getErrorIndex());
        }
    }

    @Override
    public OffsetTime parse(String string, DateTimeFormatter dateTimeFormatter) throws ParseException, Exception {
        try {
            return OffsetTime.parse(string, dateTimeFormatter);
        }
        catch (DateTimeParseException dateTimeParseException) {
            throw new ParseException(dateTimeParseException.getMessage(), dateTimeParseException.getErrorIndex());
        }
    }

    @Override
    public OffsetTime convert(Object object, Value.Type type, LocaleInfo localeInfo) throws Exception {
        long l2;
        if (object instanceof OffsetTime) {
            return (OffsetTime)object;
        }
        if (object instanceof Number) {
            Instant instant = Instant.ofEpochMilli(((Number)object).longValue());
            return OffsetTime.ofInstant(instant, LocaleInfo.getNonNull(localeInfo, false).getZoneOffset());
        }
        if (object instanceof LocalTime) {
            LocalTime localTime = (LocalTime)object;
            return OffsetTime.of(localTime, LocaleInfo.getNonNull(localeInfo, false).getZoneOffset());
        }
        if (object instanceof LocalDateTime) {
            LocalDateTime localDateTime = (LocalDateTime)object;
            return OffsetTime.of(localDateTime.toLocalTime(), LocaleInfo.getNonNull(localeInfo, false).getZoneOffset());
        }
        if (object instanceof OffsetDateTime) {
            OffsetDateTime offsetDateTime = (OffsetDateTime)object;
            return offsetDateTime.toOffsetTime();
        }
        if (object instanceof ZonedDateTime) {
            ZonedDateTime zonedDateTime = (ZonedDateTime)object;
            return zonedDateTime.toOffsetDateTime().toOffsetTime();
        }
        if (object instanceof Clock) {
            Clock clock = (Clock)object;
            LocalTime localTime = LocalTime.from(clock.instant());
            return OffsetTime.of(localTime, LocaleInfo.getNonNull(localeInfo, false).getZoneOffset());
        }
        if (object instanceof Timestamp) {
            Timestamp timestamp = (Timestamp)object;
            LocalTime localTime = LocalTime.of(timestamp.getHours(), timestamp.getMinutes(), timestamp.getSeconds(), timestamp.getNanos());
            return OffsetTime.of(localTime, LocaleInfo.getNonNull(localeInfo, false).getZoneOffset());
        }
        if (object instanceof Date) {
            Date date = (Date)object;
            LocalTime localTime = LocalTime.of(date.getHours(), date.getMinutes(), date.getSeconds(), (int)(date.getTime() % 1000L) * 1000000);
            return OffsetTime.of(localTime, LocaleInfo.getNonNull(localeInfo, false).getZoneOffset());
        }
        if (object instanceof XMLGregorianCalendar) {
            object = ((XMLGregorianCalendar)object).toGregorianCalendar();
        }
        if (object instanceof GregorianCalendar) {
            return ((GregorianCalendar)object).toZonedDateTime().toOffsetDateTime().toOffsetTime();
        }
        if (type != null && (l2 = type.valueObject.asLongCast(object, localeInfo)) != Long.MIN_VALUE) {
            return OffsetTime.ofInstant(Instant.ofEpochMilli(l2), LocaleInfo.getNonNull(localeInfo, false).getZoneOffset());
        }
        String string = type != null ? type.valueObject.toStringForced(object) : String.valueOf(object);
        try {
            return OffsetTime.parse(string);
        }
        catch (DateTimeParseException dateTimeParseException) {
            throw new ParseException(dateTimeParseException.getMessage(), dateTimeParseException.getErrorIndex());
        }
    }

    @Override
    public long asLong(OffsetTime offsetTime, LocaleInfo localeInfo) {
        return offsetTime.toLocalTime().toNanoOfDay() / 1000000L;
    }
}

