/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.value;

import com.iizix.LocaleInfo;
import com.iizix.Value;
import com.iizix.value.TermporalAccessorValue;
import java.text.ParseException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.xml.datatype.XMLGregorianCalendar;

public class LocalDateValue
extends TermporalAccessorValue<LocalDate> {
    @Override
    public final Value.Type getValueType() {
        return Value.Type.LocalDate;
    }

    @Override
    public Class<LocalDate> getValueClass() {
        return LocalDate.class;
    }

    @Override
    public String getDescription() {
        return "Date without a time-zone in the ISO-8601 calendar system, such as 2007-12-03";
    }

    @Override
    public LocalDate createDefault() {
        return LocalDate.of(1970, 1, 1);
    }

    @Override
    public LocalDate parse(String string) throws ParseException, Exception {
        try {
            return LocalDate.parse(string);
        }
        catch (DateTimeParseException dateTimeParseException) {
            throw new ParseException(dateTimeParseException.getMessage(), dateTimeParseException.getErrorIndex());
        }
    }

    @Override
    public LocalDate parse(String string, DateTimeFormatter dateTimeFormatter) throws ParseException, Exception {
        try {
            return LocalDate.parse(string, dateTimeFormatter);
        }
        catch (DateTimeParseException dateTimeParseException) {
            throw new ParseException(dateTimeParseException.getMessage(), dateTimeParseException.getErrorIndex());
        }
    }

    @Override
    public LocalDate convert(Object object, Value.Type type, LocaleInfo localeInfo) throws Exception {
        long l2;
        if (object instanceof LocalDate) {
            return (LocalDate)object;
        }
        if (object instanceof Number) {
            return LocalDate.from(Instant.ofEpochMilli(((Number)object).longValue()));
        }
        if (object instanceof LocalDateTime) {
            LocalDateTime localDateTime = (LocalDateTime)object;
            return localDateTime.toLocalDate();
        }
        if (object instanceof OffsetDateTime) {
            OffsetDateTime offsetDateTime = (OffsetDateTime)object;
            return offsetDateTime.toLocalDate();
        }
        if (object instanceof ZonedDateTime) {
            ZonedDateTime zonedDateTime = (ZonedDateTime)object;
            return zonedDateTime.toLocalDate();
        }
        if (object instanceof Date) {
            Date date = (Date)object;
            return LocalDate.of(date.getYear() + 1900, date.getMonth() + 1, date.getDate());
        }
        if (object instanceof XMLGregorianCalendar) {
            object = ((XMLGregorianCalendar)object).toGregorianCalendar();
        }
        if (object instanceof GregorianCalendar) {
            GregorianCalendar gregorianCalendar = (GregorianCalendar)object;
            int n2 = gregorianCalendar.get(5);
            int n3 = gregorianCalendar.get(2);
            int n4 = gregorianCalendar.get(1);
            return LocalDate.of(n4, n3, n2);
        }
        if (type != null && (l2 = type.valueObject.asLongCast(object, localeInfo)) != Long.MIN_VALUE) {
            return LocalDate.from(Instant.ofEpochMilli(l2));
        }
        String string = type != null ? type.valueObject.toStringForced(object) : String.valueOf(object);
        try {
            return LocalDate.parse(string);
        }
        catch (DateTimeParseException dateTimeParseException) {
            throw new ParseException(dateTimeParseException.getMessage(), dateTimeParseException.getErrorIndex());
        }
    }

    @Override
    public long asLong(LocalDate localDate, LocaleInfo localeInfo) {
        return localDate.toEpochDay() * 86400000L;
    }
}

